/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.BlockCipher;
import cryptix.security.StreamCipher;

public class CFB
extends StreamCipher {
    protected BlockCipher cipher;
    protected int blocksize;
    protected byte[] iv;
    protected byte[] k;
    protected int bytesLeft;

    public CFB(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blocksize = blockCipher.blockLength();
        this.iv = new byte[this.blocksize];
        this.k = new byte[this.blocksize];
        this.reset();
    }

    public int keyLength() {
        return this.cipher.keyLength();
    }

    public void next_block() {
        this.bytesLeft = 0;
    }

    public void reset() {
        this.bytesLeft = 0;
        int n = this.blocksize - 1;
        while (n >= 0) {
            this.iv[n] = 0;
            --n;
        }
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4 + n2] = this.encryptByte(byArray[n4 + n]);
            ++n4;
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4 + n2] = this.decryptByte(byArray[n4 + n]);
            ++n4;
        }
    }

    private byte encryptByte(byte by) {
        if (this.bytesLeft <= 0) {
            this.bytesLeft = this.blocksize;
            this.cipher.encrypt(this.iv, 0, this.k, 0);
        }
        by = (byte)(by ^ this.k[this.blocksize - this.bytesLeft]);
        System.arraycopy(this.iv, 1, this.iv, 0, this.blocksize - 1);
        this.iv[this.blocksize - 1] = by;
        --this.bytesLeft;
        return by;
    }

    private byte decryptByte(byte by) {
        if (this.bytesLeft <= 0) {
            this.bytesLeft = this.blocksize;
            this.cipher.encrypt(this.iv, 0, this.k, 0);
        }
        byte by2 = by;
        by = (byte)(by ^ this.k[this.blocksize - this.bytesLeft]);
        System.arraycopy(this.iv, 1, this.iv, 0, this.blocksize - 1);
        this.iv[this.blocksize - 1] = by2;
        --this.bytesLeft;
        return by;
    }
}

