/////////////////////////////////////////////////////////////////////////////
// PGPMail.java
//
//    A simple applet which combines the encryption of the Cryptix PGP
//    library with the email of the Qsmpt class to provide a secure email
//    application.
//    
//    by Paul Ramsey, April 1997
//
/////////////////////////////////////////////////////////////////////////////

import cryptix.pgp.*;
import cryptix.math.PseudoRandomStream;
import cryptix.crypt.MD5;
import cryptix.crypt.SHA;
import cryptix.crypt.rsa.PublicKey;
import java.awt.*;
import java.net.*;
import java.io.*;

public class PGPMail extends java.applet.Applet {
	
	String pubstr = null;
	
	TextField toFld = new TextField(),
	        fromFld = new TextField(),
	        subjFld = new TextField();
	
	TextArea messFld = new TextArea();
	
	Button sndBut = new Button("Send"),
	       clrBut = new Button("Clear");
	
	Label statusLbl = new Label("", Label.CENTER);
	
	private void err(String str) {
		statusLbl.setText(str);
		System.err.println(str);
		return;
		}
	
	public void init() {
		
		try {
			pubstr = getParameter("PublicKey");
			if(pubstr == null) {
				err("\"PublicKey\" parameter is empty.");
				return;
				}
			StringBuffer strbuf = new StringBuffer();
			URL puburl = new URL(getDocumentBase(), pubstr);
			DataInputStream dis = new DataInputStream(puburl.openStream());
			String inputLine;
			while ((inputLine = dis.readLine()) != null)
				strbuf.append(inputLine + "\n");
		    dis.close();
			pubstr = strbuf.toString();
		} catch (MalformedURLException me) {
			err("MalformedURLException: " + me);
			return;
		} catch (IOException ioe) {
			err("IOException: " + ioe);
			return;
			} 
		String toStr = getParameter("To");
		if(toStr == null) {
			err("\"To\" paramter is empty.");
			return;
		} else {
			toFld.setText(toStr);
			toFld.setEditable(false);
			}

		String subjStr = getParameter("Subject");
		if(subjStr != null)
			subjFld.setText(subjStr);
			
		String titleStr = getParameter("Title");
		if(titleStr == null)
			titleStr = "PGPMail : Encrypted Mail Applet";
		
		String fontStr = getParameter("Font");
		if(fontStr == null)
			fontStr = "Helvetica";
		
		String bgcolor = getParameter("BGColor");
		String fgcolor = getParameter("FGColor");
		if(bgcolor != null)
			setBackground(new Color(HexInteger.getInteger(bgcolor)));
		if(fgcolor != null)
			setForeground(new Color(HexInteger.getInteger(fgcolor)));
		
		setLayout(new BorderLayout());
		Label title = new Label(titleStr, Label.CENTER);
		title.setFont(new Font("Helvetica", Font.BOLD, 20));
		add("North", title);
		Font F = new Font("Helvetica", Font.BOLD, 12);
		Panel Q = new Panel();
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		Q.setLayout(gbl);
		Label toLbl = new Label("To:");
		toLbl.setFont(F);
		Label fromLbl = new Label("From:");
		fromLbl.setFont(F);
		Label subjLbl = new Label("Subject:");
		subjLbl.setFont(F);
		
		c.insets = new Insets(4, 4, 4, 4);
		c.fill = GridBagConstraints.HORIZONTAL;
		
		gbl.setConstraints(toLbl, c);
		Q.add(toLbl);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		gbl.setConstraints(toFld, c);
		Q.add(toFld);
		
		c.gridwidth = 1;
		gbl.setConstraints(fromLbl, c);
		Q.add(fromLbl);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		gbl.setConstraints(fromFld, c);
		Q.add(fromFld);

		c.gridwidth = 1;
		gbl.setConstraints(subjLbl, c);
		Q.add(subjLbl);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		gbl.setConstraints(subjFld, c);
		Q.add(subjFld);
		
		c.gridheight = 8;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.BOTH;
		gbl.setConstraints(messFld, c);
		messFld.setEditable(true);
		Q.add(messFld);

		c.gridheight = 1;
		c.fill = GridBagConstraints.HORIZONTAL;
		gbl.setConstraints(statusLbl, c);
		statusLbl.setFont(F);
		Q.add(statusLbl);
		
		add("Center", Q);

		Panel P = new Panel();
		P.setLayout(new FlowLayout());
		sndBut.setFont(F);
		clrBut.setFont(F);
		P.add(sndBut);
		P.add(clrBut);
		add("South", P);
		}

	private String encode(String plaintxt, PublicKey pk, String strseed)
	throws IOException {
		java.util.Date d = new java.util.Date();
		String seed = strseed + String.valueOf(d.getTime());
		byte[] ideakey = MD5.hash(seed);
		int plainlen = plaintxt.length();
		byte[] plainbyte = new byte[plainlen];
		plaintxt.getBytes(0, plainlen, plainbyte, 0);
		PseudoRandomStream rs = new PseudoRandomStream(SHA.hash(seed));
		PublicKeyEncrypted cipherhead = new PublicKeyEncrypted(pk, ideakey, rs);
		LiteralData plainfile = new LiteralData(plainbyte, "email.txt", 't');
		byte[] plainbuff = PacketFactory.save(plainfile);
		ConvEncryptedData cipherbody = new ConvEncryptedData(plainbuff, ideakey, rs);
		ByteArrayOutputStream byteout = new ByteArrayOutputStream();
		DataOutputStream out = new DataOutputStream(byteout);
		PacketFactory.write(out, cipherhead);
		PacketFactory.write(out, cipherbody);
		byte[] cipherbyte = byteout.toByteArray();
		String ciphertxt = "-----BEGIN PGP MESSAGE-----\n";
		ciphertxt += "Version: 2.6.2\n";
		ciphertxt += "Comment: Generated by Java PGPMail\n\n";
		ciphertxt += Armoury.encodeWithChecksum(cipherbyte);
		ciphertxt += "-----END PGP MESSAGE-----\n";
		return ciphertxt;
		}

	private void send(Event evt) {

		String message = messFld.getText(),
		          from = fromFld.getText(),
		            to = toFld.getText(),
		       subject = subjFld.getText(),
		          host = getCodeBase().getHost();
		
		if(from.indexOf('@') < 0)
			err("Invalid From Address");
		else {	
			try {
				StringBufferInputStream in = new StringBufferInputStream(pubstr);
				Armoury asciin = new Armoury(in);
				PublicKeyCertificate pubcrt = (PublicKeyCertificate)asciin.read();
				PublicKey pubkey = pubcrt.publicKey();
				String randomseed = String.valueOf(evt.x) + String.valueOf(evt.y);
				message = encode(message, pubkey, randomseed);
				err("Sending Message ...");
				Qsmtp connect = new Qsmtp(host);
				connect.sendmsg(from, to, subject, message);
			} catch(IOException ioe) {
				err("IOException: " + ioe);
				return;
			} catch(InvalidChecksumException e) {
				err("InvalidChecksumException: " + e);
				return;
				}

			clear(false);
			err("Message Sent"); 		
			}
		return;
		}

	private void clear(boolean show) {
		fromFld.setText("");
		subjFld.setText("");
		messFld.setText("");
		if(show)
			err("Data Fields Cleared");
		}

	public boolean action(Event evt, Object o) {
		boolean ret = false;
		if(evt.target == sndBut) {
			err("Encrypting Message Data ...");
			send(evt);
			ret = true;
			}
		else if(evt.target == clrBut) {
			clear(true);
			ret = true;
			}
		return ret;
		}

	public String getAppletInfo() {
		return "PGPMail 1.0 (April 1997) by Paul Ramsey";
		}

	public String[][] getParameterInfo() {
		String[][] info = {
			{"PublicKey", "String", "File containing ascii PGP public key."},
			{"To", "String", "Email address mail will be directed to."},
			{"BGColor", "Hex", "Hex representation of background color."},
			{"FGColor", "Hex", "Hex representation of foreground color."},
			{"Title", "String", "Title to display over applet."},
			{"Font", "String", "Font for applet labels and buttons."},
			{"Subject", "String", "Default subject string to use."}
			};
		return info;
		}
	
	}	