﻿import mx.controls.*;
import mx.utils.Delegate;
import flash.net.*;
import UploadQueue;

var browseLabel:Label;
var browseButton:Button;
var clearButton:Button;
var uploadFilesList:List;
var uploadButton:Button;
var uploadProgressBar:ProgressBar;



function main () 
{
	
	Stage.scaleMode = "noScale";
	Stage.align = "TL";
	stop ();

	fileTypes = [
		{description:"All files", extension:"*.*"}
	];

	if (uploadUrl == null) 
	{
		showAlert("Error","Upload script URL is empty");
		return;
	};

	if (maxFileSize == null) 
	{
		showAlert("Error","MaxFileSize is empty");
		return;
	};

	appUrl = _url.substring (0, _url.lastIndexOf ("/"));

	browseButton.enabled = true;
	uploadButton.enabled = false;
	uploadProgressBar.visible = false;

	uploadFilesList.dataProvider = [];
	uploadFilesList.labelFunction = function (data:Object):String 
	{
		return (data.name + " (" + Math.round (data.size/1024) + "kb)");
	};

	var buttonDelegate:Function = Delegate.create (this, buttonChanged);
	browseButton.addEventListener ("click", buttonDelegate);
	clearButton.addEventListener ("click", buttonDelegate);
	uploadButton.addEventListener ("click", buttonDelegate);

	uploadRefList = new FileReferenceList ();
	uploadRefListener = new Object ();
	uploadRefListener.onSelect = function (refList:FileReferenceList) 
	{
		if(maxFileSize != -1) 
		{
			var invalidFiles:Number = 0;
			var n:Number = refList.fileList.length;
			var s:String = "Only files smaller than " + maxFileSize/1024 + "Kb are allowed. ";
			var file:FileReference;
			for (var i:Number = 0; i < n; ++i) 
			{
				file = refList.fileList [i];
				if (file.size > maxFileSize) 
				{
					refList.fileList.splice (i, 1);
					invalidFiles++;
				};
			};

			if (invalidFiles > 0) 
			{
				s += invalidFiles + " files were ignored.";
				showAlert ("Error", s);
			};
		}
		uploadFilesList.dataProvider = uploadFilesList.dataProvider.concat (refList.fileList);
		uploadButton.enabled = uploadFilesList.dataProvider.length;
	};

	uploadRefList.addListener (uploadRefListener);

	uploadQueue = new UploadQueue (uploadUrl);
	uploadDelegate = Delegate.create (this, uploadQueueChanged);

	uploadQueue.addEventListener ("start", uploadDelegate);
	uploadQueue.addEventListener ("progress", uploadDelegate);
	uploadQueue.addEventListener ("error", uploadDelegate);
	uploadQueue.addEventListener ("complete", uploadDelegate);


};

function showAlert (title:String, message:String) 
{
	message += "\t\r\r\r";

	Alert.yesLabel = "Ok";
	Alert.show (message, title, Alert.OK);
};

function trace2 () 
{
	trace (arguments.join (" : "));
};


function buttonChanged (eventObj:Object) 
{
	switch (eventObj.target) 
	{
	
		case browseButton:
			uploadRefList.browse (fileTypes);
			break;
		
		case clearButton:
			uploadFilesList.dataProvider = [];
			uploadButton.enabled = false;
			break;

		case uploadButton:
			uploadQueue.start (uploadFilesList.dataProvider);
			break;


	};
};

function uploadQueueChanged (eventObj:Object) 
{
	switch (eventObj.type) 
	{
	
		case "start":
			uploadProgressBar.visible = true;
			uploadProgressBar.label = "Uploading Files ...";
			uploadButton.enabled = false;
			break;
		
		case "progress":
			uploadProgressBar.setProgress (eventObj.percent, 100);
			break;

		case "complete":
			uploadProgressBar.label = "Upload Complete";
			uploadButton.enabled = true;
			clearButton.dispatchEvent ({type:"click"});
			break;

		case "error":
			uploadButton.enabled = true;
			showAlert (eventObj.info, "Error");
			break;
		
	};
};


main ();