/*
 FILE: 			ExtractorXSpec.java
 
 Builds a sources XML document (XSpec) describing a database schema.
 User provides URL of database system and information is extracted using JDBC.
 
 Notes:
 - An XSpec must be produced for each database to be queried by the Unity system.
 
 - The <semanticTableName> and <semanticFieldName> tags for each table and field can be used to assign your own
 names to tables and fields in the sources.  Those names can then be used in queries.
 */

package unity.extractor;

import java.sql.*;
import java.io.*;

public class ExtractorXSpec
{
	public static void main(String [] args) throws Exception
	{
		// Enter the URL of your database here that you require the XSpec for
		// Microsoft SQL Server example
		String url = "jdbc:microsoft:sqlserver://IDEALAB5.cs.uiowa.edu:1433;DatabaseName=tpch100;User=unitydemo;Password=test";
		
		// MySQL Example
		// String url = "jdbc:mysql://<yourserverAddress>:3306/<databaseName>?user=<userId>&password=<password>";
		
		// Enter the JDBC driver name (driver must be in your classpath) for the chosen DBMS
		// Microsoft SQL Server driver
		String driverName = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
		// MySQL Driver
		// String driverName = "com.mysql.jdbc.Driver";
		
		// Enter the local path (absolute or relative to current directory) of output XML file (XSpec)
		String outputFileName = "Tests\\xspec\\test2.xml";
			
		if (args.length == 3)
		{	// Allow over write of compile-time parameters by run-time arguments in order of: url, driverName, outputFileName
			url = args[0];
			driverName = args[1];
			outputFileName = args[2];
		}
		
		Connection con;

		try
		{	// Make database connection
		    Class.forName(driverName).newInstance();
		    con = DriverManager.getConnection(url);
        	System.out.println("Connection established to database.");
        	
        	// Extract database schema information into local data structure
            AnnotatedExtractor extractor = new AnnotatedExtractor();
            System.out.println("Extracting schema information.");
            extractor.extract(con);
            
            // Write out schema information into an XML file
            System.out.println("Writing information into XML file.");
            File xSpec = new File(outputFileName);
            extractor.exportXML(xSpec);
            
            System.out.println("Operation complete.");
		}
		catch(ClassNotFoundException ce)
		{	System.out.println("ClassNotFoundException for Driver: "+ce.getMessage());}
		catch (SQLException sqlEx)
        { System.out.println("SQLException "+ sqlEx.getMessage()); }
   	}
}
