/*
 FILE: 			ExampleMerge.java

 A test file for using the MERGE syntax.  The MERGE function allows a full-outer join to be computed between two subqueries.
 The join result can then use special MATCH functions to match attributes.  Finally, a FILTER clause, similar to a HAVING clause, can be applied.

 Syntax:
 <subquery>
 MERGE [ON] [<join condition>] EXTRACT [ALL] <MatchFuncList> [FILTER] [<filterCondition>]
 <subquery>

 Notes:
 1) You can have multiple MERGE statements.  They are evaluated in the order they appear.
 2) If no join condition is specified, a cross-product is performed.  The join is always a full-outer join.
 3) Only equi-join conditions are supported in the join condition clause.
 4) If the ALL keyword is used, all attributes that are not in a MATCH function and put in output.  Otherwise,
 only the specified attributes and MATCH function results are output.
 5) A Match function takes two attributes IN THE SAME ROW and returns a single attribute.  Match functions include:
 - MAX(A,B) - Maximum of two attributes
 - MIN(A,B) - Minimum of two attributes
 - SUM(A,B) - Sum of two attributes (numeric values only)
 - Choose(A,B,i) - Choose either first (i=1) or second (i=2) of two specified attributes.
 - ChooseNN(A,B,i) - Same as choose but will take other choice if the prefered choice is NULL.
 - Group(A,B) - puts two attributes in a single ArrayList object
 - Also have functions that maintain the source information on where the value came from.
 - MINREF(A,B) - Same as MIN(A,B) but stores source of value selected in AttributeValueSource object
 - MAXREF(A,B) - Same as MAX(A,B) but stores source of value selected in AttributeValueSource object
 - GROUPREF(A,B) - Same as GROUP)A,B) but stores source of values
 - Note that if you do not track the sources for one MATCH function they are lost to one that does.
 -  Example:  MAXREF(A,MIN(B,C)) - since MIN(B,C) does not keep track of source information, it is UNKNOWN to the MAXREF function
 6) Attributes can either be refered to by their name in the SELECT list of each subquery (recommend using AS) or
 by query and column number.  For example, Q1.C2 is query 1 column 2.
 7) Attributes can be put in the EXTRACT list that are not in a MATCH function.
 8) The FILTER clause is applied after the MATCH functions.	Similar to a HAVING the attributes it references must
 be avaiable to it and generally will be the result of MATCH functions.
 9) The GetValue(X) function can be used to return only the value in an AttributeValueSource object which stores the
 value and its source information.
 */

package Tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class ExampleMerge {
	public static void main(String[] args) throws Exception {
		// Change this line to reference the location of your sources XML file
		String url = "jdbc:Unity://Tests/xspec/UnityDemo.xml?debug=false";

		Connection con = null;
		Statement stmt = null;

		try {
			Class.forName("unity.jdbc.UnityDriver");
			con = DriverManager.getConnection(url);
			stmt = con.createStatement();

			String st = "SELECT N.n_nationkey, N.n_regionkey, N.n_name FROM OrderDB.Nation as N\n";
			st = st + " MERGE ON Q1.C1=Q2.C2 EXTRACT ALL MAXREF(Q1.C2*3,Q2.C1+5) AS M FILTER GetValue(M) > 5\n ";
			st = st + "SELECT N.n_regionkey, N.n_nationkey AS N2 FROM PartDB.Nation as N; \n";

			System.out.println("Executing query: \n" + st + "\n\n");

			ResultSet rst = stmt.executeQuery(st);

			int i = 0;
			ResultSetMetaData meta = rst.getMetaData();
			System.out.println("Total columns: " + meta.getColumnCount());
			System.out.print(meta.getColumnName(1));
			for (int j = 2; j <= meta.getColumnCount(); j++)
				System.out.print(", " + meta.getColumnName(j));
			System.out.println();

			while (rst.next()) {
				System.out.print(rst.getObject(1));
				for (int j = 2; j <= meta.getColumnCount(); j++)
					System.out.print(", " + rst.getObject(j));
				System.out.println();
				i++;
			}
			System.out.println("Results tuples are " + i);
		} catch (SQLException e) {
			System.out.println(e);
		} finally {
			if (stmt != null)
				stmt.close();
			if (con != null)
				con.close();
		}
	}
}
