/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceJoin;
import unity.annotation.AnnotatedSourceKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceField;
import unity.annotation.SourceKey;

public class DGraph {
    public static final int MAX_VAL = Integer.MAX_VALUE;
    public static final int MIN_VAL = Integer.MIN_VALUE;
    private TreeMap nodeList;
    private ArrayList cycleNodes;
    private ArrayList nodeMap = new ArrayList();

    public DGraph() {
        this.nodeList = new TreeMap();
    }

    public ArrayList getNodeMap() {
        return this.nodeMap;
    }

    public void setNodeMap(ArrayList nodes) {
        this.nodeMap = nodes;
    }

    public boolean addNode(String label, int weight) {
        if (this.nodeList.containsKey(label)) {
            return false;
        }
        Node n = new Node(label, weight);
        this.nodeList.put(label, n);
        return true;
    }

    public boolean addNode(String label, int weight, Object ob) {
        if (this.nodeList.containsKey(label)) {
            return false;
        }
        Node n = new Node(label, weight);
        this.nodeList.put(label, n);
        n.setObject(ob);
        return true;
    }

    public Node getNode(String nodeLabel) {
        return (Node)this.nodeList.get(nodeLabel);
    }

    public int getWeight(String nodeLabel) {
        Node n = (Node)this.nodeList.get(nodeLabel);
        return n.getWeight();
    }

    public int numNodes() {
        return this.nodeList.size();
    }

    public void removeNode(String nodeLabel) {
        this.nodeList.remove(nodeLabel);
    }

    public ArrayList getNodes() {
        ArrayList a = new ArrayList(this.nodeList.values());
        return a;
    }

    public TreeMap getNodeList() {
        return this.nodeList;
    }

    public boolean addEdge(String from, String to, String label, int w, Object join) {
        Node toN = this.getNode(to);
        if (toN == null) {
            return false;
        }
        boolean b = toN.addEdge(from, label, w);
        if (b) {
            Edge e = this.getEdge(label);
            e.setObject(join);
            return true;
        }
        return false;
    }

    public boolean addEdge(String fromNodeLabel, String toNodeLabel, String edgeLabel, int weight) {
        Node toN = this.getNode(toNodeLabel);
        if (toN == null) {
            return false;
        }
        return toN.addEdge(fromNodeLabel, edgeLabel, weight);
    }

    public boolean addEdge(String fromNodeLabel, String toNodeLabel, int weight) {
        return this.addEdge(fromNodeLabel, toNodeLabel, String.valueOf(fromNodeLabel) + "-" + toNodeLabel, weight);
    }

    public Edge getEdge(String edgeLabel) {
        ArrayList edgeList = this.getEdgeList();
        int i = 0;
        while (i < edgeList.size()) {
            Edge e = (Edge)edgeList.get(i);
            if (e.getLabel().equals(edgeLabel)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public int getTotalWeight() {
        ArrayList edgeList = this.getEdgeList();
        int total = 0;
        int i = 0;
        while (i < edgeList.size()) {
            Edge e = (Edge)edgeList.get(i);
            total += e.getWeight();
            ++i;
        }
        return total;
    }

    public Edge getEdge(String toNodeLabel, String edgeLabel) {
        Node toN = this.getNode(toNodeLabel);
        if (toN == null) {
            return null;
        }
        return toN.getEdge(edgeLabel);
    }

    public Edge getEdgeByNodes(String toNodeLabel, String fromNodeLabel) {
        Node toN = this.getNode(toNodeLabel);
        if (toN == null) {
            return null;
        }
        return toN.getEdgeByNode(fromNodeLabel);
    }

    public void removeEdge(String edgeLabel) {
        Edge e = this.getEdge(edgeLabel);
        Node toNode = this.getNode(e.getToNode());
        toNode.removeEdge(edgeLabel);
    }

    public void removeEdgeByNodes(String fromNodeLabel, String toNodeLabel) {
        Node toNode = this.getNode(toNodeLabel);
        toNode.removeEdge(fromNodeLabel);
    }

    public boolean isEdgeByNodes(String fromNode, String toNode) {
        Node toN = this.getNode(toNode);
        if (toN == null) {
            return false;
        }
        return toN.isEdgeByNode(fromNode);
    }

    public boolean isEdge(String edgeLabel) {
        return this.getEdge(edgeLabel) != null;
    }

    public ArrayList getIncomingEdges(String nodeLabel) {
        Node n = this.getNode(nodeLabel);
        return n.getEdges();
    }

    public ArrayList getOutgoingEdges(String nodeLabel) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            ArrayList a = n.getEdges();
            int i = 0;
            while (i < a.size()) {
                Edge e = (Edge)a.get(i);
                if (e.getFromNode().equals(nodeLabel)) {
                    result.add(e);
                }
                ++i;
            }
        }
        return result;
    }

    public void removeIncomingEdges(String node) {
        Node n = this.getNode(node);
        if (n == null) {
            return;
        }
        n.removeAllInEdges();
    }

    public Edge findMaxInEdge(String node) {
        ArrayList a = this.getIncomingEdges(node);
        int maxVal = Integer.MIN_VALUE;
        Edge result = null;
        int i = 0;
        while (i < a.size()) {
            Edge e = (Edge)a.get(i);
            if (e.getToNode() == node && e.getWeight() > maxVal) {
                maxVal = e.getWeight();
                result = e;
            }
            ++i;
        }
        return result;
    }

    public ArrayList getEdgeList() {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            ArrayList a = n.getEdges();
            int i = 0;
            while (i < a.size()) {
                Edge e = (Edge)a.get(i);
                edgeList.add(e);
                ++i;
            }
        }
        return edgeList;
    }

    public void removeAllEdges() {
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            n.removeAllInEdges();
        }
    }

    public boolean hasCycle() {
        this.clearAllMarkers();
        this.clearAllVisited();
        this.cycleNodes = new ArrayList();
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean result;
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            if (n.getVisited() || !(result = this.hasCycleHelper(n.getLabel()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasCycleHelper(String curNode) {
        Node n = this.getNode(curNode);
        if (n.getMarker() >= 1) {
            return true;
        }
        boolean result = false;
        this.cycleNodes.add(n);
        n.setMarker(1);
        n.setVisited(true);
        ArrayList a = this.getOutgoingEdges(curNode);
        int i = 0;
        while (i < a.size()) {
            Edge e = (Edge)a.get(i);
            result = this.hasCycleHelper(e.getToNode());
            if (result) {
                return true;
            }
            ++i;
        }
        n.setMarker(0);
        this.cycleNodes.remove(this.cycleNodes.size() - 1);
        return false;
    }

    public Object clone() {
        DGraph copy = new DGraph();
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            copy.addNode(n.getLabel(), n.getWeight());
            ArrayList a = n.getEdges();
            String tn = n.getLabel();
            int i = 0;
            while (i < a.size()) {
                Edge e = (Edge)a.get(i);
                copy.addEdge(e.getFromNode(), tn, e.getLabel(), e.getWeight());
                ++i;
            }
        }
        return copy;
    }

    public void shortestAllVertices() {
        ArrayList nodes = this.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            String label = ((Node)nodes.get(i)).getLabel();
            this.nodeMap.add(label);
            ++i;
        }
        i = 0;
        while (i < nodes.size()) {
            Node n = (Node)nodes.get(i);
            this.Dijkstra(n.getLabel());
            this.storePathData(n.getLabel());
            ++i;
        }
    }

    public void Dijkstra(String nodeLabel) {
        this.createDijkstraInitialGraph(nodeLabel);
        MinQueue mq = new MinQueue(this);
        while (!mq.isEmpty()) {
            Node u = mq.extractMin();
            ArrayList outgoing = this.getOutgoingEdges(u.getLabel());
            int i = 0;
            while (i < outgoing.size()) {
                Edge e = (Edge)outgoing.get(i);
                Node v = this.getNode(e.getToNode());
                int weight = e.getWeight();
                this.relax(u, v, weight, mq, e);
                ++i;
            }
        }
    }

    private void relax(Node u, Node v, int w, MinQueue mq, Edge e) {
        if (v.getDistance() == u.getDistance() + w) {
            v.setTie(true);
            AnnotatedSourceKey primaryKey = (AnnotatedSourceKey)((AnnotatedSourceTable)u.getObject()).getPrimaryKey();
            SourceKey fromKey = ((AnnotatedSourceJoin)e.getObject()).getFromKey();
            boolean uBool = fromKey.getKeyType() == 1 ? true : this.isFKeyInPKey(primaryKey, (AnnotatedSourceForeignKey)fromKey);
            Edge eTaken = v.getEdgeTaken();
            AnnotatedSourceKey primaryKey2 = (AnnotatedSourceKey)((AnnotatedSourceTable)this.getNode(e.getFromNode()).getObject()).getPrimaryKey();
            SourceKey fromKey2 = ((AnnotatedSourceJoin)eTaken.getObject()).getFromKey();
            boolean pBool = fromKey2.getKeyType() == 1 ? true : this.isFKeyInPKey(primaryKey2, (AnnotatedSourceForeignKey)fromKey2);
            if (uBool && pBool) {
                if (primaryKey == fromKey && primaryKey2 == fromKey2) {
                    if (primaryKey.getFields().size() > primaryKey.getFields().size()) {
                        v.setEdgeTaken(e);
                    }
                } else if (primaryKey != fromKey) {
                    if (primaryKey2 == fromKey2) {
                        v.setEdgeTaken(e);
                    } else if (primaryKey.getFields().size() > primaryKey.getFields().size()) {
                        v.setEdgeTaken(e);
                    }
                }
            } else if (uBool) {
                v.setEdgeTaken(e);
            }
        }
        if (v.getDistance() > u.getDistance() + w) {
            int index = mq.indexQueue(v.getLabel());
            mq.decreaseKey(index, u.getDistance() + w);
            v.setEdgeTaken(e);
            if (u.getTie()) {
                v.setTie(true);
            }
        }
    }

    public boolean isFKeyInPKey(AnnotatedSourceKey pkey, AnnotatedSourceForeignKey fkey) {
        ArrayList pKeyFields = pkey.getFields();
        ArrayList fKeyFields = fkey.getFields();
        int i = 0;
        while (i < pKeyFields.size()) {
            int j = 0;
            while (j < fKeyFields.size()) {
                if ((SourceField)pKeyFields.get(i) == (SourceField)fKeyFields.get(j)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void createDijkstraInitialGraph(String nodeName) {
        int maxDistance = Integer.MAX_VALUE;
        Iterator iterator = this.getNodeList().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            n.setDistance(maxDistance);
            n.setEdgeTaken(null);
            n.setTie(false);
        }
        Node startNode = this.getNode(nodeName);
        startNode.setDistance(0);
    }

    public void storePathData(String startLabel) {
        ArrayList nodes = this.getNodes();
        Node source = this.getNode(startLabel);
        String src = source.getLabel();
        int[] distances = new int[nodes.size()];
        Edge[] predecessor = new Edge[nodes.size()];
        boolean[] ties = new boolean[nodes.size()];
        int i = 0;
        while (i < nodes.size()) {
            Node destination = (Node)nodes.get(i);
            String dest = destination.getLabel();
            if (!src.equals(dest)) {
                int index = this.nodeMap.indexOf(dest);
                distances[index] = destination.getDistance();
                predecessor[index] = destination.getEdgeTaken();
                ties[index] = destination.getTie();
            }
            ++i;
        }
        source.setDistances(distances);
        source.setPredecessor(predecessor);
        source.setTies(ties);
    }

    public ArrayList getPath(String s, String v, DGraph d) {
        ArrayList<String> paths = new ArrayList<String>();
        while (!s.equals(v)) {
            Node n = d.getNode(v);
            if (n.getPredecessor() == null) {
                return null;
            }
            paths.add(0, v);
        }
        paths.add(0, s);
        return paths;
    }

    public void printPath(int s, int v, Edge[] paths) {
        if (s == v) {
            System.out.print("  " + this.nodeMap.get(s) + " ");
        } else {
            Edge e = paths[v];
            String previous = e.getFromNode();
            int prev = this.nodeMap.indexOf(previous);
            this.printPath(s, prev, paths);
            System.out.print(this.nodeMap.get(v) + " ");
        }
    }

    public ArrayList getJoinPath(ArrayList tableNames, ArrayList specifiedJoins) {
        ArrayList<AnnotatedSourceJoin> joinList = new ArrayList<AnnotatedSourceJoin>();
        DGraph joinGraph = new DGraph();
        String baseNode = (String)tableNames.get(0);
        int i = 0;
        while (i < tableNames.size()) {
            joinGraph.addNode((String)tableNames.get(i), 0);
            ++i;
        }
        i = 0;
        while (i < tableNames.size()) {
            baseNode = (String)tableNames.get(i);
            Node n = this.getNode(baseNode);
            int j = 0;
            while (j < tableNames.size()) {
                String toNode = (String)tableNames.get(j);
                if (!baseNode.equals(toNode)) {
                    int t = this.nodeMap.indexOf(toNode);
                    int distance = n.getDistance(t);
                    joinGraph.addEdge(baseNode, toNode, distance);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < specifiedJoins.size()) {
            AnnotatedSourceJoin asj = (AnnotatedSourceJoin)specifiedJoins.get(i);
            String from = asj.getFromTableName();
            String to = asj.getToTableName();
            Edge e = joinGraph.getEdgeByNodes(to, from);
            e.setObject(asj);
            e.setWeight(0);
            ++i;
        }
        ArrayList edgeList = joinGraph.getEdgeList();
        ArrayList joinPaths = new ArrayList();
        if (tableNames.size() <= 1) {
            return joinPaths;
        }
        joinPaths = joinGraph.computeMSTKruskal(tableNames, edgeList);
        int i2 = 0;
        while (i2 < joinPaths.size()) {
            Edge e = (Edge)joinPaths.get(i2);
            if (e.getWeight() < 1) {
                joinList.add((AnnotatedSourceJoin)e.getObject());
            } else {
                String from = e.getFromNode();
                Node source = this.getNode(from);
                String to = e.getToNode();
                int index = this.nodeMap.indexOf(to);
                Edge[] edges = source.getPredecessor();
                while (edges[index] != null) {
                    AnnotatedSourceJoin sj = (AnnotatedSourceJoin)edges[index].getObject();
                    if (joinList.indexOf(sj) < 0) {
                        joinList.add(sj);
                    }
                    String predecessor = edges[index].getFromNode();
                    index = this.nodeMap.indexOf(predecessor);
                }
            }
            ++i2;
        }
        return joinList;
    }

    public ArrayList computeMSTKruskal(ArrayList tableNames, ArrayList edgeList) {
        ArrayList<Edge> joinEdges = new ArrayList<Edge>();
        ArrayList sets = new ArrayList();
        sets.add(new TreeSet());
        this.quicksort(edgeList, 0, edgeList.size() - 1);
        Edge current = (Edge)edgeList.get(0);
        String from = current.getFromNode();
        String to = current.getToNode();
        ((TreeSet)sets.get(0)).add(from);
        ((TreeSet)sets.get(0)).add(to);
        joinEdges.add(current);
        int i = 1;
        while (i < edgeList.size()) {
            current = (Edge)edgeList.get(i);
            from = current.getFromNode();
            to = current.getToNode();
            int fB = 1000;
            int tB = 1000;
            int j = 0;
            while (j < sets.size()) {
                if (((TreeSet)sets.get(j)).contains(from)) {
                    fB = j;
                }
                if (((TreeSet)sets.get(j)).contains(to)) {
                    tB = j;
                }
                ++j;
            }
            if (fB == tB && fB < sets.size()) {
                if (current.getWeight() == 0) {
                    joinEdges.add(current);
                }
            } else if (fB < sets.size() && tB == 1000) {
                ((TreeSet)sets.get(fB)).add(to);
                joinEdges.add(current);
            } else if (tB < sets.size() && fB == 1000) {
                ((TreeSet)sets.get(tB)).add(from);
                joinEdges.add(current);
            } else if (tB < sets.size() && fB < sets.size()) {
                if (tB < fB) {
                    ((TreeSet)sets.get(tB)).addAll((TreeSet)sets.get(fB));
                    sets.remove(fB);
                } else {
                    ((TreeSet)sets.get(fB)).addAll((TreeSet)sets.get(tB));
                    sets.remove(tB);
                }
                joinEdges.add(current);
            } else {
                new TreeSet(tableNames);
                ArrayList<String> a = new ArrayList<String>();
                a.add(from);
                a.add(to);
                sets.add(new TreeSet(a));
                joinEdges.add(current);
            }
            ++i;
        }
        return joinEdges;
    }

    public ArrayList computeMSTPrim(String root) {
        ArrayList<Edge> edgesTaken = new ArrayList<Edge>();
        this.createDijkstraInitialGraph(root);
        MinQueue mq = new MinQueue(this);
        while (!mq.isEmpty()) {
            Node u = mq.extractMin();
            ArrayList outgoing = this.getOutgoingEdges(u.getLabel());
            int i = 0;
            while (i < outgoing.size()) {
                Edge e = (Edge)outgoing.get(i);
                Node v = this.getNode(e.getToNode());
                int weight = e.getWeight();
                if (mq.indexQueue(v.getLabel()) >= 0 && u.getDistance() + weight < v.getDistance()) {
                    v.setEdgeTaken(e);
                    int index = mq.indexQueue(v.getLabel());
                    mq.decreaseKey(index, u.getDistance() + weight);
                    v.setEdgeTaken(e);
                }
                ++i;
            }
        }
        ArrayList nodes = this.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            Node n = (Node)nodes.get(i);
            if (n.getEdgeTaken() != null) {
                edgesTaken.add(n.getEdgeTaken());
            }
            ++i;
        }
        return edgesTaken;
    }

    public DGraph computeMST(String root) {
        DGraph mst = (DGraph)this.clone();
        mst.removeIncomingEdges(root);
        System.out.println("mst less incoming edges:");
        mst.print();
        DGraph org_mst = (DGraph)mst.clone();
        return this.MSThelper(mst, "", org_mst);
    }

    private DGraph computeMST(DGraph mst) {
        System.out.println("Computing MST: ");
        Iterator iterator = mst.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            System.out.print("Node " + n.getLabel());
            Edge maxEdge = mst.findMaxInEdge(n.getLabel());
            mst.removeIncomingEdges(n.getLabel());
            if (maxEdge != null) {
                System.out.println(" has max in-edge: " + maxEdge.getFromNode() + " " + maxEdge.getWeight());
                Node toNode = (Node)mst.nodeList.get(maxEdge.getToNode());
                toNode.addEdge(maxEdge.getFromNode(), maxEdge.getLabel(), maxEdge.getWeight());
                continue;
            }
            System.out.println(" has no incoming edges.");
        }
        return mst;
    }

    private DGraph MSThelper(DGraph input, String lastPseudoNode, DGraph org_mst) {
        Node n;
        DGraph mst = this.computeMST(input);
        if (!mst.hasCycle()) {
            return mst;
        }
        String st = "";
        int minVal = Integer.MAX_VALUE;
        Edge e = null;
        Edge minEdge = null;
        System.out.print("Cycle nodes: ");
        int i = 0;
        while (i < mst.cycleNodes.size()) {
            n = (Node)mst.cycleNodes.get(i);
            System.out.print(String.valueOf(n.getLabel()) + " ");
            st = String.valueOf(st) + n.getLabel() + "_";
            ArrayList edges = n.getEdges();
            int j = 0;
            while (j < edges.size()) {
                e = (Edge)edges.get(j);
                if (e.getWeight() < minVal) {
                    minEdge = e;
                    minVal = e.getWeight();
                }
                ++j;
            }
            ++i;
        }
        System.out.println();
        System.out.println("Condensed node label is: " + st);
        System.out.println("Minimum edge in cycle is: " + minEdge);
        if (this.numNodes() == 2) {
            System.out.println("Only two nodes and have cycle.  Break it by removing incoming edge that is not last pseudonode: " + lastPseudoNode);
            n = mst.getNode(lastPseudoNode);
            Node n2 = (Node)mst.cycleNodes.get(0);
            n2 = n;
            n2.removeAllInEdges();
            return mst;
        }
        DGraph merge = (DGraph)org_mst.clone();
        merge.addNode(st, 0);
        Node pseudoNode = merge.getNode(st);
        ArrayList edgeList = merge.getEdgeList();
        ArrayList<Edge> saveEdgeList = new ArrayList<Edge>();
        int i2 = 0;
        while (i2 < edgeList.size()) {
            e = (Edge)edgeList.get(i2);
            Node tn = mst.getNode(e.getToNode());
            Node fn = mst.getNode(e.getFromNode());
            if (mst.cycleNodes.contains(tn) && mst.cycleNodes.contains(fn)) {
                saveEdgeList.add(e);
            } else if (mst.cycleNodes.contains(tn)) {
                System.out.println("Changing :" + e);
                ArrayList inList = mst.getIncomingEdges(tn.getLabel());
                Edge inEdge = (Edge)inList.get(0);
                int wIn = inEdge.getWeight();
                int newWeight = e.getWeight() - (wIn - minVal);
                e.setWeight(newWeight);
                e.setToNode(st);
                tn.removeEdge(e.getFromNode());
                pseudoNode.addEdge(e);
                System.out.println("Changed :" + e);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < mst.cycleNodes.size()) {
            n = (Node)mst.cycleNodes.get(i2);
            merge.removeNode(n.getLabel());
            ++i2;
        }
        ArrayList allEdges = merge.getEdgeList();
        int i3 = 0;
        while (i3 < allEdges.size()) {
            Edge tmp = (Edge)allEdges.get(i3);
            Node fn = mst.getNode(tmp.getFromNode());
            if (mst.cycleNodes.contains(fn)) {
                System.out.println("Updating from edge out of cycle: " + tmp);
                tmp.setFromNode(st);
            }
            ++i3;
        }
        System.out.println("\nMerged Graph after merger:");
        merge.print();
        DGraph nextG = (DGraph)merge.clone();
        DGraph mergeMST = merge.MSThelper(nextG, st, org_mst);
        System.out.println("\nMST for merged graph: ");
        mergeMST.print();
        System.out.println("\nOriginal MST with cycle: ");
        mst.print();
        DGraph tmp = (DGraph)mst.clone();
        tmp.removeAllEdges();
        ArrayList eList = mergeMST.getEdgeList();
        int i4 = 0;
        while (i4 < eList.size()) {
            e = (Edge)eList.get(i4);
            e = this.getEdge(e.getLabel());
            tmp.addEdge(e.getFromNode(), e.getToNode(), e.getLabel(), e.getWeight());
            ++i4;
        }
        ArrayList inList = mergeMST.getIncomingEdges(st);
        if (inList.size() == 0) {
            System.out.println("ERROR: Should never get to this point.  Pseudonode: " + st);
            System.exit(1);
        }
        Edge inEdge = (Edge)inList.get(0);
        String orgEdgeLabel = inEdge.getLabel();
        Edge orgEdge = this.getEdge(orgEdgeLabel);
        String inNodeLabel = orgEdge.getToNode();
        System.out.println(inNodeLabel);
        ArrayList inNodeEdgeList = mst.getIncomingEdges(inNodeLabel);
        Edge droppedEdge = (Edge)inNodeEdgeList.get(0);
        int i5 = 0;
        while (i5 < saveEdgeList.size()) {
            e = (Edge)saveEdgeList.get(i5);
            if (e.getLabel() != droppedEdge.getLabel()) {
                tmp.addEdge(e.getFromNode(), e.getToNode(), e.getLabel(), e.getWeight());
            }
            ++i5;
        }
        System.out.println("\nMST without cycle: ");
        tmp.print();
        return tmp;
    }

    public void print() {
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            System.out.println("Node " + n.getLabel() + " weight:" + n.getWeight());
            ArrayList a = n.getEdges();
            int i = 0;
            while (i < a.size()) {
                Edge e = (Edge)a.get(i);
                System.out.print(e);
                ++i;
            }
            System.out.println();
        }
    }

    public void clearAllMarkers() {
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            n.setMarker(0);
        }
    }

    public void clearAllVisited() {
        Iterator iterator = this.nodeList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node n = (Node)entry.getValue();
            n.setVisited(false);
        }
    }

    public void quicksort(ArrayList a, int p, int r) {
        if (p < r) {
            int q = this.partition(a, p, r);
            this.quicksort(a, p, q - 1);
            this.quicksort(a, q + 1, r);
        }
    }

    private int partition(ArrayList a, int p, int r) {
        Edge e = (Edge)a.get(r);
        int i = p - 1;
        int j = p;
        while (j <= r - 1) {
            if (((Edge)a.get(j)).getWeight() <= e.getWeight()) {
                Edge temp = (Edge)a.get(++i);
                a.set(i, (Edge)a.get(j));
                a.set(j, temp);
            }
            ++j;
        }
        Edge temp1 = (Edge)a.get(i + 1);
        a.set(i + 1, (Edge)a.get(r));
        a.set(r, temp1);
        return i + 1;
    }

    public class Node {
        private String label;
        private int weight;
        private ArrayList edges = new ArrayList();
        private int marker;
        private boolean visited;
        private int distance;
        private Edge edgeTaken;
        int[] distances;
        Edge[] predecessor;
        boolean tie = false;
        boolean[] ties;
        Object ob;

        public Node(String l, int w) {
            this.label = l;
            this.weight = w;
        }

        public Node(String l) {
            this.label = l;
            this.weight = 0;
        }

        public Node() {
            this.label = "";
            this.weight = 0;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getLabel() {
            return this.label;
        }

        ArrayList getEdges() {
            return this.edges;
        }

        public int getMarker() {
            return this.marker;
        }

        public boolean getVisited() {
            return this.visited;
        }

        public Object getObject() {
            return this.ob;
        }

        public int getDistance() {
            return this.distance;
        }

        public Edge getEdgeTaken() {
            return this.edgeTaken;
        }

        public boolean getTie() {
            return this.tie;
        }

        public int[] getDistances() {
            return this.distances;
        }

        public int getDistance(int i) {
            return this.distances[i];
        }

        public Edge[] getPredecessor() {
            return this.predecessor;
        }

        public boolean[] getTies() {
            return this.ties;
        }

        public void setWeight(int w) {
            this.weight = w;
        }

        public void setMarker(int m) {
            this.marker = m;
        }

        public void setVisited(boolean v) {
            this.visited = v;
        }

        public void setLabel(String l) {
            this.label = l;
        }

        public void setDistance(int v) {
            this.distance = v;
        }

        public void setEdgeTaken(Edge e) {
            this.edgeTaken = e;
        }

        public void setDistances(int[] d) {
            this.distances = d;
        }

        public void setPredecessor(Edge[] e) {
            this.predecessor = e;
        }

        public void setTie(boolean t) {
            this.tie = t;
        }

        public void setTies(boolean[] t) {
            this.ties = t;
        }

        public void setObject(Object o) {
            this.ob = o;
        }

        private int getEdgeIndex(String searchKey, int type) {
            int i = 0;
            while (i < this.edges.size()) {
                Edge e = (Edge)this.edges.get(i);
                if (type == 1 && searchKey.equals(e.getFromNode()) || type == 2 && searchKey.equals(e.getLabel())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Edge getEdgeByNode(String fromNodeLabel) {
            int idx = this.getEdgeIndex(fromNodeLabel, 1);
            if (idx >= 0) {
                return (Edge)this.edges.get(idx);
            }
            return null;
        }

        public Edge getEdge(String edgeLabel) {
            int idx = this.getEdgeIndex(edgeLabel, 2);
            if (idx >= 0) {
                return (Edge)this.edges.get(idx);
            }
            return null;
        }

        public boolean isEdgeByNode(String fromNodeLabel) {
            return this.getEdgeByNode(fromNodeLabel) != null;
        }

        public boolean isEdge(String edgeLabel) {
            return this.getEdge(edgeLabel) != null;
        }

        public boolean addEdge(String fromNodeLabel, String edgeLabel, int weight) {
            Edge e = new Edge(edgeLabel, weight, fromNodeLabel, this.label);
            return this.addEdge(e);
        }

        public boolean addEdge(Edge e) {
            this.edges.add(e);
            return true;
        }

        public void removeEdgeByNode(String fromNodeLabel) {
            int idx = this.getEdgeIndex(fromNodeLabel, 1);
            if (idx >= 0) {
                this.edges.remove(idx);
            }
        }

        public void removeEdge(String edgeLabel) {
            int idx = this.getEdgeIndex(edgeLabel, 2);
            if (idx >= 0) {
                this.edges.remove(idx);
            }
        }

        public void removeAllInEdges() {
            this.edges.clear();
        }
    }

    public class Edge {
        private String label;
        private int weight;
        private String fromNode;
        private String toNode;
        private Object ob;

        public Edge(String l, int w, String fN, String tN) {
            this.label = l;
            this.weight = w;
            this.fromNode = fN;
            this.toNode = tN;
        }

        public Edge(String l) {
            this.label = l;
            this.weight = 0;
        }

        public Edge() {
            this.label = "";
            this.weight = 0;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getLabel() {
            return this.label;
        }

        public String getFromNode() {
            return this.fromNode;
        }

        public String getToNode() {
            return this.toNode;
        }

        public Object getObject() {
            return this.ob;
        }

        public void setWeight(int w) {
            this.weight = w;
        }

        public void setLabel(String l) {
            this.label = l;
        }

        public void setFromNode(String n) {
            this.fromNode = n;
        }

        public void setToNode(String n) {
            this.toNode = n;
        }

        public void setObject(Object sj) {
            this.ob = sj;
        }

        public String toString() {
            return "(" + this.fromNode + "," + this.toNode + "," + this.weight + "," + this.label + "," + this.ob + ") ";
        }

        public String toShort() {
            return "(" + this.fromNode + "," + this.toNode + "," + this.label + ") ";
        }
    }

    public class MinQueue {
        public ArrayList q = new ArrayList();

        public MinQueue() {
        }

        public MinQueue(DGraph d) {
            this.q = d.getNodes();
            int i = this.size() / 2;
            while (i >= 0) {
                this.minHeapify(i);
                --i;
            }
        }

        public int left(int i) {
            if (i == 0) {
                return 1;
            }
            return 2 * i;
        }

        public int right(int i) {
            if (i == 0) {
                return 2;
            }
            return 2 * i + 1;
        }

        public int parent(int i) {
            return i / 2;
        }

        public void minHeapify(int i) {
            int l = this.left(i);
            int r = this.right(i);
            int min = l < this.q.size() && ((Node)this.q.get(l)).getDistance() < ((Node)this.q.get(i)).getDistance() ? l : i;
            if (r < this.q.size() && ((Node)this.q.get(r)).getDistance() < ((Node)this.q.get(min)).getDistance()) {
                min = r;
            }
            if (min != i) {
                this.swap(i, min);
                this.minHeapify(min);
            }
        }

        private void swap(int i, int j) {
            Object temp = this.q.get(i);
            this.q.set(i, this.q.get(j));
            this.q.set(j, temp);
        }

        public int size() {
            return this.q.size();
        }

        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        public Node extractMin() {
            Node min = (Node)this.q.get(0);
            this.q.set(0, this.q.get(this.size() - 1));
            this.q.remove(this.size() - 1);
            this.minHeapify(0);
            return min;
        }

        public void decreaseKey(int i, int key) {
            ((Node)this.q.get(i)).setDistance(key);
            while (i > 0 && ((Node)this.q.get(this.parent(i))).getDistance() > ((Node)this.q.get(i)).getDistance()) {
                this.swap(i, this.parent(i));
                i = this.parent(i);
            }
        }

        public int indexQueue(String label) {
            int i = 0;
            while (i < this.q.size()) {
                Node n = (Node)this.q.get(i);
                if (n.getLabel().equals(label)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void insert(Node n) {
            this.q.add(n);
            int i = this.size() - 1;
            while (i > 0 && ((Node)this.q.get(this.parent(i))).getDistance() > ((Node)this.q.get(i)).getDistance()) {
                this.swap(i, this.parent(i));
                i = this.parent(i);
            }
        }

        public void printArray() {
            int i = 0;
            while (i < this.size()) {
                Node n = (Node)this.q.get(i);
                System.out.println(String.valueOf(n.getLabel()) + "  " + n.getDistance());
                ++i;
            }
            System.out.println();
        }

        public void printQueue() {
            while (!this.isEmpty()) {
                Node n = this.extractMin();
                System.out.println(String.valueOf(n.getLabel()) + "  " + n.getDistance());
            }
            System.out.println();
        }
    }
}

