/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import unity.io.FileManager;
import unity.operators.Operator;
import unity.query.GlobalQuery;
import unity.query.LocalQuery;
import unity.relational.Tuple;

public class ResultRowData {
    private static final int MIN_CAPACITY = 3000;
    private static final int MIN_MEMORY = 0x100000;
    private static final int FORWARD = 1;
    private static final int BACKWARD = 0;
    private String absolutePath = null;
    private ArrayList rows = new ArrayList(3000);
    private int cursor;
    private int type;
    private int totalTuplesStored;
    private int tuplesStoredInCurrentBatch;
    private int batchNum;
    private int fetchSize;
    private int tuplesStoredUsed;
    private int updateCursor;
    private int copyCursor;
    private int lastIndex;
    private int UPDATEINDEX;
    private int[][] updateTrack;
    private Operator op;
    private GlobalQuery globalQuery;
    private Runtime rt;
    private Tuple forwardOnlyRow;
    private Tuple updateTuple;
    private ArrayList outFile = new ArrayList(100);
    private RandomAccessFile index;
    private boolean moreTuples;
    private boolean flag;
    private boolean ATINSERT;

    public GlobalQuery getGlobalQuery() {
        return this.globalQuery;
    }

    public ResultRowData(GlobalQuery gq, int rsType) throws SQLException {
        this.globalQuery = gq;
        this.op = gq.getExecutionTree();
        this.type = rsType;
        this.copyCursor = -1;
        this.lastIndex = -1;
        this.cursor = -1;
        this.batchNum = 0;
        this.fetchSize = 1000;
        this.tuplesStoredInCurrentBatch = -1;
        this.totalTuplesStored = 0;
        this.tuplesStoredUsed = 0;
        this.moreTuples = true;
        this.flag = true;
        this.rt = Runtime.getRuntime();
        this.forwardOnlyRow = null;
        this.updateCursor = -2;
        this.updateTrack = new int[100][2];
        this.ATINSERT = false;
        try {
            this.op.init();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    private int writeRowsToDisk() {
        Object out = null;
        int rowsWritten = 0;
        long length = 0L;
        try {
            if (this.absolutePath == null) {
                this.absolutePath = FileManager.getTemporaryPath();
                System.out.println("Temp Directory is: " + this.absolutePath);
                this.outFile.add(FileManager.openInputOutputFile(String.valueOf(this.absolutePath) + "\\batch" + this.batchNum + ".dat", "rw"));
                this.index = FileManager.openInputOutputFile(String.valueOf(this.absolutePath) + "\\index.dat", "rw");
            }
            int i = 0;
            while (i < this.cursor) {
                Tuple temp = (Tuple)this.rows.remove(0);
                length = ((RandomAccessFile)this.outFile.get(this.batchNum)).getFilePointer();
                temp.write((RandomAccessFile)this.outFile.get(this.batchNum));
                this.index.writeLong(length);
                ++this.tuplesStoredInCurrentBatch;
                ++this.totalTuplesStored;
                if (this.tuplesStoredInCurrentBatch == 100000 && i < this.cursor) {
                    this.cursor -= i + 1;
                    this.tuplesStoredInCurrentBatch = 0;
                    ++this.batchNum;
                    this.outFile.add(FileManager.openInputOutputFile(String.valueOf(this.absolutePath) + "\\batch" + this.batchNum + ".dat", "rw"));
                    return -1;
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("File not found\n" + e);
            System.exit(1);
        }
        return rowsWritten;
    }

    private void storeToDisk() throws IOException {
        int temp;
        while ((temp = this.writeRowsToDisk()) == -1) {
        }
        this.cursor = !this.rows.isEmpty() ? 0 : -1;
    }

    public int getRow() {
        return this.copyCursor + 1;
    }

    public boolean absolute(int row) throws SQLException {
        this.updateCursor = -2;
        if (this.type == 1003) {
            throw new SQLException("Incorrect TYPE for absolute");
        }
        int oldCursor = this.copyCursor;
        if (row - 1 > this.lastIndex && !this.moreTuples || row == 0) {
            this.cursor = this.rows.size();
            this.copyCursor = this.lastIndex + 1;
            System.out.println("false1");
            return false;
        }
        if (row - 1 > this.lastIndex) {
            try {
                while (this.next() && row - 1 + 1000 > this.lastIndex) {
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (row - 1 + 1000 > this.lastIndex && row != this.lastIndex) {
                this.absolute(oldCursor + 1);
                System.out.println("false2");
                return false;
            }
            if (row == this.lastIndex) {
                this.copyCursor = this.lastIndex - 1;
                this.cursor = this.rows.size() - 1;
                return true;
            }
        }
        if (row >= this.copyCursor - this.cursor && row <= this.copyCursor - this.cursor + this.rows.size()) {
            this.cursor = row - (this.copyCursor - this.cursor);
            this.copyCursor = row - 1;
            return true;
        }
        if (row > 0 && (row < this.copyCursor || row <= this.lastIndex)) {
            if (this.totalTuplesStored < this.copyCursor + this.cursor - this.rows.size() - 1) {
                while (this.writeAlltoDisk() == -1) {
                }
            }
            this.copyCursor = row - 1;
            this.rows.clear();
            int x = this.readFromDisk(0);
            int y = this.readFromDisk(1);
            this.cursor = x - 1;
            return true;
        }
        if (row < 0) {
            try {
                while (this.next()) {
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!this.absolute(this.lastIndex + row + 1)) {
                this.absolute(oldCursor);
                System.out.println("false3");
                return false;
            }
            return true;
        }
        System.out.println("false4");
        return false;
    }

    public boolean next() throws SQLException {
        if (this.type == 1003) {
            try {
                this.forwardOnlyRow = this.op.next();
            }
            catch (IOException e) {
                throw new SQLException("Error fetching results from Server: " + e);
            }
            return this.forwardOnlyRow != null;
        }
        this.updateCursor = -2;
        if (this.cursor < this.rows.size() - 1) {
            ++this.cursor;
            ++this.copyCursor;
            return true;
        }
        if (this.getNext()) {
            ++this.cursor;
            ++this.copyCursor;
            return true;
        }
        return false;
    }

    private boolean increaseCapacity() {
        this.rows.trimToSize();
        if (this.rt.freeMemory() < 0x100000L) {
            return false;
        }
        this.rows.ensureCapacity(this.rows.size() + 3000);
        return true;
    }

    private boolean getNext() {
        boolean retVal = false;
        if (this.totalTuplesStored > 0 && (this.copyCursor <= this.tuplesStoredUsed + this.cursor || this.copyCursor < this.totalTuplesStored)) {
            int x;
            if (!this.increaseCapacity()) {
                int k = this.cursor;
                int counter = 0;
                while (counter < k && this.rows.size() > 0) {
                    this.rows.remove(0);
                    --this.cursor;
                    ++counter;
                }
            }
            if ((x = this.readFromDisk(1)) > 0) {
                retVal = true;
            } else {
                try {
                    retVal = this.fetchFromServer();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                retVal = this.fetchFromServer();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    private boolean fetchFromServer() throws SQLException {
        int i = 0;
        this.increaseCapacity();
        boolean retVal = false;
        Tuple tempTuple = null;
        try {
            if (this.rt.freeMemory() < 0x100000L) {
                if (this.moreTuples) {
                    this.storeToDisk();
                }
                this.rt.gc();
            }
            while (i < this.fetchSize) {
                if (this.moreTuples) {
                    tempTuple = this.op.next();
                    ++this.lastIndex;
                }
                if (tempTuple == null) {
                    this.moreTuples = false;
                    break;
                }
                this.rows.add(tempTuple);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("IO Operator error");
        }
        retVal = i != 0;
        return retVal;
    }

    public void afterLast() {
        try {
            while (this.next()) {
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.updateCursor = -2;
        this.cursor = this.rows.size();
        this.copyCursor = this.lastIndex;
    }

    public void beforeFirst() throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("Incorrect TYPE for beforeFirst");
        }
        this.absolute(1);
        this.cursor = -1;
        this.copyCursor = -1;
        this.updateCursor = -2;
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    public boolean first() throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("Incorrect TYPE for first()");
        }
        this.updateCursor = -2;
        return this.absolute(1);
    }

    public boolean appendTuple(Tuple row) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public Object getObject(int columnIndex) {
        if (this.type == 1003) {
            return this.forwardOnlyRow.getObject(columnIndex - 1);
        }
        if (this.rows.get(this.cursor) == null) {
            return null;
        }
        return ((Tuple)this.rows.get(this.cursor)).getObject(columnIndex - 1);
    }

    public boolean isAfterLast() {
        return this.copyCursor > this.lastIndex;
    }

    public boolean isBeforeFirst() {
        return this.copyCursor < 0 && this.lastIndex > 0;
    }

    public boolean isFirst() {
        return this.copyCursor == 0 && (!this.rows.isEmpty() || this.totalTuplesStored > 0);
    }

    public boolean isLast() {
        return this.copyCursor == this.lastIndex;
    }

    public boolean last() throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("Incorrect TYPE for last");
        }
        while (this.next()) {
        }
        this.updateCursor = -2;
        return true;
    }

    public void close() throws IOException {
        if (this.absolutePath != null) {
            int i = 0;
            while (i < this.outFile.size()) {
                ((RandomAccessFile)this.outFile.get(i)).close();
                ++i;
            }
            this.index.close();
            if (FileManager.deleteDirectory(new File(this.absolutePath))) {
                // empty if block
            }
        }
        this.op.close();
    }

    public boolean previous() throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("Incorrect TYPE for method");
        }
        this.updateCursor = -2;
        if (this.cursor > 0) {
            --this.cursor;
            --this.copyCursor;
            return true;
        }
        if (this.cursor <= 0 && this.copyCursor > 0) {
            int temp = -1;
            while (temp == -1) {
                temp = this.writeAlltoDisk();
            }
            temp = this.cursor;
            --this.copyCursor;
            this.rows.clear();
            int x = this.readFromDisk(0);
            if (x > 0) {
                return true;
            }
            this.beforeFirst();
            return false;
        }
        return false;
    }

    private int readFromDisk(int direction) {
        int batch = this.copyCursor / 100001;
        int tempCursor = this.copyCursor;
        Object inFile = null;
        int i = 0;
        if (direction == 0) {
            this.cursor = -1;
        }
        if (direction == 1) {
            ++tempCursor;
        }
        while (i < this.fetchSize && tempCursor >= 0 && tempCursor < this.totalTuplesStored) {
            Tuple tempTuple = (Tuple)this.getTupleFromDisk((RandomAccessFile)this.outFile.get(batch), tempCursor);
            if (tempTuple != null) {
                if (direction == 0) {
                    this.rows.add(0, tempTuple);
                    --tempCursor;
                    ++this.cursor;
                } else {
                    this.rows.add(tempTuple);
                    ++tempCursor;
                    ++this.tuplesStoredUsed;
                }
            } else {
                System.out.println("breaking");
                System.out.print("Diag: " + this.copyCursor + " " + tempCursor + " " + this.totalTuplesStored);
                break;
            }
            batch = tempCursor / 100001;
            ++i;
        }
        return i;
    }

    private Object getTupleFromDisk(RandomAccessFile inFile, int tempCursor) {
        long line = 0L;
        Tuple temp = new Tuple(this.op.getOutputRelation());
        try {
            this.index.seek(tempCursor * 8);
            line = this.index.readLong();
            inFile.seek(line);
            if (temp.read(inFile)) {
                return temp;
            }
            return null;
        }
        catch (IOException e) {
            System.out.println("Problem reading Tuple from File: " + e);
            System.out.println(String.valueOf(tempCursor) + "  " + line + "  batch: " + this.batchNum);
            return null;
        }
    }

    private int writeAlltoDisk() {
        long length = 0L;
        if (this.flag) {
            this.flag = false;
            try {
                int i = 0;
                while (i < this.rows.size()) {
                    Tuple temp = (Tuple)this.rows.get(i);
                    length = ((RandomAccessFile)this.outFile.get(this.batchNum)).getFilePointer();
                    temp.write((RandomAccessFile)this.outFile.get(this.batchNum));
                    this.index.writeLong(length);
                    ++this.tuplesStoredInCurrentBatch;
                    ++this.totalTuplesStored;
                    if (this.tuplesStoredInCurrentBatch == 100000 && !this.rows.isEmpty()) {
                        this.tuplesStoredInCurrentBatch = 0;
                        ++this.batchNum;
                        this.outFile.add(FileManager.openInputOutputFile(String.valueOf(this.absolutePath) + "\\batch" + this.batchNum + ".dat", "rw"));
                        this.flag = true;
                        int k = 0;
                        while (k < i) {
                            this.rows.remove(this.rows.size() - 1);
                            ++k;
                        }
                        return -1;
                    }
                    ++i;
                }
                if (i == this.rows.size()) {
                    this.rows.clear();
                    this.rt.gc();
                }
            }
            catch (Exception e) {
                System.out.println("IO Error\n" + e);
                e.printStackTrace();
                System.exit(1);
            }
        } else if (this.rt.freeMemory() < 0x100000L) {
            this.rows.trimToSize();
            int l = this.rows.size();
            if (this.cursor == 0) {
                this.rows.clear();
                this.rt.gc();
            }
        }
        return 0;
    }

    public boolean relative(int index) throws SQLException {
        if (this.type == 1003) {
            throw new SQLException("incorrect TYPE for method");
        }
        return this.absolute(this.copyCursor + index);
    }

    public void setFetchSize(int _fetchsize) {
        this.fetchSize = _fetchsize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    private void updateColumn(int index, Object x) throws SQLException {
        Tuple temp = (Tuple)this.rows.get(this.cursor);
        if (this.updateTuple == null) {
            this.updateTuple = new Tuple(temp.getValuesCopy(), temp.getRelation());
        }
        this.updateTuple.setValue(index - 1, x);
        this.updateCursor = this.copyCursor;
        if (this.copyCursor < this.totalTuplesStored) {
            try {
                this.writeIndexedTuple(this.copyCursor, this.updateTuple);
            }
            catch (IOException e) {
                throw new SQLException("Error synching update with local tuple");
            }
        }
    }

    private void writeIndexedTuple(int copyCursor2, Tuple updateTuple2) throws IOException {
        long line = 0L;
        try {
            long curr = this.index.getFilePointer();
            this.index.seek(copyCursor2 * 8);
            line = this.index.readLong();
            this.index.seek(curr);
            int batch = copyCursor2 / 100001;
            RandomAccessFile oFile = (RandomAccessFile)this.outFile.get(batch);
            oFile.seek(line);
            updateTuple2.write(oFile);
        }
        catch (IOException e) {
            throw new IOException("error updating cached tuple");
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.UPDATEINDEX = 1;
        this.updateColumn(columnIndex, x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.UPDATEINDEX = 2;
        this.updateColumn(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.UPDATEINDEX = 3;
        this.updateColumn(columnIndex, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.UPDATEINDEX = 4;
        this.updateColumn(columnIndex, x);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.UPDATEINDEX = 5;
        this.updateColumn(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.UPDATEINDEX = 6;
        this.updateColumn(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.UPDATEINDEX = 7;
        this.updateColumn(columnIndex, x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.UPDATEINDEX = 8;
        this.updateColumn(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.UPDATEINDEX = 9;
        this.updateColumn(columnIndex, x);
    }

    public void updatedouble(int columnIndex, double x) throws SQLException {
        this.UPDATEINDEX = 10;
        this.updateColumn(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.UPDATEINDEX = 11;
        this.updateColumn(columnIndex, Float.valueOf(x));
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.UPDATEINDEX = 12;
        this.updateColumn(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.UPDATEINDEX = 13;
        this.updateColumn(columnIndex, x);
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.UPDATEINDEX = 14;
        this.updateColumn(columnIndex, null);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.UPDATEINDEX = 15;
        this.updateColumn(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.UPDATEINDEX = 16;
        this.updateColumn(columnIndex, x);
    }

    public void updateRow() throws SQLException {
        ResultSet x;
        System.out.println("HERE");
        if (this.updateCursor == this.copyCursor) {
            int numQueries = this.globalQuery.getLocalQueries().size();
            if (numQueries > 1) {
                throw new SQLException("Cannot support updates to multiple tables/databases in one query");
            }
            LocalQuery query = (LocalQuery)this.globalQuery.getLocalQueries().get(0);
            x = query.getResultSet();
            x.absolute(this.copyCursor + 1);
            int i = 0;
            while (i < this.updateTuple.numValues()) {
                x.updateObject(i + 1, this.updateTuple.getObject(i));
                ++i;
            }
        } else {
            throw new SQLException("Cannot update database. updateRow should be called immediately after updateXXX");
        }
        x.updateRow();
        this.rows.set(this.cursor, this.updateTuple);
        this.updateTuple = null;
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.UPDATEINDEX = 17;
        this.updateColumn(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.UPDATEINDEX = 18;
        this.updateColumn(columnIndex, x);
    }

    public void updateTimeStamp(int columnIndex, Timestamp x) throws SQLException {
        this.UPDATEINDEX = 19;
        this.updateColumn(columnIndex, x);
    }

    public void moveToInsertRow() {
        this.ATINSERT = true;
        this.updateTuple = new Tuple(((Tuple)this.rows.get(this.cursor)).getRelation());
    }

    public void insertRow() throws SQLException {
        if (!this.ATINSERT) {
            throw new SQLException("Must call moveToInsertRow() before this method");
        }
        this.ATINSERT = false;
        int numQueries = this.globalQuery.getLocalQueries().size();
        if (numQueries > 1) {
            throw new SQLException("Cannot support updates to multiple tables/databases in one query");
        }
        LocalQuery query = (LocalQuery)this.globalQuery.getLocalQueries().get(0);
        ResultSet x = query.getResultSet();
        x.absolute(this.copyCursor + 1);
        x.moveToInsertRow();
        int i = 0;
        while (i < this.updateTuple.numValues()) {
            x.updateObject(i + 1, this.updateTuple.getObject(i));
            ++i;
        }
        x.insertRow();
        x.moveToCurrentRow();
        this.rows.add(this.updateTuple);
    }
}

