/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import unity.functions.Expression;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.Projection;
import unity.operators.SortSetOp;
import unity.predicates.SortComparator;
import unity.query.LQNode;
import unity.relational.Relation;

public class LQUnionNode
extends LQNode {
    public LQUnionNode() {
        this.type = 10;
    }

    public String generateSQL() {
        return "";
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        int numInputTuples;
        Relation leftRelation = children[0].getOutputRelation();
        Relation rightRelation = children[1].getOutputRelation();
        Expression[] leftExpr = new Expression[leftRelation.getNumAttributes()];
        Expression[] rightExpr = new Expression[rightRelation.getNumAttributes()];
        boolean[] typeConvert = new boolean[2];
        this.outputRelation = Relation.unionCompatible(leftRelation, rightRelation, leftExpr, rightExpr, typeConvert);
        if (typeConvert[0]) {
            children[0] = new Projection(children[0], leftExpr, leftRelation);
        }
        if (typeConvert[1]) {
            children[1] = new Projection(children[1], rightExpr, rightRelation);
        }
        boolean[] ascDesc = new boolean[this.outputRelation.getNumAttributes()];
        int[] locs = new int[ascDesc.length];
        int i = 0;
        while (i < ascDesc.length) {
            ascDesc[i] = true;
            locs[i] = i;
            ++i;
        }
        SortComparator sorter = new SortComparator(locs, ascDesc);
        int bfr = 2;
        int bsize = numInputTuples = this.getChild(0).numTuples();
        MergeSort mergeSortOpLeft = new MergeSort(children[0], bsize, bfr, sorter);
        bsize = this.getChild(1).numTuples();
        MergeSort mergeSortOpRight = new MergeSort(children[1], bsize, bfr, sorter);
        SortSetOp unionOp = new SortSetOp(new Operator[]{mergeSortOpLeft, mergeSortOpRight}, sorter, this.outputRelation, 10);
        return unionOp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("UNION    ");
        return buf.toString();
    }
}

