/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceKey;
import unity.globalschema.GlobalSchema;
import unity.parser.ASTAs;
import unity.parser.ASTFunction;
import unity.parser.ASTGroupby;
import unity.parser.ASTHaving;
import unity.parser.ASTInteger;
import unity.parser.ASTMyID;
import unity.parser.ASTOrderby;
import unity.parser.ASTReal;
import unity.parser.ASTSQLPattern;
import unity.parser.ASTSelect;
import unity.parser.ASTString;
import unity.parser.ASTUnary;
import unity.parser.ASTWhere;
import unity.parser.SimpleNode;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCondNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQJoinNode;
import unity.query.LQMergeNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProductNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQTree;
import unity.query.LQTreeConstants;
import unity.query.SubQuery;

public class LQTreeBuilder
implements LQTreeConstants {
    private ArrayList joinList;
    private SubQuery subQuery;
    private boolean oneDatabaseQuery;

    public LQTree BuildLQTree(SubQuery sq, SimpleNode ptRoot, GlobalSchema gs, HashMap tableLookup, HashMap attrLookup) throws SQLException {
        LQSelNode selNode;
        LQNode lqtroot;
        this.subQuery = sq;
        this.oneDatabaseQuery = sq.numDatabases() == 1;
        SimpleNode gbNode = null;
        SimpleNode obNode = null;
        SimpleNode slNode = null;
        SimpleNode pjNode = null;
        int i = 0;
        while (i < ptRoot.jjtGetNumChildren()) {
            SimpleNode child = (SimpleNode)ptRoot.jjtGetChild(i);
            if (child instanceof ASTSelect) {
                pjNode = child;
            } else if (child instanceof ASTWhere) {
                slNode = child;
            } else if (child instanceof ASTOrderby) {
                obNode = child;
            } else if (child instanceof ASTGroupby) {
                gbNode = child;
            }
            ++i;
        }
        this.buildTableNodes();
        LQGroupByNode lqGroupBy = null;
        lqGroupBy = gbNode != null ? this.buildGroupByNode(gbNode) : new LQGroupByNode();
        LQNode bottomNode = null;
        LQProjNode lqProjNode = lqtroot = this.buildProjectionNode(pjNode, lqGroupBy);
        if (!lqGroupBy.isEmpty()) {
            LQNode lqTopNode = lqGroupBy.getParent() == null ? lqGroupBy : lqGroupBy.getParent();
            lqTopNode.setParent(lqtroot);
            lqtroot.addChild(lqTopNode);
        }
        if (((ASTSelect)pjNode).getDistinct()) {
            LQDupElimNode dupElimNode = new LQDupElimNode();
            dupElimNode.addChild(lqtroot);
            lqtroot.setParent(dupElimNode);
            lqtroot = dupElimNode;
        }
        LQTree lqTree = new LQTree(lqtroot);
        if (lqtroot.getNumChildren() > 0) {
            bottomNode = lqtroot;
            while (bottomNode.getNumChildren() > 0) {
                bottomNode = bottomNode.getChild(0);
            }
        } else {
            bottomNode = lqtroot;
        }
        this.joinList = new ArrayList();
        if (slNode != null && (selNode = this.buildConditionNodes((SimpleNode)slNode.jjtGetChild(0), bottomNode)) != null) {
            bottomNode = selNode;
        }
        this.connectTableNodes(bottomNode);
        lqTree.setJoinList(this.joinList);
        if (obNode != null) {
            LQOrderByNode lqOrderBy = this.buildOrderByNode(obNode, lqProjNode);
            if (!lqOrderBy.getProjectLast()) {
                LQNode curRoot = lqTree.getRoot();
                curRoot.setParent(lqOrderBy);
                lqOrderBy.addChild(curRoot);
                lqTree.setRoot(lqOrderBy);
            } else {
                LQNode curRoot = lqTree.getRoot();
                LQNode childNode = curRoot.getChild(0);
                childNode.setParent(lqOrderBy);
                lqOrderBy.addChild(childNode);
                curRoot.setChild(0, lqOrderBy);
                lqOrderBy.setParent(curRoot);
            }
        }
        this.finalValidate(this.subQuery);
        return lqTree;
    }

    private void finalValidate(SubQuery subQuery) {
        if (!this.oneDatabaseQuery) {
            HashMap trefs = subQuery.getTableRefs();
            Iterator it = trefs.entrySet().iterator();
            while (it.hasNext()) {
                AnnotatedSourceKey ask;
                LQProjNode tblProjNode;
                GQTableRef tref = (GQTableRef)it.next().getValue();
                LQNode n = tref.getNode();
                if (!(n instanceof LQProjNode) || (tblProjNode = (LQProjNode)tref.getNode()).getExpressions().size() != 0 || (ask = (AnnotatedSourceKey)tref.getTable().getPrimaryKey()) == null) continue;
                ArrayList keyFields = ask.getFields();
                int i = 0;
                while (i < keyFields.size()) {
                    AnnotatedSourceField asf = (AnnotatedSourceField)keyFields.get(i);
                    LQExprNode keyField = new LQExprNode();
                    String fieldName = asf.getName();
                    GQFieldRef gqf = new GQFieldRef(asf, fieldName, fieldName, tref);
                    keyField.setType(100);
                    keyField.setContent(gqf);
                    ((LQProjNode)n).addExpression(keyField);
                    ++i;
                }
            }
        }
    }

    private LQOrderByNode buildOrderByNode(SimpleNode obNode, LQProjNode lqProjNode) throws SQLException {
        LQOrderByNode orderByNode = new LQOrderByNode();
        int i = 0;
        while (i < obNode.jjtGetNumChildren()) {
            SimpleNode sn = (SimpleNode)obNode.jjtGetChild(i);
            LQExprNode en = this.BuildExpressionNode(4, sn, 0, null);
            if (!orderByNode.getProjectLast() && !lqProjNode.hasExpression(en.toString())) {
                ArrayList fieldRefs = LQNode.getAllExprNodes(en);
                int j = 0;
                while (i < fieldRefs.size()) {
                    GQFieldRef fref;
                    LQExprNode e = (LQExprNode)fieldRefs.get(j);
                    if (e.getContent() instanceof GQFieldRef && !lqProjNode.hasExpression((fref = (GQFieldRef)e.getContent()).getName())) {
                        orderByNode.setProjectLast(true);
                    }
                    ++i;
                }
            }
            if (++i >= obNode.jjtGetNumChildren()) {
                orderByNode.addExpression(en, "ASC");
                break;
            }
            SimpleNode sn1 = (SimpleNode)obNode.jjtGetChild(i);
            String ptype1 = sn1.toString();
            if (ptype1.toLowerCase().equals("dsctoken")) {
                orderByNode.addExpression(en, "DESC");
            } else if (ptype1.toLowerCase().equals("asctoken")) {
                orderByNode.addExpression(en, "ASC");
            } else {
                orderByNode.addExpression(en, "ASC");
                --i;
            }
            ++i;
        }
        return orderByNode;
    }

    private LQGroupByNode buildGroupByNode(SimpleNode gbNode) throws SQLException {
        LQGroupByNode groupByNode = new LQGroupByNode();
        int i = 0;
        while (i < gbNode.jjtGetNumChildren()) {
            SimpleNode sn = (SimpleNode)gbNode.jjtGetChild(i);
            if (!(sn instanceof ASTHaving)) {
                LQExprNode en = this.BuildExpressionNode(5, sn, 0, null);
                groupByNode.addGroupByExpression(en);
            } else {
                LQSelNode selNode = this.buildHavingNode((SimpleNode)sn.jjtGetChild(0), groupByNode);
                groupByNode.setParent(selNode);
                selNode.setParent(null);
                selNode.addChild(groupByNode);
            }
            ++i;
        }
        return groupByNode;
    }

    private LQProjNode buildProjectionNode(SimpleNode pjNode, LQGroupByNode groupByNode) throws SQLException {
        LQProjNode projNode = new LQProjNode();
        if (pjNode.jjtGetChild(0).toString().indexOf("*") >= 0) {
            HashMap hFields = this.subQuery.getFieldRefs();
            Iterator itField = hFields.keySet().iterator();
            while (itField.hasNext()) {
                LQExprNode lqAddNode = new LQExprNode();
                String strFieldName = (String)itField.next();
                GQFieldRef gqf = (GQFieldRef)hFields.get(strFieldName);
                lqAddNode.setType(100);
                lqAddNode.setContent(gqf);
                projNode.addExpression(lqAddNode);
                if (this.oneDatabaseQuery) continue;
                GQTableRef tref = gqf.getTable();
                LQProjNode tblProjNode = (LQProjNode)tref.getNode();
                tblProjNode.addNoDupExpression(lqAddNode);
            }
        } else {
            LQExprNode en = null;
            SimpleNode snCurrent = (SimpleNode)pjNode.jjtGetChild(0);
            int i = 1;
            while (i < pjNode.jjtGetNumChildren()) {
                SimpleNode snAhead = (SimpleNode)pjNode.jjtGetChild(i);
                if (snAhead instanceof ASTAs) {
                    pjNode.jjtRemoveChild(i - 1);
                    snCurrent.jjtSetParent(snAhead);
                    snAhead.InsertChild(0, snCurrent);
                    en = this.BuildExpressionNode(1, snAhead, 0, groupByNode);
                    snCurrent = i < pjNode.jjtGetNumChildren() ? (SimpleNode)pjNode.jjtGetChild(i) : null;
                } else {
                    en = this.BuildExpressionNode(1, snCurrent, 0, groupByNode);
                    snCurrent = snAhead;
                }
                projNode.addExpression(en);
                ++i;
            }
            if (snCurrent != null) {
                en = this.BuildExpressionNode(1, snCurrent, 0, groupByNode);
                projNode.addExpression(en);
            }
        }
        if (!groupByNode.isEmpty()) {
            this.validateProjectionNode(projNode, groupByNode);
        }
        return projNode;
    }

    private void validateProjectionNode(LQProjNode projNode, LQGroupByNode groupByNode) throws SQLException {
        ArrayList expr = projNode.getExpressions();
        int i = 0;
        while (i < expr.size()) {
            LQExprNode en = (LQExprNode)expr.get(i);
            groupByNode.validateField(en);
            ++i;
        }
    }

    public LQExprNode BuildExpressionNode(int type, SimpleNode sn, int iStartChild, LQNode groupByNode) throws SQLException {
        LQExprNode lqReturnNode = new LQExprNode();
        String exprText = sn.toString();
        if (sn instanceof ASTMyID) {
            lqReturnNode.setType(100);
            if (type == 200 || type == 208) {
                String fullQualifiedName = exprText.substring(12).toLowerCase();
                lqReturnNode.setContent(fullQualifiedName);
            } else {
                String fullQualifiedName = exprText.substring(12).toLowerCase();
                if (!fullQualifiedName.equals("*")) {
                    GQFieldRef fref = this.subQuery.getFieldRef(fullQualifiedName);
                    if (fref == null) {
                        throw new SQLException("Invalid field reference: " + fullQualifiedName);
                    }
                    lqReturnNode.setContent(fref);
                    if (!this.oneDatabaseQuery) {
                        GQTableRef tref = fref.getTable();
                        LQProjNode tblProjNode = (LQProjNode)tref.getNode();
                        tblProjNode.addNoDupExpression(lqReturnNode);
                    }
                } else {
                    lqReturnNode.setContent("*");
                    lqReturnNode.setType(101);
                    if (sn.jjtGetParent().toString().indexOf("count") < 0) {
                        throw new SQLException("* can only be used with aggregate function count not: " + sn.jjtGetParent().toString());
                    }
                }
            }
        } else if (sn instanceof ASTAs) {
            if (type != 1 && type != 200) {
                throw new SQLException("Renaming using AS only allowed in SELECT/MATCH clause.");
            }
            SimpleNode rightChild = (SimpleNode)sn.jjtGetChild(1);
            if (!(rightChild instanceof ASTMyID)) {
                throw new SQLException("Renaming using AS requires identifier on right-hand side.");
            }
            lqReturnNode.setType(103);
            LQExprNode lc = this.BuildExpressionNode(type, (SimpleNode)sn.jjtGetChild(0), 0, groupByNode);
            lqReturnNode.addChild(lc);
            LQExprNode rc = new LQExprNode();
            rc.setType(100);
            String newName = sn.jjtGetChild(1).toString().substring(12);
            rc.setContent(newName);
            lqReturnNode.addChild(rc);
        } else if (!(sn instanceof ASTHaving)) {
            if (sn instanceof ASTFunction) {
                String strFunctionName = sn.toString();
                strFunctionName = strFunctionName.substring(strFunctionName.indexOf(":") + 1).trim();
                lqReturnNode.setContent(strFunctionName);
                int numParam = sn.jjtGetNumChildren();
                int i = 0;
                while (i < numParam) {
                    LQExprNode lqParmeter = this.BuildExpressionNode(type, (SimpleNode)sn.jjtGetChild(i), 0, groupByNode);
                    lqReturnNode.addChild(lqParmeter);
                    ++i;
                }
                if (LQGroupByNode.isAggregateFunction(strFunctionName) && type != 200 && type != 208) {
                    lqReturnNode.setType(125);
                    if (type != 5) {
                        LQExprNode saved = ((LQGroupByNode)groupByNode).findAggregateFunction(lqReturnNode);
                        if (saved == null) {
                            ((LQGroupByNode)groupByNode).addAggregateFunction(lqReturnNode);
                            saved = lqReturnNode;
                        }
                        lqReturnNode = new LQExprNode();
                        lqReturnNode.setType(120);
                        lqReturnNode.setContent(saved);
                        lqReturnNode.setReference(null);
                    }
                } else if (type == 200 || type == 208) {
                    lqReturnNode.setType(128);
                    if (type == 208) {
                        if (strFunctionName.equalsIgnoreCase("GetValue")) {
                            lqReturnNode.setType(102);
                        } else {
                            LQExprNode saved = ((LQMergeNode)groupByNode).findMatchFunction(lqReturnNode);
                            if (saved == null) {
                                throw new SQLException("Invalid field reference in FILTER clause: " + exprText);
                            }
                            lqReturnNode = new LQExprNode();
                            lqReturnNode.setType(120);
                            lqReturnNode.setContent(saved);
                            lqReturnNode.setReference(null);
                        }
                    }
                } else {
                    lqReturnNode.setType(102);
                }
            } else if (sn instanceof ASTInteger || sn instanceof ASTReal || sn instanceof ASTString) {
                String constantVal = exprText.substring(exprText.indexOf(":") + 1).trim();
                if (sn instanceof ASTInteger) {
                    lqReturnNode.setType(104);
                    lqReturnNode.setContent(new Integer(constantVal));
                } else if (sn instanceof ASTReal) {
                    lqReturnNode.setType(105);
                    lqReturnNode.setContent(new Double(constantVal));
                } else {
                    lqReturnNode.setType(101);
                    lqReturnNode.setContent(constantVal);
                }
            } else if (sn instanceof ASTSQLPattern) {
                String patternVal = exprText.substring(exprText.indexOf(":") + 1).trim();
                lqReturnNode.setType(117);
                lqReturnNode.setContent(patternVal);
            } else if (sn instanceof ASTUnary) {
                if (exprText.charAt(7) == '-') {
                    LQExprNode leftExpr = this.BuildExpressionNode(type, (SimpleNode)sn.jjtGetChild(0), 0, groupByNode);
                    LQExprNode rightExpr = new LQExprNode();
                    rightExpr.setType(104);
                    rightExpr.setContent(new Integer(-1));
                    lqReturnNode.setType(126);
                    lqReturnNode.setContent("*");
                    lqReturnNode.addChild(leftExpr);
                    lqReturnNode.addChild(rightExpr);
                }
            } else {
                LQExprNode leftExpr = this.BuildExpressionNode(type, (SimpleNode)sn.jjtGetChild(0), 0, groupByNode);
                LQExprNode opNode = null;
                int i = 1;
                while (i < sn.jjtGetNumChildren()) {
                    LQExprNode rightExpr = this.BuildExpressionNode(type, (SimpleNode)sn.jjtGetChild(i + 1), 0, groupByNode);
                    opNode = new LQExprNode();
                    opNode.setType(126);
                    String strFunctionNotation = sn.jjtGetChild(i).toString();
                    strFunctionNotation = strFunctionNotation.substring(strFunctionNotation.indexOf(":") + 1).trim();
                    opNode.setContent(strFunctionNotation);
                    opNode.addChild(leftExpr);
                    opNode.addChild(rightExpr);
                    leftExpr = opNode;
                    i += 2;
                }
                lqReturnNode = opNode;
            }
        }
        return lqReturnNode;
    }

    private void buildTableNodes() {
        HashMap tableRefs = this.subQuery.getTableRefs();
        Iterator it = tableRefs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            GQTableRef tref = (GQTableRef)entry.getValue();
            LQExprNode tblNode = new LQExprNode();
            tblNode.setType(6);
            tblNode.setContent(tref);
            tblNode.setReference(tref.getParentDB());
            tref.setNode(tblNode);
            if (this.oneDatabaseQuery) continue;
            LQProjNode projNode = new LQProjNode();
            projNode.addChild(tblNode);
            tblNode.setParent(projNode);
            tref.setNode(projNode);
        }
    }

    private void connectTableNodes(LQNode parentNode) {
        LQNode joinTreeRootNode;
        Iterator roots;
        HashMap tableRefs = this.subQuery.getTableRefs();
        Iterator tables = tableRefs.keySet().iterator();
        if (tableRefs.size() == 1) {
            LQNode tableNode = ((GQTableRef)tableRefs.get((String)tables.next())).getNode();
            tableNode.setParent(parentNode);
            parentNode.addChild(tableNode);
            return;
        }
        LQProductNode productNode = new LQProductNode();
        HashMap<Object, LQNode> joinTreeRoots = new HashMap<Object, LQNode>();
        while (tables.hasNext()) {
            String tableRefName = (String)tables.next();
            LQNode tableNode = ((GQTableRef)tableRefs.get(tableRefName)).getNode();
            if (tableNode.getParent() == null) {
                productNode.addChild(tableNode);
                tableNode.setParent(productNode);
                continue;
            }
            LQNode tmp = tableNode;
            while (tmp.getParent() != null) {
                tmp = tmp.getParent();
            }
            if (joinTreeRoots.containsKey(tmp.getContent())) continue;
            joinTreeRoots.put(tmp.getContent(), tmp);
        }
        if (joinTreeRoots.size() == 1 && productNode.getNumChildren() == 0) {
            roots = joinTreeRoots.keySet().iterator();
            joinTreeRootNode = (LQNode)joinTreeRoots.get(roots.next());
            joinTreeRootNode.setParent(parentNode);
            parentNode.addChild(joinTreeRootNode);
        } else {
            roots = joinTreeRoots.keySet().iterator();
            while (roots.hasNext()) {
                joinTreeRootNode = (LQNode)joinTreeRoots.get(roots.next());
                joinTreeRootNode.setParent(productNode);
                productNode.addChild(joinTreeRootNode);
            }
            if (productNode.getNumChildren() > 2) {
                int numChildren = productNode.getNumChildren();
                LQProductNode newPNode = new LQProductNode();
                LQNode tmp = productNode.getChild(numChildren - 1);
                tmp.setParent(newPNode);
                newPNode.addChild(tmp);
                tmp = productNode.getChild(numChildren - 2);
                tmp.setParent(newPNode);
                newPNode.addChild(tmp);
                productNode.removeChild(numChildren - 1);
                productNode.removeChild(numChildren - 2);
                LQProductNode lastPNode = newPNode;
                while (productNode.getNumChildren() > 2) {
                    numChildren = productNode.getNumChildren();
                    newPNode = new LQProductNode();
                    tmp = productNode.getChild(numChildren - 1);
                    tmp.setParent(newPNode);
                    newPNode.addChild(tmp);
                    newPNode.addChild(lastPNode);
                    lastPNode.setParent(newPNode);
                    lastPNode = newPNode;
                }
                productNode.addChild(lastPNode);
                lastPNode.setParent(productNode);
            }
            productNode.setParent(parentNode);
            parentNode.addChild(productNode);
        }
    }

    private LQSelNode buildConditionNodes(SimpleNode cn, LQNode parentNode) throws SQLException {
        LQSelNode selNode = null;
        String cnType = cn.toString().toLowerCase();
        if (cnType.equals("and")) {
            LQNode prevNode = parentNode;
            int numChildren = cn.jjtGetNumChildren();
            int k = 0;
            while (k < numChildren) {
                SimpleNode condNode = (SimpleNode)cn.jjtGetChild(k);
                if (this.isJoinCondition(condNode)) {
                    this.createJoinNode(condNode);
                } else {
                    selNode = new LQSelNode();
                    selNode.setCondition(this.buildConditionNode(condNode, 207, null));
                    selNode.setParent(prevNode);
                    prevNode.addChild(selNode);
                    prevNode = selNode;
                }
                ++k;
            }
        } else if (this.isJoinCondition(cn)) {
            this.createJoinNode(cn);
        } else {
            selNode = new LQSelNode();
            selNode.setCondition(this.buildConditionNode(cn, 207, null));
            selNode.setParent(parentNode);
            parentNode.addChild(selNode);
        }
        return selNode;
    }

    private LQSelNode buildHavingNode(SimpleNode cn, LQGroupByNode groupByNode) throws SQLException {
        LQSelNode selNode = new LQSelNode();
        selNode.setHavingCondition(true);
        selNode.setCondition(this.buildConditionNode(cn, 9, groupByNode));
        return selNode;
    }

    private void createJoinNode(SimpleNode condNode) throws SQLException {
        LQJoinNode joinNode;
        String leftExpr = condNode.jjtGetChild(0).toString().substring(12).toLowerCase();
        String rightExpr = condNode.jjtGetChild(1).toString().substring(12).toLowerCase();
        String operator = condNode.toString().substring(15);
        String joinConditionText = String.valueOf(leftExpr) + " " + operator + " " + rightExpr;
        LQCondNode joinCondition = this.buildConditionNode(condNode, 207, null);
        GQFieldRef leftfref = this.subQuery.getFieldRef(leftExpr);
        GQFieldRef rightfref = this.subQuery.getFieldRef(rightExpr);
        LQNode table1Node = this.subQuery.getTableRef(leftfref.getTable().getReferenceName()).getNode();
        LQNode table2Node = this.subQuery.getTableRef(rightfref.getTable().getReferenceName()).getNode();
        LQNode tbl1Node = table1Node;
        LQNode tbl2Node = table2Node;
        if (table1Node.getParent() == null || table2Node.getParent() == null) {
            LQJoinNode jn = new LQJoinNode();
            jn.setContent(joinConditionText);
            jn.setCondition(joinCondition);
            jn.addChild(table1Node);
            jn.addChild(table2Node);
            this.joinList.add(jn);
            while (table1Node.getParent() != null) {
                table1Node = table1Node.getParent();
            }
            while (table2Node.getParent() != null) {
                table2Node = table2Node.getParent();
            }
            joinNode = new LQJoinNode();
            joinNode.setContent(joinConditionText);
            joinNode.setCondition(joinCondition);
            joinNode.addChild(table1Node);
            joinNode.addChild(table2Node);
            table1Node.setParent(joinNode);
            table2Node.setParent(joinNode);
        } else {
            ArrayList<LQNode> ancestors1 = new ArrayList<LQNode>();
            while (table1Node.getParent() != null) {
                ancestors1.add(0, table1Node.getParent());
                table1Node = table1Node.getParent();
            }
            ArrayList<LQNode> ancestors2 = new ArrayList<LQNode>();
            while (table2Node.getParent() != null) {
                ancestors2.add(0, table2Node.getParent());
                table2Node = table2Node.getParent();
            }
            int i = 0;
            while (i < ancestors1.size() && i < ancestors2.size()) {
                if (ancestors1.get(i) != ancestors2.get(i)) break;
                ++i;
            }
            joinNode = (LQJoinNode)ancestors1.get(--i);
            String joinConditionTextOld = (String)joinNode.getContent();
            LQCondNode joinConditionOld = joinNode.getCondition();
            joinNode.setContent(String.valueOf(joinConditionTextOld) + " AND " + joinConditionText);
            LQCondNode newCondition = new LQCondNode();
            newCondition.setType(111);
            newCondition.setContent("AND");
            newCondition.addChild(joinCondition);
            newCondition.addChild(joinConditionOld);
            joinNode.setCondition(newCondition);
            i = 0;
            while (i < this.joinList.size()) {
                LQJoinNode jn = (LQJoinNode)this.joinList.get(i);
                if (jn.getCondition() == joinConditionOld) {
                    jn.setCondition(newCondition);
                    jn.setContent(String.valueOf(joinConditionTextOld) + " AND " + joinConditionText);
                    break;
                }
                ++i;
            }
        }
        if (table1Node.getReference() == table2Node.getReference()) {
            joinNode.setReference(table1Node.getReference());
        } else {
            joinNode.setReference(null);
        }
    }

    public LQCondNode buildConditionNode(SimpleNode cn, int optype, LQNode groupByNode) throws SQLException {
        LQCondNode condNode = new LQCondNode();
        String content = "";
        String cnType = cn.toString().toLowerCase();
        int type = -1;
        if (cnType.equals("or")) {
            type = 110;
            content = "OR";
        } else if (cnType.equals("and")) {
            type = 111;
            content = "AND";
        } else if (cnType.equals("not")) {
            type = 112;
            content = "NOT";
        } else if (cnType.equals("xor")) {
            type = 118;
            content = "XOR";
        }
        if (type == 112) {
            SimpleNode pp = (SimpleNode)cn.jjtGetChild(0);
            LQCondNode lcn = this.buildConditionNode(pp, optype, groupByNode);
            condNode.addChild(lcn);
            lcn.setParent(condNode);
        } else if (type == 110 || type == 111 || type == 118) {
            int number = cn.jjtGetNumChildren();
            condNode = this.buildConditionNode((SimpleNode)cn.jjtGetChild(0), optype, groupByNode);
            int k = 1;
            while (k < number) {
                LQCondNode c = this.buildConditionNode((SimpleNode)cn.jjtGetChild(k), optype, groupByNode);
                LQCondNode temp = new LQCondNode();
                temp.addChild(condNode);
                temp.addChild(c);
                temp.setType(type);
                temp.setContent(content);
                condNode = temp;
                ++k;
            }
        } else if (cnType.equals("in")) {
            type = 113;
            content = "IN";
        } else {
            String operator;
            type = 114;
            SimpleNode leftChild = (SimpleNode)cn.jjtGetChild(0);
            SimpleNode rightChild = (SimpleNode)cn.jjtGetChild(1);
            content = operator = cn.toString().substring(15);
            LQExprNode lcn = this.BuildExpressionNode(optype, leftChild, 0, groupByNode);
            LQExprNode rcn = this.BuildExpressionNode(optype, rightChild, 0, groupByNode);
            condNode.addChild(lcn);
            lcn.setParent(condNode);
            condNode.addChild(rcn);
            rcn.setParent(condNode);
        }
        condNode.setType(type);
        condNode.setContent(content);
        return condNode;
    }

    public boolean isJoinCondition(SimpleNode cn) throws SQLException {
        String operator;
        String cnType = cn.toString().toLowerCase();
        if (cnType.startsWith("comparison_op:") && (operator = cnType.substring(15)).equals("=")) {
            String lc = ((SimpleNode)cn.jjtGetChild(0)).toString().toLowerCase();
            String rc = ((SimpleNode)cn.jjtGetChild(1)).toString().toLowerCase();
            if (lc.substring(0, 5).equals("ident") && rc.substring(0, 5).equals("ident")) {
                String leftFieldName = lc.substring(12);
                String rightFieldName = rc.substring(12);
                GQFieldRef leftfref = this.subQuery.getFieldRef(leftFieldName);
                GQFieldRef rightfref = this.subQuery.getFieldRef(rightFieldName);
                if (leftfref == null) {
                    throw new SQLException("Invalid field reference: " + leftFieldName);
                }
                if (rightfref == null) {
                    throw new SQLException("Invalid field reference: " + rightFieldName);
                }
                return leftfref.getTable() != rightfref.getTable();
            }
        }
        return false;
    }
}

