/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Stack;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.SortGrouper;
import unity.predicates.ExprSortComparator;
import unity.query.GQFieldRef;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQGroupByNode
extends LQNode {
    private ArrayList groupList = new ArrayList();
    private ArrayList functionList = new ArrayList();

    public LQGroupByNode() {
        this.type = 5;
    }

    public void addGroupByExpression(LQExprNode exprNode) {
        this.groupList.add(exprNode);
    }

    public LQExprNode findAggregateFunction(LQExprNode func) {
        String funcStr = func.toString();
        int i = 0;
        while (i < this.functionList.size()) {
            LQExprNode en = (LQExprNode)this.functionList.get(i);
            if (en.toString().equals(funcStr)) {
                return en;
            }
            ++i;
        }
        return null;
    }

    public void addAggregateFunction(LQExprNode func) {
        this.functionList.add(func);
    }

    public boolean isEmpty() {
        return this.groupList.size() == 0 && this.functionList.size() == 0;
    }

    public boolean isEmptyGrouping() {
        return this.groupList.size() == 0;
    }

    public void validateField(LQExprNode exprNode) throws SQLException {
        int i = 0;
        while (i < this.groupList.size()) {
            LQExprNode en = (LQExprNode)this.groupList.get(i);
            if (en.toString().equals(exprNode.toString())) {
                return;
            }
            ++i;
        }
        Stack<LQNode> nodeStack = new Stack<LQNode>();
        nodeStack.push(exprNode);
        ArrayList<Object> fieldRefs = new ArrayList<Object>();
        while (!nodeStack.empty()) {
            LQExprNode en = (LQExprNode)nodeStack.pop();
            if (en.getType() == 100) {
                fieldRefs.add(en.getContent());
                continue;
            }
            if (en.getType() == 103) {
                nodeStack.push(en.getChild(0));
                continue;
            }
            if (en.getType() == 125) continue;
            int j = 0;
            while (j < en.getNumChildren()) {
                nodeStack.push(en.getChild(j));
                ++j;
            }
        }
        int i2 = 0;
        if (i2 < fieldRefs.size()) {
            GQFieldRef fref = (GQFieldRef)fieldRefs.get(i2);
            int j = 0;
            while (j < this.groupList.size()) {
                LQExprNode en = (LQExprNode)this.groupList.get(i2);
                if (en.getContent() == fref) {
                    return;
                }
                ++j;
            }
            throw new SQLException("Field: " + fref.getName() + " is not in GROUP BY or aggregate function in a GROUPING query.");
        }
    }

    public static boolean isAggregateFunction(String fn) {
        return (fn = fn.toUpperCase()).equals("COUNT") || fn.equals("AVG") || fn.equals("SUM") || fn.equals("MAX") || fn.equals("MIN");
    }

    public String generateSQL() {
        if (this.groupList == null || this.groupList.size() == 0) {
            return "";
        }
        if (this.groupList.size() > 0) {
            String result = ((LQExprNode)this.groupList.get(0)).generateSQL();
            int i = 1;
            while (i < this.groupList.size()) {
                LQExprNode child = (LQExprNode)this.groupList.get(i);
                result = String.valueOf(result) + ", " + child.generateSQL();
                ++i;
            }
            return result;
        }
        return null;
    }

    public String toString() {
        String groupByListStr = this.generateSQL();
        if (groupByListStr.equals("")) {
            groupByListStr = "(no grouping attributes)";
        }
        String functionListStr = "";
        int i = 0;
        while (i < this.functionList.size()) {
            LQExprNode en = (LQExprNode)this.functionList.get(i);
            functionListStr = String.valueOf(functionListStr) + en.generateSQL() + " ";
            ++i;
        }
        return "GROUPBY: " + groupByListStr + " Computed functions: " + functionListStr;
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        SortGrouper grouper;
        Attribute[] attr = new Attribute[this.groupList.size() + this.functionList.size()];
        Relation inputRelation = ((LQNode)this.children.get(0)).getOutputRelation();
        Expression[] exprList = new Expression[this.groupList.size()];
        int i = 0;
        while (i < this.groupList.size()) {
            attr[i] = new Attribute();
            exprList[i] = ((LQExprNode)this.groupList.get(i)).buildExpression(inputRelation, attr[i]);
            ++i;
        }
        Aggregate_Function[] aggFuncList = new Aggregate_Function[this.functionList.size()];
        int i2 = 0;
        while (i2 < this.functionList.size()) {
            attr[i2 + this.groupList.size()] = new Attribute();
            aggFuncList[i2] = (Aggregate_Function)((LQExprNode)this.functionList.get(i2)).buildExpression(inputRelation, attr[i2 + this.groupList.size()]);
            ++i2;
        }
        this.outputRelation = new Relation(attr);
        if (this.groupList.size() > 0) {
            int numInputTuples;
            boolean[] ascDesc = new boolean[this.groupList.size()];
            int i3 = 0;
            while (i3 < this.groupList.size()) {
                ascDesc[i3] = true;
                ++i3;
            }
            ExprSortComparator sorter = new ExprSortComparator(exprList, ascDesc);
            int bfr = 2;
            int bsize = numInputTuples = this.getChild(0).numTuples();
            MergeSort mergeSortOp = new MergeSort(children[0], bsize, bfr, sorter);
            grouper = new SortGrouper(mergeSortOp, sorter, exprList, aggFuncList, this.outputRelation);
        } else {
            grouper = new SortGrouper(children[0], null, exprList, aggFuncList, this.outputRelation);
        }
        this.setOperator(grouper);
        return grouper;
    }

    public ArrayList getProjectedFields(ArrayList projectFields) {
        int i = 0;
        while (i < this.groupList.size()) {
            LQExprNode child = (LQExprNode)this.groupList.get(i);
            if (child.getType() == 100) {
                projectFields.add(child.getContent());
            }
            ++i;
        }
        return projectFields;
    }

    public ArrayList getProjectedFunctionExpr(ArrayList projectFunctionFields) {
        int i = 0;
        while (i < this.functionList.size()) {
            LQExprNode child = (LQExprNode)this.functionList.get(i);
            projectFunctionFields.addAll(child.getRequiredFields());
            ++i;
        }
        return projectFunctionFields;
    }

    public ArrayList getExpressions() {
        return this.groupList;
    }

    public ArrayList getRequiredFields() {
        ArrayList a = new ArrayList();
        this.getProjectedFields(a).addAll(this.getProjectedFunctionExpr(a));
        return a;
    }

    public int numTuples() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).numTuples();
        }
        return 0;
    }

    public int tupleSize() {
        ArrayList a = this.getRequiredFields();
        int totalSize = 0;
        int i = 0;
        while (i < a.size()) {
            GQFieldRef fref = (GQFieldRef)a.get(i);
            int size = fref.getField().getColumnSize();
            totalSize += size;
            ++i;
        }
        return totalSize;
    }
}

