/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import unity.annotation.AnnotatedSourceField;
import unity.functions.A_Avg;
import unity.functions.A_Count;
import unity.functions.A_Max;
import unity.functions.A_Min;
import unity.functions.A_Sum;
import unity.functions.ConstantValue;
import unity.functions.Divide;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.functions.F_Abs;
import unity.functions.F_Ascii;
import unity.functions.F_Cast;
import unity.functions.F_Ceiling;
import unity.functions.F_Date;
import unity.functions.F_Exp;
import unity.functions.F_Floor;
import unity.functions.F_GetValue;
import unity.functions.F_Length;
import unity.functions.F_Ln;
import unity.functions.F_Log;
import unity.functions.F_Lower;
import unity.functions.F_Position;
import unity.functions.F_Power;
import unity.functions.F_Random;
import unity.functions.F_Replace;
import unity.functions.F_Round;
import unity.functions.F_Sqrt;
import unity.functions.F_Substring;
import unity.functions.F_Trim;
import unity.functions.F_Upper;
import unity.functions.Function;
import unity.functions.M_Avg;
import unity.functions.M_Choose;
import unity.functions.M_ChooseNN;
import unity.functions.M_Group;
import unity.functions.M_GroupRef;
import unity.functions.M_Max;
import unity.functions.M_MaxRef;
import unity.functions.M_Min;
import unity.functions.M_MinRef;
import unity.functions.M_Sum;
import unity.functions.MatchFunction;
import unity.functions.Minus;
import unity.functions.Modulus;
import unity.functions.Multiply;
import unity.functions.Plus;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQNode;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQExprNode
extends LQNode
implements Cloneable {
    private static int uniqueExprNum = 0;
    protected static HashMap functionList = null;

    public LQExprNode() {
    }

    public LQExprNode(LQExprNode n) {
        super(n);
    }

    public static void loadFunctions() throws SQLException {
        Function.initializeFunctions();
    }

    public String generateSQL() {
        if (this.type == 6) {
            return ((GQTableRef)this.getContent()).getLocalName();
        }
        if (this.type == 127 || this.type == 101 || this.type == 104 || this.type == 105 || this.type == 117) {
            return this.getContent().toString();
        }
        if (this.type == 100) {
            if (this.getContent() instanceof GQFieldRef) {
                return ((GQFieldRef)this.getContent()).getLocalName();
            }
            return this.getContent().toString();
        }
        if (this.type == 103) {
            return String.valueOf(this.getChild(0).generateSQL()) + " AS " + this.getChild(1).generateSQL();
        }
        if (this.type == 120) {
            return ((LQExprNode)this.getContent()).generateSQL();
        }
        if (this.type == 125 || this.type == 102 || this.type == 128) {
            StringBuffer buf = new StringBuffer(100);
            buf.append(this.getContent() + "(");
            if (this.getNumChildren() > 0) {
                buf.append(((LQExprNode)this.getChild(0)).generateSQL());
            }
            int j = 1;
            while (j < this.getNumChildren()) {
                buf.append("," + ((LQExprNode)this.getChild(j)).generateSQL());
                ++j;
            }
            buf.append(")");
            return buf.toString();
        }
        if (this.type == 126) {
            String strReturnString = "(" + ((LQExprNode)this.getChild(0)).generateSQL() + this.getContent() + ((LQExprNode)this.getChild(1)).generateSQL() + ")";
            return strReturnString;
        }
        return "ERROR: LQExprNode GenerateSQL()";
    }

    public String toString() {
        String sourceStr = "null";
        if (this.reference != null) {
            sourceStr = ((GQDatabaseRef)this.reference).getName();
        }
        if (this.type == 6) {
            String sizeStr = "" + ((GQTableRef)this.content).getTable().getNumTuples();
            return String.valueOf(this.generateSQL()) + "  (source: " + sourceStr + ") (size: " + sizeStr + ")";
        }
        return String.valueOf(this.generateSQL()) + "  (source: " + sourceStr + ")";
    }

    public Operator buildOperator(Operator[] children) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression buildExpression(Relation inputRelation, Attribute outputAttribute) throws SQLException {
        Expression expr = null;
        int type = this.getType();
        if (type == 100) {
            int fieldIndex = inputRelation.getAttributeIndex(this.getContent());
            if (fieldIndex != -1) {
                ExtractAttribute extrAttr = new ExtractAttribute(fieldIndex);
                expr = extrAttr;
                Attribute inAttribute = inputRelation.getAttribute(fieldIndex);
                expr.setReturnType(inAttribute.getType());
                outputAttribute.setType(inAttribute.getType());
                outputAttribute.setName(inAttribute.getName());
                outputAttribute.setLength(inAttribute.getLength());
                outputAttribute.setReference(inAttribute.getReference());
            }
        } else if (type == 103) {
            expr = ((LQExprNode)this.getChild(0)).buildExpression(inputRelation, outputAttribute);
            outputAttribute.setName((String)this.getChild(1).getContent());
        } else if (type == 120) {
            int fieldIndex = inputRelation.getAttributeIndex(this.getContent());
            if (fieldIndex != -1) {
                ExtractAttribute extrAttr = new ExtractAttribute(fieldIndex);
                expr = extrAttr;
                Attribute inAttribute = inputRelation.getAttribute(fieldIndex);
                expr.setReturnType(inAttribute.getType());
                outputAttribute.setType(inAttribute.getType());
                outputAttribute.setName(inAttribute.getName());
                outputAttribute.setLength(inAttribute.getLength());
                outputAttribute.setReference(inAttribute.getReference());
            }
        } else if (type == 127 || type == 104 || type == 105 || type == 101) {
            ConstantValue consExpr = new ConstantValue(this.getContent());
            expr = consExpr;
            outputAttribute.setType(consExpr.getReturnType());
            expr.setReturnType(outputAttribute.getType());
            outputAttribute.setName("Constant" + uniqueExprNum++);
            outputAttribute.setLength(this.getContent().toString().length());
            outputAttribute.setReference(null);
        } else if (type == 126) {
            Expression leftExpr = ((LQExprNode)this.getChild(0)).buildExpression(inputRelation, outputAttribute);
            Expression rightExpr = ((LQExprNode)this.getChild(1)).buildExpression(inputRelation, outputAttribute);
            String exprStr = (String)this.getContent();
            if (exprStr.equals("+") || exprStr.equals("||")) {
                Plus AddExpr = new Plus(leftExpr, rightExpr);
                expr = AddExpr;
            } else if (exprStr.equals("-")) {
                Minus MinusExpr = new Minus(leftExpr, rightExpr);
                expr = MinusExpr;
            } else if (exprStr.equals("*")) {
                Multiply MultiplyExpr = new Multiply(leftExpr, rightExpr);
                expr = MultiplyExpr;
            } else if (exprStr.equals("/")) {
                Divide DivideExpr = new Divide(leftExpr, rightExpr);
                expr = DivideExpr;
            } else {
                if (!exprStr.equals("%")) throw new SQLException("Undefined operator: " + exprStr);
                Modulus modExpr = new Modulus(leftExpr, rightExpr);
                expr = modExpr;
            }
            outputAttribute.setType(expr.getReturnType());
            outputAttribute.setName("Expr" + uniqueExprNum++);
            outputAttribute.setLength(10);
            outputAttribute.setReference(null);
        } else if (type == 102) {
            String funcName = (String)this.getContent();
            int numParam = this.getNumChildren();
            Attribute a = new Attribute();
            Expression[] children = new Expression[numParam];
            int i = 0;
            while (i < numParam) {
                children[i] = ((LQExprNode)this.getChild(i)).buildExpression(inputRelation, a);
                ++i;
            }
            if (funcName.equalsIgnoreCase("TRIM") && numParam >= 1 && numParam <= 3) {
                children = Function.validateTypes(funcName, F_Trim.getParamListTypes(), children, numParam);
                if (numParam == 1) {
                    expr = new F_Trim(children[0], F_Trim.BOTH, null);
                } else {
                    String childContent = children[1].evaluate(null).toString();
                    expr = numParam == 2 ? (childContent.equals(F_Trim.BOTH) || childContent.equals(F_Trim.LEADING) || childContent.equals(F_Trim.TRAILING) ? new F_Trim(children[0], childContent, null) : new F_Trim(children[0], F_Trim.BOTH, children[1])) : new F_Trim(children[0], childContent, children[2]);
                }
            } else if (funcName.equalsIgnoreCase("LTRIM") && numParam == 1) {
                expr = new F_Trim(children[0], F_Trim.LEADING, null);
            } else if (funcName.equalsIgnoreCase("RTRIM") && numParam == 1) {
                expr = new F_Trim(children[0], F_Trim.TRAILING, null);
            } else if (funcName.equalsIgnoreCase("CAST") && numParam == 2) {
                expr = new F_Cast(children[0], children[0].getReturnType(), children[1].toString());
            } else if (funcName.equalsIgnoreCase("ABS") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Abs.getParamListTypes(), children);
                expr = new F_Abs(children[0]);
            } else if ((funcName.equalsIgnoreCase("CEIL") || funcName.equalsIgnoreCase("CEILING")) && numParam == 1) {
                children = Function.validateTypes(funcName, F_Ceiling.getParamListTypes(), children);
                expr = new F_Ceiling(children[0]);
            } else if (funcName.equalsIgnoreCase("FLOOR") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Floor.getParamListTypes(), children);
                expr = new F_Floor(children[0]);
            } else if (funcName.equalsIgnoreCase("EXP") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Exp.getParamListTypes(), children);
                expr = new F_Exp(children[0]);
            } else if (funcName.equalsIgnoreCase("POW") && numParam == 2) {
                children = Function.validateTypes(funcName, F_Power.getParamListTypes(), children);
                expr = new F_Power(children[0], children[1]);
            } else if (funcName.equalsIgnoreCase("LN") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Ln.getParamListTypes(), children);
                expr = new F_Ln(children[0]);
            } else if (funcName.equalsIgnoreCase("GetValue") && numParam == 1) {
                expr = new F_GetValue(children[0]);
            } else if (funcName.equalsIgnoreCase("LOG") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Log.getParamListTypes(), children);
                expr = new F_Log(children[0]);
            } else if (funcName.equalsIgnoreCase("ROUND") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Round.getParamListTypes(), children);
                expr = new F_Round(children[0]);
            } else if (funcName.equalsIgnoreCase("SQRT") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Sqrt.getParamListTypes(), children);
                expr = new F_Sqrt(children[0]);
            } else if (funcName.equalsIgnoreCase("DATE") && numParam == 0) {
                expr = new F_Date();
            } else if (funcName.equalsIgnoreCase("RANDOM") && numParam == 0) {
                expr = new F_Random();
            } else if ((funcName.equalsIgnoreCase("LENGTH") || funcName.equalsIgnoreCase("CHARACTER_LENGTH") || funcName.equalsIgnoreCase("CHAR_LENGTH")) && numParam == 1) {
                children = Function.validateTypes(funcName, F_Length.getParamListTypes(), children);
                expr = new F_Length(children[0]);
            } else if (funcName.equalsIgnoreCase("SUBSTRING") && (numParam == 2 || numParam == 3)) {
                children = Function.validateTypes(funcName, F_Substring.getParamListTypes(), children, numParam);
                expr = numParam == 2 ? new F_Substring(children[0], children[1], null) : new F_Substring(children[0], children[1], children[2]);
            } else if (funcName.equalsIgnoreCase("REPLACE") && numParam == 3) {
                children = Function.validateTypes(funcName, F_Replace.getParamListTypes(), children);
                expr = new F_Replace(children[0], children[1], children[2]);
            } else if (funcName.equalsIgnoreCase("LOWER") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Lower.getParamListTypes(), children);
                expr = new F_Lower(children[0]);
            } else if (funcName.equalsIgnoreCase("UPPER") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Upper.getParamListTypes(), children);
                expr = new F_Upper(children[0]);
            } else if (funcName.equalsIgnoreCase("POSITION") && numParam == 2) {
                children = Function.validateTypes(funcName, F_Position.getParamListTypes(), children);
                expr = new F_Position(children[0], children[1]);
            } else if (funcName.equalsIgnoreCase("ASCII") && numParam == 1) {
                children = Function.validateTypes(funcName, F_Ascii.getParamListTypes(), children);
                expr = new F_Ascii(children[0]);
            }
            outputAttribute.setType(expr.getReturnType());
            outputAttribute.setName("Expr" + uniqueExprNum++);
            outputAttribute.setLength(10);
            outputAttribute.setReference(null);
        } else if (type == 125) {
            Attribute a = new Attribute();
            Expression childExpr = ((LQExprNode)this.getChild(0)).buildExpression(inputRelation, a);
            String funcName = (String)this.getContent();
            if (funcName.equalsIgnoreCase("COUNT")) {
                expr = new A_Count(childExpr);
            } else if (funcName.equalsIgnoreCase("MAX")) {
                expr = new A_Max(childExpr);
            } else if (funcName.equalsIgnoreCase("MIN")) {
                expr = new A_Min(childExpr);
            } else if (funcName.equalsIgnoreCase("SUM")) {
                if (!Attribute.isNumberType(a.getType())) throw new SQLException("Cannot compute SUM aggregate function for non-numeric data type");
                expr = new A_Sum(childExpr);
            } else if (funcName.equalsIgnoreCase("AVG")) {
                if (!Attribute.isNumberType(a.getType())) throw new SQLException("Cannot compute AVG aggregate function for non-numeric data type");
                expr = new A_Avg(childExpr);
            }
            outputAttribute.setType(expr.getReturnType());
            outputAttribute.setName("Expr" + uniqueExprNum++);
            outputAttribute.setLength(4);
            outputAttribute.setReference(this);
        } else if (type == 128) {
            Attribute a1 = new Attribute();
            Attribute a2 = new Attribute();
            LQExprNode tmp = (LQExprNode)this.getChild(0);
            Expression childExpr1 = tmp.buildExpression(inputRelation, a1);
            tmp = (LQExprNode)this.getChild(1);
            Expression childExpr2 = tmp.buildExpression(inputRelation, a2);
            String funcName = (String)this.getContent();
            if (funcName.equalsIgnoreCase("CHOOSE") || funcName.equalsIgnoreCase("CHOOSENN")) {
                Expression childExpr3 = ((LQExprNode)this.getChild(2)).buildExpression(inputRelation, a1);
                Object obj = childExpr3.evaluate(null);
                if (!(obj instanceof Integer)) {
                    throw new SQLException("Invalid attribute index for choose function: " + obj);
                }
                int source = (Integer)obj;
                expr = funcName.equalsIgnoreCase("CHOOSE") ? new M_Choose(childExpr1, childExpr2, source) : new M_ChooseNN(childExpr1, childExpr2, source);
            } else if (funcName.equalsIgnoreCase("MIN")) {
                expr = new M_Min(childExpr1, childExpr2);
            } else if (funcName.equalsIgnoreCase("MAX")) {
                expr = new M_Max(childExpr1, childExpr2);
            } else if (funcName.equalsIgnoreCase("SUM")) {
                if (!Attribute.isNumberType(a1.getType()) || !Attribute.isNumberType(a2.getType())) throw new SQLException("Cannot compute SUM aggregate function for non-numeric data type");
                expr = new M_Sum(childExpr1, childExpr2);
            } else if (funcName.equalsIgnoreCase("AVG")) {
                if (!Attribute.isNumberType(a1.getType()) || !Attribute.isNumberType(a2.getType())) throw new SQLException("Cannot compute AVG aggregate function for non-numeric data type");
                expr = new M_Avg(childExpr1, childExpr2);
            } else if (funcName.equalsIgnoreCase("GROUP")) {
                expr = new M_Group(childExpr1, childExpr2);
            } else if (funcName.equalsIgnoreCase("GROUPREF") || funcName.equalsIgnoreCase("MAXREF") || funcName.equalsIgnoreCase("MINREF")) {
                ArrayList dbrefs1 = ((LQExprNode)this.getChild(0)).getSource();
                ArrayList dbrefs2 = ((LQExprNode)this.getChild(1)).getSource();
                GQDatabaseRef dbref1 = null;
                GQDatabaseRef dbref2 = null;
                if (dbrefs1.size() == 1) {
                    dbref1 = (GQDatabaseRef)dbrefs1.get(0);
                }
                if (dbrefs2.size() == 1) {
                    dbref2 = (GQDatabaseRef)dbrefs2.get(0);
                }
                if (funcName.equalsIgnoreCase("GROUPREF")) {
                    expr = new M_GroupRef(childExpr1, childExpr2, dbref1, dbref2);
                } else if (funcName.equalsIgnoreCase("MAXREF")) {
                    expr = new M_MaxRef(childExpr1, childExpr2, dbref1, dbref2);
                } else if (funcName.equalsIgnoreCase("MINREF")) {
                    expr = new M_MinRef(childExpr1, childExpr2, dbref1, dbref2);
                }
            }
            outputAttribute.setType(expr.getReturnType());
            outputAttribute.setName("MatchFunc" + MatchFunction.functionCount++);
            outputAttribute.setLength(10);
            outputAttribute.setReference(null);
        } else if (type == 117) {
            StringBuffer pattern = new StringBuffer((String)this.getContent());
            pattern.deleteCharAt(pattern.length() - 1);
            pattern.deleteCharAt(0);
            int i = 0;
            while (i < pattern.length()) {
                if (pattern.charAt(i) == '%' && pattern.charAt(i - 1) != '\\') {
                    pattern.setCharAt(i, '*');
                    pattern.insert(i, '.');
                    ++i;
                } else if (pattern.charAt(i) == '_' && pattern.charAt(i - 1) != '\\') {
                    pattern.setCharAt(i, '.');
                }
                ++i;
            }
            ConstantValue consExpr = new ConstantValue(pattern);
            expr = consExpr;
            expr.setReturnType(outputAttribute.getType());
        }
        if (expr != null) return expr;
        throw new SQLException("Undefined function or expression: " + this.toString());
    }

    private ArrayList getSource() {
        GQDatabaseRef dbref;
        ArrayList<GQDatabaseRef> a = new ArrayList<GQDatabaseRef>();
        if (this.getType() == 100 && this.getContent() instanceof GQFieldRef && !a.contains(dbref = ((GQFieldRef)this.getContent()).getTable().getParentDB())) {
            a.add(((GQFieldRef)this.getContent()).getTable().getParentDB());
        }
        int i = 0;
        while (i < this.getNumChildren()) {
            LQExprNode child = (LQExprNode)this.getChild(i);
            ArrayList b = child.getSource();
            int j = 0;
            while (j < b.size()) {
                if (!a.contains(b.get(j))) {
                    a.add((GQDatabaseRef)b.get(j));
                }
                ++j;
            }
            ++i;
        }
        return a;
    }

    public Attribute buildAttribute() {
        int type = this.getType();
        Attribute outputAttribute = new Attribute();
        if (type == 100) {
            GQFieldRef gqref = (GQFieldRef)this.getContent();
            AnnotatedSourceField asf = gqref.getField();
            outputAttribute.setType(asf.getDataType());
            outputAttribute.setLength(asf.getColumnSize());
            outputAttribute.setName(asf.getColumnName());
            outputAttribute.setReference(gqref);
        } else if (type == 103) {
            LQExprNode leftExprNode = (LQExprNode)this.getChild(0);
            outputAttribute = leftExprNode.buildAttribute();
            outputAttribute.setName(this.getChild((int)1).content.toString());
        } else if (type == 127 || type == 104 || type == 105 || type == 101) {
            if (type == 104) {
                outputAttribute.setType(Attribute.TYPE_INT);
            } else if (type == 105) {
                outputAttribute.setType(Attribute.TYPE_DOUBLE);
            } else {
                outputAttribute.setType(Attribute.TYPE_STRING);
            }
            outputAttribute.setName("Constant" + uniqueExprNum++);
            outputAttribute.setLength(this.getContent().toString().length());
            outputAttribute.setReference(null);
        } else if (type == 126 || type == 125) {
            outputAttribute.setType(Attribute.TYPE_DOUBLE);
            outputAttribute.setName("Expr" + uniqueExprNum++);
            outputAttribute.setLength(this.getContent().toString().length());
            outputAttribute.setReference(null);
        } else {
            outputAttribute.setType(Attribute.TYPE_DOUBLE);
            outputAttribute.setName("Expr" + uniqueExprNum++);
            outputAttribute.setLength(this.getContent().toString().length());
            outputAttribute.setReference(null);
        }
        return outputAttribute;
    }

    public ArrayList getRequiredFields() {
        ArrayList<Object> a = new ArrayList<Object>();
        if (this.getType() == 100) {
            a.add(this.content);
        } else if (this.getType() == 126 || this.getType() == 125) {
            int i = 0;
            while (i < this.getNumChildren()) {
                LQExprNode child = (LQExprNode)this.getChild(i);
                a.addAll(child.getRequiredFields());
                ++i;
            }
        }
        return a;
    }

    public int numTuples() {
        if (this.type == 6) {
            GQTableRef tref = (GQTableRef)this.getContent();
            int tuples = tref.getTable().getNumTuples();
            if (tuples > 0) {
                return tuples;
            }
            return 1000;
        }
        return -5;
    }

    public int tupleSize() {
        int tupleSize = 0;
        if (this.type == 6) {
            GQTableRef tref = (GQTableRef)this.getContent();
            ArrayList frefs = tref.getFieldRefs();
            int i = 0;
            while (i < frefs.size()) {
                AnnotatedSourceField asf = ((GQFieldRef)frefs.get(i)).getField();
                tupleSize += asf.getColumnSize();
                ++i;
            }
            return tupleSize;
        }
        return -6;
    }

    public Object clone() {
        try {
            LQExprNode ln = (LQExprNode)super.clone();
            if (this.children != null) {
                ln.children = new ArrayList(this.children.size());
                int i = 0;
                while (i < this.children.size()) {
                    ln.children.add(((LQNode)this.children.get(i)).clone());
                    ++i;
                }
            } else {
                ln.children = null;
            }
            return ln;
        }
        catch (Exception e) {
            System.out.println(" exception while cloning " + e);
            return null;
        }
    }
}

