/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import unity.globalschema.GlobalSchema;
import unity.jdbc.UnityDatabaseMetaData;
import unity.jdbc.UnityStatement;

public class UnityConnection
implements Connection {
    private boolean CLOSED = false;
    private boolean READONLY = true;
    private GlobalSchema schema;
    int TRANSACTION_NONE = 0;
    int TRANSACTION_READ_UNCOMMITTED = 1;
    int TRANSACTION_READ_COMMITTED = 2;
    int TRANSACTION_REPEATABLE_READ = 4;
    int TRANSACTION_SERIALIZABLE = 8;

    public UnityConnection(GlobalSchema gs, Properties info) {
        this.schema = gs;
    }

    public Statement createStatement() throws SQLException {
        return new UnityStatement(this, 1003, 1007, this.schema);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005) {
            throw new SQLException("No support for TYPE_SCROLL_SENSITIVE Resultset. Use TYPE_SCROLL_INSENSITIVE instead.");
        }
        return new UnityStatement(this, resultSetType, resultSetConcurrency, this.schema);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public void commit() throws SQLException {
    }

    public void rollback() throws SQLException {
    }

    public void close() throws SQLException {
        this.CLOSED = true;
    }

    public boolean isClosed() throws SQLException {
        return this.CLOSED;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new UnityDatabaseMetaData(this.schema, this);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.READONLY = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.READONLY;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public int getTransactionIsolation() throws SQLException {
        return this.TRANSACTION_NONE;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    public Map getTypeMap() throws SQLException {
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
    }

    public void setHoldability(int holdability) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    public ArrayList getDatabases() {
        return this.schema.getAnnotatedDatabases();
    }
}

