/*
 * Decompiled with CFR 0.152.
 */
package unity.globalschema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.globalschema.SemanticName;
import unity.util.StringFunc;

public class GlobalConcept {
    String key;
    SemanticName semanticName;
    GlobalConcept parent;
    HashMap children = new HashMap();
    ArrayList sources = new ArrayList();
    int type;
    int depth;
    String termAtDepth;
    boolean displayAtDepth;
    int rootNode = 0;

    public GlobalConcept() {
    }

    public GlobalConcept(String name) {
        this.rootNode = 1;
        this.semanticName = new SemanticName("[" + name + "]");
        this.key = name;
        this.depth = 0;
        this.parent = null;
        this.type = 1;
        this.termAtDepth = "V";
        this.displayAtDepth = false;
    }

    public GlobalConcept(SemanticName name, String key, GlobalConcept parent, int type, int newDepth, String term) {
        this.semanticName = name;
        this.key = key;
        this.parent = parent;
        this.type = type;
        this.depth = newDepth;
        this.termAtDepth = term;
        this.displayAtDepth = false;
    }

    public String getTermAtDepth() {
        return this.termAtDepth;
    }

    public SemanticName getName() {
        return this.semanticName;
    }

    public String getKey() {
        return this.key;
    }

    public int getDepth() {
        return this.depth;
    }

    public GlobalConcept getParent() {
        return this.parent;
    }

    public boolean isProperty() {
        return this.type == 2;
    }

    public int getType() {
        return this.type;
    }

    public HashMap getChildren() {
        return this.children;
    }

    public ArrayList getChildrenArrayList() {
        ArrayList<GlobalConcept> concepts = new ArrayList<GlobalConcept>();
        TreeMap childrenNodes = new TreeMap(this.getChildren());
        Iterator children = childrenNodes.keySet().iterator();
        while (children.hasNext()) {
            String key = (String)children.next();
            concepts.add((GlobalConcept)childrenNodes.get(key));
        }
        return concepts;
    }

    public ArrayList getSources() {
        return this.sources;
    }

    public void addChild(GlobalConcept child) {
        this.children.put(child.getKey(), child);
    }

    public void addSource(Object obj) {
        this.sources.add(obj);
    }

    public String toString() {
        String s;
        block6: {
            String tp = " context ";
            if (this.type == 2) {
                tp = " property ";
            }
            s = String.valueOf(StringFunc.spaces(4 * this.depth)) + this.key + "\n";
            s = String.valueOf(s) + StringFunc.spaces(4 * this.depth) + "      Type: " + tp + "  depth: " + this.depth + "  term: " + this.termAtDepth + "\n";
            if (this.rootNode == 0) {
                s = String.valueOf(s) + StringFunc.spaces(4 * this.depth) + "      Parent: " + this.parent.getKey() + "\n";
            }
            if (this.sources.size() <= 0) break block6;
            s = String.valueOf(s) + StringFunc.spaces(4 * this.depth) + "       Sources: \n";
            if (this.type == 2) {
                int i = 0;
                while (i < this.sources.size()) {
                    s = String.valueOf(s) + ((AnnotatedSourceField)this.sources.get(i)).toStringField(this.depth + 2);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.sources.size()) {
                    s = String.valueOf(s) + StringFunc.spaces(4 * this.depth) + "        " + ((AnnotatedSourceTable)this.sources.get(i)).toString();
                    ++i;
                }
            }
        }
        return s;
    }
}

