/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Position
extends Function {
    private Expression substringExpr;
    private Expression stringExpr;

    public F_Position(Expression sub, Expression str) {
        this.substringExpr = sub;
        this.stringExpr = str;
    }

    public Object evaluate(Tuple t) {
        String substring = (String)this.substringExpr.evaluate(t);
        if (substring == null) {
            return new Integer(0);
        }
        String string = (String)this.stringExpr.evaluate(t);
        if (string == null) {
            return new Integer(0);
        }
        return new Integer(string.indexOf(substring) + 1);
    }

    public int getReturnType() {
        return 4;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_STRING, Attribute.TYPE_STRING};
    }

    public static String getFunctionName() {
        return "POSITION";
    }

    public String toString(Relation relation) {
        return "POSITION(" + this.substringExpr.toString(relation) + " IN " + this.stringExpr.toString(relation) + ")";
    }
}

