/*
 * Decompiled with CFR 0.152.
 */
package unity.extractor;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import unity.extractor.AnnotatedExtractor;

public class SourceBuilder
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static int FrameWidth = 700;
    private static int FrameHeight = 600;
    private String startMessage = "Select a location for the sources.xml file to begin \n  OR accept the default location, enter your source information, then click the add button.";
    private String addFailedMessage = "ERROR encountered.  Add data source failed.";
    private String addSuccessMessage = "SUCCESS.  Data source successfully added.";
    private JTextField txtSources;
    private JTextField txtName;
    private JTextField txtURL;
    private JTextField txtDriver;
    private JTextField txtXSpec;
    private JList lstSourceType;
    private JTextArea txtMessages;
    private JButton btnSourceBrowse;
    private JButton btnXSpecBrowse;
    private JButton btnExit;
    private JButton btnAdd;
    private static int fieldSize = 60;
    private String startDirectory = System.getProperty("user.dir");
    private Source[] sources;
    private File lastDirectory = null;

    public SourceBuilder() {
        this.initSources();
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout4 = new FlowLayout();
        flowLayout4.setAlignment(0);
        FlowLayout flowLayout3 = new FlowLayout();
        flowLayout3.setAlignment(0);
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(0);
        FlowLayout flowLayout1 = new FlowLayout();
        flowLayout1.setAlignment(0);
        GridLayout gridLayout = new GridLayout(5, 1);
        gridLayout.setHgap(5);
        gridLayout.setVgap(5);
        Font labelFont = new Font("DialogInput", 1, 12);
        Font listFont = new Font("SansSerif", 0, 12);
        Font textFont = new Font("SansSerif", 0, 11);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 2, 0), 185, 79);
        gridBagConstraints21.ipady = 0;
        gridBagConstraints21.gridwidth = 1;
        gridBagConstraints21.gridheight = 1;
        gridBagConstraints21.anchor = 10;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 0, 1, 0);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.ipadx = 650;
        gridBagConstraints2.ipady = 300;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 10;
        gridBagConstraints1.ipady = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 185;
        gridBagConstraints.ipady = 79;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setSize(new Dimension(FrameWidth, FrameHeight));
        this.setResizable(false);
        this.setTitle("Source Builder Utility");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(flowLayout);
        sourcePanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.txtSources = new JTextField(40);
        this.txtSources.setText(String.valueOf(this.startDirectory) + "\\sources.xml");
        sourcePanel.add((Component)new JLabel("Sources file:"), null);
        this.btnSourceBrowse = new JButton("Browse");
        this.btnSourceBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = SourceBuilder.this.getFile(SourceBuilder.this.txtSources.getText());
                if (f != null) {
                    SourceBuilder.this.txtSources.setText(f.getPath());
                }
            }
        });
        sourcePanel.add(this.txtSources);
        sourcePanel.add(this.btnSourceBrowse);
        this.btnExit = new JButton("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        sourcePanel.add(this.btnExit);
        JPanel addPanel = new JPanel();
        addPanel.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel leftAddPanel = new JPanel();
        addPanel.setLayout(new BoxLayout(addPanel, 0));
        leftAddPanel.setLayout(new BoxLayout(leftAddPanel, 3));
        this.lstSourceType = new JList<Source>(this.sources);
        this.lstSourceType.setFont(listFont);
        this.lstSourceType.setBorder(BorderFactory.createEtchedBorder(0));
        this.lstSourceType.setSelectionMode(0);
        JLabel lbl = new JLabel("Source Type");
        lbl.setAlignmentX(0.0f);
        this.lstSourceType.setAlignmentX(0.0f);
        this.lstSourceType.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int idx = SourceBuilder.this.lstSourceType.getSelectedIndex();
                SourceBuilder.this.txtURL.setText(((SourceBuilder)SourceBuilder.this).sources[idx].defaultURL);
                SourceBuilder.this.txtDriver.setText(((SourceBuilder)SourceBuilder.this).sources[idx].driverName);
                SourceBuilder.this.txtURL.repaint();
                SourceBuilder.this.txtDriver.repaint();
            }
        });
        leftAddPanel.add(lbl);
        leftAddPanel.add(this.lstSourceType);
        addPanel.add(leftAddPanel);
        JPanel rightAddPanel = new JPanel();
        JPanel tmp = new JPanel();
        lbl = new JLabel("Name:  ");
        lbl.setFont(labelFont);
        tmp.setLayout(flowLayout1);
        tmp.add((Component)lbl, null);
        rightAddPanel.setLayout(gridLayout);
        this.txtName = new JTextField(fieldSize);
        this.txtName.setFont(textFont);
        tmp.add(this.txtName);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        lbl = new JLabel("URL:   ");
        lbl.setFont(labelFont);
        tmp.setLayout(flowLayout2);
        tmp.add((Component)lbl, null);
        this.txtURL = new JTextField(fieldSize);
        this.txtURL.setFont(textFont);
        tmp.add(this.txtURL);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        lbl = new JLabel("Driver:");
        lbl.setFont(labelFont);
        tmp.setLayout(flowLayout3);
        tmp.add((Component)lbl, null);
        this.txtDriver = new JTextField(fieldSize);
        this.txtDriver.setFont(textFont);
        tmp.add(this.txtDriver);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        lbl = new JLabel("XSpec: ");
        lbl.setFont(labelFont);
        tmp.setLayout(flowLayout4);
        tmp.add((Component)lbl, null);
        this.txtXSpec = new JTextField(fieldSize - 2);
        this.txtXSpec.setFont(textFont);
        this.txtXSpec.setText(String.valueOf(this.startDirectory) + "\\output.xml");
        tmp.add(this.txtXSpec);
        this.btnXSpecBrowse = new JButton("...");
        this.btnXSpecBrowse.setFont(textFont);
        this.btnXSpecBrowse.setPreferredSize(new Dimension(18, 18));
        this.btnXSpecBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = SourceBuilder.this.getFile(SourceBuilder.this.txtXSpec.getText());
                if (f != null) {
                    SourceBuilder.this.txtXSpec.setText(f.getPath());
                }
            }
        });
        tmp.add(this.btnXSpecBrowse);
        rightAddPanel.add(tmp);
        this.btnAdd = new JButton("Add Source");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourceBuilder.this.doAdd();
            }
        });
        rightAddPanel.add(this.btnAdd);
        addPanel.add(rightAddPanel);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.txtMessages = new JTextArea(20, 60);
        this.txtMessages.setText(this.startMessage);
        JScrollPane scrollPane = new JScrollPane(this.txtMessages);
        scrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        messagePanel.add((Component)scrollPane, "Center");
        this.setContentPane(mainPanel);
        mainPanel.add((Component)sourcePanel, gridBagConstraints21);
        mainPanel.add((Component)addPanel, gridBagConstraints1);
        mainPanel.add((Component)messagePanel, gridBagConstraints2);
        addPanel.setFont(new Font("Dialog", 2, 12));
        rightAddPanel.setFont(new Font("Dialog", 2, 12));
    }

    public static void main(String[] argv) {
        SourceBuilder sb = new SourceBuilder();
        sb.setVisible(true);
    }

    private void initSources() {
        this.sources = new Source[7];
        this.sources[0] = new Source("oracle.jdbc.driver.OracleDriver", "Oracle", "jdbc:oracle:thin:<user>/<password>@<server>:1521/<service>");
        this.sources[1] = new Source("com.microsoft.jdbc.sqlserver.SQLServerDriver", "Microsoft SQL Server", "jdbc:microsoft:sqlserver://<server>;DatabaseName=<database>;User=<uid>;Password=<pw>");
        this.sources[2] = new Source("com.ibm.db2.jcc.DB2Driver", "IBM DB2", "jdbc:db2//<server>:<port>/<database>:user=<userId>;password=<password>;");
        this.sources[3] = new Source("com.mysql.jdbc.Driver", "MySQL", "jdbc:mysql://<server>/<database>?user=<userId>&password=<password>");
        this.sources[4] = new Source("org.postgresql.Driver", "Postgres", "jdbc:postgresql://<server>/<database>?user=<userId>&password=<password>");
        this.sources[5] = new Source("", "Generic - JDBC", "");
        this.sources[6] = new Source("sun.jdbc.odbc.JdbcOdbcDriver", "Generic - ODBC", "jdbc:odbc:<database>;UID=<userId>;PWD=<password>");
    }

    private File getFile(String orgFile) {
        JFileChooser chooser;
        if (orgFile != null && !orgFile.equals("")) {
            File tmp = new File(orgFile);
            chooser = new JFileChooser(tmp);
            chooser.setSelectedFile(tmp);
        } else {
            chooser = new JFileChooser();
            if (this.lastDirectory != null) {
                chooser.setCurrentDirectory(this.lastDirectory);
            } else {
                chooser.setCurrentDirectory(new File(this.startDirectory));
            }
        }
        chooser.setDialogTitle("Select Save File");
        chooser.setFileFilter(new XMLFileFilter());
        if (chooser.showSaveDialog(new JFrame()) == 0) {
            File f = chooser.getSelectedFile();
            if (f.isDirectory()) {
                return null;
            }
            this.lastDirectory = chooser.getCurrentDirectory();
            return f;
        }
        return null;
    }

    private void doAdd() {
        ExtractThread et = new ExtractThread(this);
        et.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void threadDoAdd() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.txtMessages.setText("");
        this.txtMessages.append("Preparing to add data source...\n");
        String sourceFileName = this.txtSources.getText();
        String xspecFileName = this.txtXSpec.getText();
        Connection con = null;
        String driverName = this.txtDriver.getText();
        String url = this.txtURL.getText();
        try {
            try {
                this.txtMessages.append("Registering driver: " + driverName + "\n");
                Class.forName(driverName);
                this.txtMessages.append("Driver successfully registered.\n");
                this.txtMessages.append("Connecting to database...\n");
                con = DriverManager.getConnection(url);
                this.txtMessages.append("Connection established to database.\n");
                AnnotatedExtractor extractor = new AnnotatedExtractor();
                extractor.setOutputArea(this.txtMessages);
                this.txtMessages.append("Extracting schema information.");
                extractor.extract(con);
                String dbName = this.txtName.getText();
                if (dbName != null && !dbName.equals("")) {
                    extractor.setDatabaseName(dbName);
                }
                this.txtMessages.append("Writing information into XML file.\n");
                File xSpec = new File(xspecFileName);
                extractor.exportXML(xSpec);
                this.txtMessages.append("Updating sources file.\n");
                File sourceFile = new File(sourceFileName);
                ArrayList<String> lines = new ArrayList<String>(200);
                FileWriter writer = null;
                if (!sourceFile.exists()) {
                    this.txtMessages.append("Creating new sources file.\n");
                    writer = new FileWriter(sourceFile);
                    writer.write("<SOURCES>\n");
                } else {
                    int i;
                    FileReader reader = new FileReader(sourceFileName);
                    BufferedReader breader = new BufferedReader(reader);
                    String st = breader.readLine();
                    while (true) {
                        if (st == null) {
                            breader.close();
                            reader.close();
                            writer = new FileWriter(sourceFile);
                            i = 0;
                            break;
                        }
                        lines.add(st);
                        st = breader.readLine();
                    }
                    while (i < lines.size() - 1) {
                        writer.write(String.valueOf((String)lines.get(i)) + "\n");
                        ++i;
                    }
                }
                writer.write("\t<DATABASE>\n");
                writer.write("\t\t<URL>" + url + "</URL>\n");
                writer.write("\t\t<DRIVER>" + driverName + "</DRIVER>\n");
                writer.write("\t\t<XSPEC>" + xspecFileName + "</XSPEC>\n");
                writer.write("\t</DATABASE>\n");
                writer.write("</SOURCES>\n");
                writer.close();
                this.txtMessages.append(this.addSuccessMessage);
            }
            catch (ClassNotFoundException ce) {
                this.txtMessages.append("ClassNotFoundException for Driver: " + ce.getMessage() + "\n");
                this.txtMessages.append("Make sure driver is in your classpath.\n");
                this.txtMessages.append(this.addFailedMessage);
            }
            catch (SQLException sqlEx) {
                this.txtMessages.append("SQLException during extract: " + sqlEx.getMessage() + "\n");
                this.txtMessages.append(this.addFailedMessage);
            }
            catch (IOException ex) {
                this.txtMessages.append("IOException during extract: " + ex.getMessage() + "\n");
                this.txtMessages.append(this.addFailedMessage);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.setCursor(null);
            throw throwable;
        }
        {
            Object var16_21 = null;
        }
        this.setCursor(null);
    }

    private class Source {
        public String driverName;
        public String sourceName;
        public String defaultURL;

        public Source(String dn, String sn, String URL2) {
            this.driverName = dn;
            this.sourceName = sn;
            this.defaultURL = URL2;
        }

        public String toString() {
            return this.sourceName;
        }
    }

    private class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && extension.toLowerCase().equals("xml")) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return "XML Files";
        }

        public String getExtension(File f) {
            String filename;
            int i;
            if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }
    }

    private class ExtractThread
    extends Thread {
        private SourceBuilder sb = null;

        public ExtractThread(SourceBuilder s) {
            this.sb = s;
        }

        public void run() {
            this.sb.threadDoAdd();
        }
    }
}

