/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Stack;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.LogEntry;
import sqlj.mesg.AuditorInstallerErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ref.ProfileImpl;
import sqlj.runtime.profile.ref.ProfileWrapper;
import sqlj.runtime.profile.util.AuditedProfile;
import sqlj.runtime.profile.util.Auditor;
import sqlj.runtime.profile.util.CustomizerHarness;
import sqlj.runtime.profile.util.PrintWriterAuditor;
import sqlj.runtime.profile.util.ProfileCustomizer;

public class AuditorInstaller
implements ProfileCustomizer {
    private boolean m_installOpt = true;
    private String m_logNameOpt = null;
    private int m_debugDepthOpt = -1;
    private String m_auditPrefixOpt = "";

    public AuditorInstaller() {
        this.setUninstall(false);
    }

    public boolean acceptsConnection(Connection connection) {
        return connection == null;
    }

    public boolean getUninstall() {
        return !this.m_installOpt;
    }

    public void setUninstall(boolean bl) {
        this.m_installOpt = !bl;
    }

    public String getLog() {
        return this.m_logNameOpt;
    }

    public void setLog(String string) {
        this.m_logNameOpt = string;
    }

    public String getPrefix() {
        return this.m_auditPrefixOpt;
    }

    public void setPrefix(String string) {
        this.m_auditPrefixOpt = string;
    }

    public int getDepth() {
        return this.m_debugDepthOpt;
    }

    public void setDepth(int n2) {
        this.m_debugDepthOpt = n2;
    }

    public boolean customize(Profile profile, Connection connection, ErrorLog errorLog) {
        boolean bl = false;
        Enumeration enumeration = profile.getCustomizations();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Customization customization = (Customization)enumeration.nextElement();
            if (this.m_installOpt) {
                profile.replaceCustomization(this.newCustomization(customization), customization);
                bl = true;
            } else if (customization instanceof AuditedCustomization) {
                Customization customization2 = ((AuditedCustomization)customization).m_wrappedCustomization;
                if (customization2 != null) {
                    profile.replaceCustomization(customization2, customization);
                } else {
                    profile.deregisterCustomization(customization);
                }
                bl = true;
            }
            ++n2;
        }
        if (this.m_installOpt) {
            profile.registerCustomization(this.newCustomization(null));
            bl = true;
        }
        if (bl) {
            if (this.m_installOpt) {
                errorLog.addEntry((LogEntry)new Info((Object)AuditorInstallerErrors.auditing_added()));
            } else {
                errorLog.addEntry((LogEntry)new Info((Object)AuditorInstallerErrors.auditing_removed()));
            }
        }
        return bl;
    }

    protected AuditedCustomization newCustomization(Customization customization) {
        return new AuditedCustomization(customization, this.m_debugDepthOpt, this.m_logNameOpt, this.m_auditPrefixOpt);
    }

    public static void main(String[] stringArray) {
        System.exit(AuditorInstaller.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "-customizer=sqlj.runtime.profile.util.AuditorInstaller";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return CustomizerHarness.mainStatus(stringArray2);
    }

    public static class AuditedCustomization
    implements Customization {
        private Customization m_wrappedCustomization;
        private int m_debugDepth = -1;
        private String m_auditPrefix = "";
        private String m_logName = null;
        public static final int MAX_DEBUG_DEPTH = -1;
        static final long serialVersionUID = -5914684966854696085L;

        public AuditedCustomization(Customization customization, int n2, String string, String string2) {
            this.m_wrappedCustomization = customization;
            this.m_debugDepth = n2;
            this.m_logName = string;
            this.m_auditPrefix = string2;
        }

        public Customization getWrappedCustomization() {
            return this.m_wrappedCustomization;
        }

        public boolean acceptsConnection(Connection connection) {
            if (this.m_wrappedCustomization == null) {
                return true;
            }
            return this.m_wrappedCustomization.acceptsConnection(connection);
        }

        public ConnectedProfile getProfile(Connection connection, Profile profile) throws SQLException {
            ConnectedProfile connectedProfile = this.m_wrappedCustomization == null ? ProfileImpl.getDefaultProfile(connection, profile.getProfileData()) : this.m_wrappedCustomization.getProfile(connection, profile);
            ConnectedProfile connectedProfile2 = connectedProfile;
            Stack<ConnectedProfile> stack = new Stack<ConnectedProfile>();
            int n2 = 0;
            while (this.m_debugDepth == -1 || n2 < this.m_debugDepth) {
                if (!(connectedProfile instanceof ProfileWrapper)) break;
                stack.push(connectedProfile);
                connectedProfile = ((ProfileWrapper)connectedProfile).getWrappedProfile();
                ++n2;
            }
            Auditor auditor = this.getAuditor();
            while (true) {
                ConnectedProfile connectedProfile3 = AuditedProfile.newProfile(connectedProfile, auditor);
                if (stack.empty()) {
                    return connectedProfile3;
                }
                ProfileWrapper profileWrapper = (ProfileWrapper)stack.pop();
                if (profileWrapper.setWrappedProfile(connectedProfile3)) break;
                connectedProfile = profileWrapper;
            }
            return connectedProfile2;
        }

        public Auditor getAuditor() throws SQLException {
            PrintWriter printWriter;
            try {
                printWriter = this.m_logName != null ? new PrintWriter((Writer)new FileWriter(this.m_logName, true), true) : new PrintWriter(System.out, true);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
            return new PrintWriterAuditor(printWriter, this.m_auditPrefix);
        }
    }
}

