#if !defined(AFX_DLGEDITPLOTF_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_)
#define AFX_DLGEDITPLOTF_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DlgEditPlotF.h : header file
//

#include "Plot3DF.h"

#include "..\common\PlotCalc.h"

#define	DEFAULT_SURFACE		"Torus"
#define	SURFACE_HIVE_SUBDIR	"Surfaces"

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotF dialog

class DlgEditPlotF : public CDialog
{
// Construction
public:
	DlgEditPlotF(CWnd* pParent = NULL);   // standard constructor
	void SetDefaults(void);
	void SaveToRegistry(void);
	int  GetFromRegistry(void);
	void UpdateDialogState(void);
	void AttachCalculator(PlotCalc* pPlotCalc);
	int  SetSurfaceName(CString name="");
	CString GetSurfaceName(void);
	CString GetPlotRegPath(void);
	CString GetSurfaceRegPath(void);

	// data
	int  m_is_equation_ok;
	COLORREF	m_line_color;
	COLORREF	m_background_color;
	CString		m_surface_name;
	int			m_use_sphere_range; // 0=use cube range, else use spherical range
	int			m_plot_mode;		// 0=cross sections, 1=parametric
	ClipMode    m_clip_mode;

// Dialog Data
	//{{AFX_DATA(DlgEditPlotF)
	enum { IDD = IDD_EDIT_PLOT_PARMS };
	CComboBox	m_ViewProgram;
	CComboBox	m_list_surfaces;
	double	m_xmin;
	double	m_xmax;
	double	m_ymin;
	double	m_ymax;
	double	m_zmin;
	double	m_zmax;
	double	m_zrotate;
	double	m_xytilt;
	BOOL	m_is_color;
	BOOL	m_remove_hidden_lines;
	double	m_scale;
	UINT	m_nzplanes;
	double	m_sphere_radius;
	double	m_sphere_xcenter;
	double	m_sphere_ycenter;
	double	m_sphere_zcenter;
	BOOL	m_is_clip_inverted;
	CString	m_sC1;
	CString	m_sC2;
	CString	m_sC3;
	CString	m_sC4;
	CString	m_sC5;
	CString	m_sC6;
	CString	m_sC7;
	CString	m_sC8;
	CString	m_sEquationStatus;
	CString	m_sPlotEquation;
	BOOL	m_show_axis;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(DlgEditPlotF)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	PlotCalc* m_pPlotCalc;	// equation calculator (we don't own this memory)

	// Generated message map functions
	//{{AFX_MSG(DlgEditPlotF)
	afx_msg void OnRadioRangeCube();
	afx_msg void OnRadioRangeSphere();
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioCrossSections();
	afx_msg void OnRadioParametric();
	afx_msg void OnButtonLineColor();
	afx_msg void OnButtonBackgroundColor();
	afx_msg void OnPaint();
	afx_msg void OnParmHelp();
	afx_msg void OnParmDefaults();
	afx_msg void OnRadioClipCube();
	afx_msg void OnRadioClipNone();
	afx_msg void OnRadioClipSphere();
	afx_msg void OnRadioClipUser();
	afx_msg void OnButtonTest();
	virtual void OnOK();
	afx_msg void OnButtonNew();
	afx_msg void OnButtonDelete();
	afx_msg void OnDropdownComboViewProgram();
	afx_msg void OnSelchangeComboListSurface();
	afx_msg void OnCancel();
	afx_msg void OnButtonSyntax();
	afx_msg void OnButtonSave();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLGEDITPLOTF_H__A277A2A4_92BD_11D3_8D3C_00105AE81499__INCLUDED_)
