// WinPlot3D.h
// Base plotting class provides drawing primitives for Windows 95/NT

#include "plot3d.h"

#ifndef	_WINPLOT3D_H_
#define	_WINPLOT3D_H_	1	// avoid re-including

/////////////////////////////////////////////////////////////////////////////
// Base plotting class provides drawing primitives for Windows 95/NT

class WinPlot3D
{
public:
	WinPlot3D();
	~WinPlot3D();

	// supply primitive move/draw for Windows
	void WinMoveTo(int xv,int yv);
	void WinDrawTo(int xv,int yv);
	void WinColorTo(long color);
	void WinPlotText(AXIS_PLOT_INFO* pAxisInfo,double degrees,int xv,int yv,CString text);

	// setup routines
	void SetWnd(CWnd* pWnd,CWinApp* pApp);
	void SetDrawRate(long draw_rate=0);
	void SetFileName(CString fn);
	void SetColorMode(int ShowColor=0) { m_is_color = ShowColor; }
	void SetMonochromePen(COLORREF color=RGB(0,0,0)) { m_monochrome_color = color; }
	void SetAbortFlag(int* pAbortFlag=NULL);
	void SetBackgroundColor(COLORREF bk_color=RGB(255,255,255)) { m_background_color = bk_color; }

	// supply "call-back" routines for Windows
	void WinBegPlot();
	void WinEndPlot();
	int  IsAbortRequested();

protected:
	CWinApp* m_pApp;	// pointer to the application (we don't own this resource)
	CWnd* m_pWnd;		// pointer to our window (we don't own this resource)
	CDC* m_pDC;			// device context
	COLORREF m_monochrome_color;	// pen color for monochrome plotting
	COLORREF m_background_color;	// background window color
	long m_draw_rate;	// 0=normal speed, else draw rate
	long m_draw_counts;	// increments after every line is drawn
	int	 m_is_color;	// 0=monochrome, 1=color
	FILE* m_fh_cap;		// handle of capture file to write pen movements to
	CString m_fn_cap;	// name of capture file to write draw/move commands to
	int* m_pAbortFlag;	// pointer to the abort flag that resides in the view
};

#endif	// _WINPLOT3D_H_

// ------------------------------  end WinPlot3D.H  ----------------------------

