' *****************************************************************************
' File    : Image2PDF.bas
' Author  : Utility Warrior, (c) 2005
' Project : Image to PDF (Image2PDF) Dynamic Link Library
' Purpose : This file provides Visual Basic 6 prototypes for all DLL functions
'
' Please refer to the accompanying documentation for full details.
' *****************************************************************************


' *************************************************************************
' This allows the support of multiple versions of a DLL (if and when
' available) so that functions that might only be available in a later
' version can then only be called if the returned version currently being 
' used is one that supports those functions.
'   
' Return value: integer value representing the DLL version
' a value of 100 is equivalent to version 1.00
' *************************************************************************
Declare Function I2PDF_GetDLLVersion Lib "Image2PDF.dll" () As Long


' *************************************************************************
' Required and Optional
' *************************************************************************
Declare Sub I2PDF_License Lib "Image2PDF.dll" (ByVal code As String)
' This is required to remove the "Evaluation Mode" message that is stamped 
' over the top of every page in the output PDF document.   
'
' To purchase a license code please visit the Utility Warrior web site which 
' has the latest information and prices on the licenses that are available. 
'
' Return value: none 


Declare Function I2PDF_AddImage Lib "Image2PDF.dll" (ByVal image As String) As Long
' Specifies the name and location of an image to embed within the output PDF 
' document. The image can be one of the following types: JPG, PNG, GIF, BMP, PCX or TGA.
'
' Up to 1000 images can be included.
'
' Images are embedded in the output PDF document in the order that they are 
' referenced.
'
' Return value:
' 0 - success
' 1 - invalid parameter
' 2 - maximum number of images already added
' 3 - invalid image type


Const VERTICAL_ALIGNMENT_TOP		= 1
Const VERTICAL_ALIGNMENT_MIDDLE		= 2
Const VERTICAL_ALIGNMENT_BOTTOM		= 3
Const HORIZONTAL_ALIGNMENT_LEFT		= 1
Const HORIZONTAL_ALIGNMENT_CENTER	= 2
Const HORIZONTAL_ALIGNMENT_RIGHT	= 3
Declare Function I2PDF_ImageStamp Lib "Image2PDF.dll" (ByVal image As String, verticalPosition As Long, horizontalPosition As Long, margin As Double) As Long
' Specifies the name and location of an image that is "stamped" at the specified 
' location on each page of the output PDF document. A margin between the image
' stamp and the edge of the page can be specified if required.
'
' Return value:
' 0 - success
' 1 - invalid image parameter
' 2 - invalid vertical position
' 3 - invalid horizontal position
' 4 - invalid margin

Declare Function I2PDF_StampURL Lib "Image2PDF.dll" (ByVal url As String) As Long
' This is optional and specifies the URL that the image stamp will open in the default browser when it is clicked on.
'
' A maximum of 128 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter

Const SLIDESHOW_WIPE_RIGHT							= 1
Const SLIDESHOW_WIPE_UP								= 2
Const SLIDESHOW_WIPE_LEFT							= 3
Const SLIDESHOW_WIPE_DOWN							= 4
Const SLIDESHOW_BARN_DOORS_HORIZONTAL_OUT			= 5
Const SLIDESHOW_BARN_DOORS_HORIZONTAL_IN			= 6
Const SLIDESHOW_BARN_DOORS_VERTICAL_OUT				= 7
Const SLIDESHOW_BARN_DOORS_VERTICAL_IN				= 8
Const SLIDESHOW_BOX_OUT								= 9
Const SLIDESHOW_BOX_IN								= 10
Const SLIDESHOW_BLINDS_HORIZONTAL					= 11
Const SLIDESHOW_BLINDS_VERTICAL						= 12
Const SLIDESHOW_DISSOLVE							= 13
Const SLIDESHOW_GLITTER_RIGHT						= 14
Const SLIDESHOW_GLITTER_DOWN						= 15
Const SLIDESHOW_GLITTER_TOP_LEFT_TO_BOTTOM_RIGHT	= 16
Const SLIDESHOW_REPLACE								= 17
Declare Function I2PDF_SlideShow Lib "Image2PDF.dll" (transition As Long, transitionDuration As Double, pageDisplayDuration As Double) As Long
' Forces the PDF document to be displayed full screen with the chosen screen transition between each page.
'
' Return value:
' 0 - success
' 1 - invalid transition
' 2 - invalid transition duration
' 3 - invalid page display duration

Declare Sub I2PDF_DeleteImagesOnConvert Lib "Image2PDF.dll" ()
' When the PDF document has been successfully produced all of the images converted to PDF are deleted.
'
' Return value: none 


' *************************************************************************
' PDF Settings
' *************************************************************************
Const OUTLINE_FORMAT_FILENAME	=	1
Const OUTLINE_FORMAT_NAME		=	2
Const STYLE_NONE				=	0
Const STYLE_LOWERCASE			=	1
Const STYLE_UPPERCASE			=	2
Const STYLE_CAPITALISE			=	3

Declare Function I2PDF_SetOutline Lib "Image2PDF.dll" (format As Long, style As Long) As Long
' This turns on the generation of a bookmark for each image that is in the 
' output PDF document.
'
' format can be either "filename" (this is the name of the image file including 
' the image extension but not including the full filepath) or "name" (same as 
' filename but without the image extension).
'
' style can be: "lowercase", "uppercase", "capitalise" or "none".
'
' Return value:
' 0 - success
' 1 - invalid format parameter
' 2 - invalid style parameter


Declare Sub I2PDF_SetPermissionEdit Lib "Image2PDF.dll" ()
' Allows editing/changing of the PDF document but NOT adding or changing of text 
' notes and AcroForm fields.
'
' Return value: none 


Declare Sub I2PDF_SetPermissionEditExtra Lib "Image2PDF.dll" ()
' Allows the adding and changing of text notes and AcroForm fields within a PDF document.
'
' Return value: none 


Declare Sub I2PDF_SetPermissionCopy Lib "Image2PDF.dll" ()
' Allows the copying of text and graphics from the PDF document.
'
' Return value: none 


Declare Sub I2PDF_SetPermissionPrint Lib "Image2PDF.dll" ()
' Allows printing of the PDF document.
'
' Return value: none 


Declare Function I2PDF_SetOwnerPassword Lib "Image2PDF.dll" (ByVal password as String) As Long
' The owner of a PDF document would enter this password in order to view it
' and make changes and perform actions that may be restricted to a normal user.
'
' A maximum of 32 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetUserPassword Lib "Image2PDF.dll" (ByVal password As String) As Long
' In order that only the intended user can view the PDF document, they must type
' in this password, otherwise the user is not allowed to read the PDF document.
'
' A maximum of 32 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetDPI Lib "Image2PDF.dll" (dpi As Long) As Long
' PDF documents use a default resolution setting of 72 DPI. Images created for 
' screen display under Windows will probably have a resolution of 96 DPI. If you 
' have created images for printing then you will probably need to use 300 or 600 DPI.
'
' If you do not adjust the default resolution setting then when displayed within a 
' PDF document on screen a 96 DPI image will appear 25% larger than expected. This 
' gets much worse for a 300 DPI image which will appear 416% larger than expected.
'
' Return value:
' 0 - success
' 1 - invalid parameter - dpi specified is less than 9
' 2 - invalid parameter - dpi specified is greater than 2880


' *************************************************************************
' PDF Meta Information
' *************************************************************************
Declare Function I2PDF_SetProducer Lib "Image2PDF.dll" (ByVal producer As String) As Long
' The name of the application that converted the document from its native format to PDF.
'
' A maximum of 256 characters can be used.
' 
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetCreator Lib "Image2PDF.dll" (ByVal creator As String) As Long
' If the document was converted into a PDF document from another form, this is 
' usually the name of the application that created the original document.
'
' A maximum of 256 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetAuthor Lib "Image2PDF.dll" (ByVal author As String) As Long
' The name of the person who created the PDF document.
'
' A maximum of 256 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetTitle Lib "Image2PDF.dll" (ByVal title As String) As Long
' The PDF document's title.
'
' A maximum of 256 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetSubject Lib "Image2PDF.dll" (ByVal subject As String) As Long
' The PDF document's subject.
'
' A maximum of 256 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Function I2PDF_SetKeywords Lib "Image2PDF.dll" (ByVal keywords As String) As Long
' A list of keywords associated with the PDF document.
'
' A maximum of 256 characters can be used.
'
' Return value:
' 0 - success
' 1 - invalid parameter


Declare Sub I2PDF_SetCreationDate Lib "Image2PDF.dll" ()
' The date that the PDF document was created.
'
' This is set using the current local time of the PC.
'
' Return value: none


' *************************************************************************
' PDF Viewer Preferences
' *************************************************************************
Declare Sub I2PDF_SetViewerPreferenceCenterWindow Lib "Image2PDF.dll" ()
' The window displaying the PDF document should be displayed in the center of 
' the computer's screen.
'
' Return value: none


Declare Sub I2PDF_SetViewerPreferenceHideToolbar Lib "Image2PDF.dll" ()
' The PDF viewer's toolbar should be hidden when the PDF document is active.
'
' Return value: none


Declare Sub I2PDF_SetViewerPreferenceHideMenubar Lib "Image2PDF.dll" ()
' The PDF viewer's menubar should be hidden when the PDF document is active.
'
' Return value: none


Declare Sub I2PDF_SetViewerPreferenceHideWindowUI Lib "Image2PDF.dll" ()
' The user interface elements within the PDF document's window should be hidden.
'
' Return value: none


Declare Sub I2PDF_SetViewerPreferenceFitWindow Lib "Image2PDF.dll" ()
' The PDF viewer should resize the window displaying the PDF document to fit the 
' size of the first displayed page of the PDF document.
'
' Return value: none


Declare Sub I2PDF_SetPageModeOutlines Lib "Image2PDF.dll" ()
' The PDF viewer should show the outline (ie bookmark) navigation item when the 
' PDF document is open.
'
' Return value: none


Declare Sub I2PDF_SetPageModeNone Lib "Image2PDF.dll" ()
' The PDF viewer should not show the outline (ie bookmark) or thumbnail navigation
' items when the PDF document is open.
'
' This is the default if no other page mode is specified.
'
' Return value: none


Declare Sub I2PDF_SetPageModeUseThumbs Lib "Image2PDF.dll" ()
' The PDF viewer should show the thumbnail navigation item when the PDF document 
' is open.
'
' Return value: none


Declare Sub I2PDF_SetPageModeFullScreen Lib "Image2PDF.dll" ()
' The PDF viewer should open the PDF document in full-screen mode without showing 
' the menu bar, window controls or any other window.
'
' Return value: none


Declare Sub I2PDF_SetPageLayoutSinglePage Lib "Image2PDF.dll" ()
' Display the pages one page at a time.
'
' Return value: none


Declare Sub I2PDF_SetPageLayoutOneColumn Lib "Image2PDF.dll" ()
' Display the pages in one column.
'
' Return value: none


Declare Sub I2PDF_SetPageLayoutTwoColumnLeft Lib "Image2PDF.dll" ()
' Display the pages in two columns, with odd-numbered pages on the left.
'
' Return value: none


Declare Sub I2PDF_SetPageLayoutTwoColumnRight Lib "Image2PDF.dll" ()
' Display the pages in two columns, with odd-numbered pages on the right.
'
' Return value: none


' *************************************************************************
' Specifies the name and location of the produced PDF document, 
' *************************************************************************
Declare Function I2PDF_MakePDF Lib "Image2PDF.dll" (ByVal output As String, bOpenPDF As Boolean, bReset As Boolean, ByRef errorText As String, maxErrorTextSize As Long) As Long
' Generate the output PDF according to the settings already selected through
' the Application Programming Interface functions above.
'
' To have the output PDF open in the default PDF viewer set the bOpenPDF
' parameter to true instead of false.
'
' To have all settings applied reset after PDF has been generated set the bReset
' parameter to true instead of false (does NOT reset the License code).
'
' Return value:
' 0 - success
' 1 - invalid parameter
' 2 - output pdf could not be opened
