(* Copyright (C) 1998, 1999 Stuart King. All rights reserved. *)
program lowname;
var
   param : integer;

   function UnixPlatform : boolean;
   begin
      case platform of
      platform_linux, platform_fbsd, platform_solaris, platform_solaris_sparc:
         UnixPlatform := true;
      otherwise
         UnixPlatform := true;
      end
   end;

   procedure syntax;
   begin
      writeln('lowname');
      writeln('SYNTAX: lowname file(s) ...');
      halt
   end;

   procedure ConvertFile(fname : filename);
   var
      f : text;
   begin
      assign(f, fname);
      rename(f, lowercase(fname))
   end;

   procedure ConvertTextFiles(f : filename);
   var
      DirPart, NamePart, ExtPart : filename;
      fname : filename;
      d : Dir;

      (***************************************************************
      ** PURPOSE: This function tests whether a file name is
      **          specified by a file spec (which may have wild cards).
      **          For example the file spec "test.*" specifies all file
      **          names with "test" as the name and any extension.
      **          So FileMatch("test.*", "test.dat") would return "true".
      ** NOTES: This function may be built-into Irie Pascal in the future
      **        but it's kept separate for now. Before building it in
      **        I want to be reasonably sure I can implement it on all
      **        platforms that Irie Pascal will eventually run on.
      *)
      function FileMatch(fspec, fname : filename) : boolean;
      var
         SpecPos, NamePos : integer;
         next : char;
         done : boolean;
      begin (* FileMatch *)
         (*
         ** File names under Unix are case sensitive but
         ** they aren't under other platforms. So for those platforms
         ** where file names are not case sensitive the file spec and
         ** file name are converted to all lower case so that their
         ** original case doesn't matter (i.e. "NAME" <> "Name" but by
         ** by converting "NAME" to "name" and "Name" to "name" they match).
         *)
         if not UnixPlatform then
            begin
               fspec := lowercase(fspec);
               fname := lowercase(fname)
            end;
         NamePos := 1;
         SpecPos := 1;
         done := false;
         repeat
            if (SpecPos>length(fspec)) and (NamePos>length(fname)) then
               begin
                  FileMatch := true;
                  done := true
               end
            else if (SpecPos>length(fspec)) and (NamePos<=length(fname)) then
               begin
                  FileMatch := false;
                  done := true
               end
            else if (SpecPos<=length(fspec)) and (NamePos>length(fname)) then
               begin
                  FileMatch := false;
                  done := true
               end
            else if fspec[SpecPos] = '?' then
               begin
                  inc(SpecPos);
                  inc(NamePos)
               end
            else if fspec[SpecPos] = '*' then
               begin
                  if SpecPos = length(fspec) then
                     begin
                        FileMatch := true;
                        done := true
                     end
                  else
                     begin
                        next := fspec[SpecPos+1];
                        NamePos := pos(next, fname, NamePos);
                        if NamePos > 0 then
                           inc(SpecPos)
                        else
                           begin
                              FileMatch := false;
                              done := true
                           end
                     end
               end
            else if fspec[SpecPos] = fname[NamePos] then
               begin
                  inc(SpecPos);
                  inc(NamePos)
               end
            else
               begin
                  FileMatch := false;
                  done := true
               end
         until done;
      end; (* FileMatch *)

   begin (* ConvertTextFiles *)
      f := fexpand(f);
      writeln(f);
      fsplit(f, DirPart, NamePart, ExtPart);
      NamePart := NamePart + ExtPart;
      OpenDir(d, DirPart);
      repeat
         ReadDir(d, fname);
         if fname <> '' then    (* if there are more files in directory *)
            begin
               if FileMatch(NamePart, fname) then
                  if fname <> lowercase(fname) then
                     ConvertFile(DirPart+fname)
            end
      until fname = '';
      CloseDir(d)
   end; (* ConvertTextFiles *)

begin
   if paramcount = 0 then
      syntax;
   for param := 1 to paramcount do
      ConvertTextFiles(paramstr(param));
end.
