#!/bin/csh -f
# Shell-script to compile lookup-table routines
#
# Set MDIR to be the directory where the Function-makefiles and C routines
# are.

set MDIR=$1

if (-f /bin/arch) then
  set arch=sun4
else
  set arch=vax
endif

set TABLE_DIR = $3
set FCN_DIR = $4


echo "arguments are $*"
set suffix=$2:e
set nborhood = `echo $suffix | sed 's/\(.\).*/\1/'`
echo "nborhood = $nborhood"
set rest = `echo $suffix | sed s/$nborhood//`
set nstates = `echo $rest | sed 's/\([0-9]*\).*/\1/'`
echo "nstates = $nstates"
set rest = `echo $rest | sed s/$nstates//`
set radius=``
if ("$#rest") then
	set char = `echo $rest | sed 's/\(.\).*/\1/'`
	if ("$char" != "r") then
		echo "bad character in filename extension: $char"
		exit 1
	endif
	set radius = `echo $rest | sed s/$char//`
	echo "radius = $radius"
endif


set compiler="cc"
set extension=".c"

if ("$nstates" == "256") then
    echo "making $2.$arch.o"
    $compiler -I$MDIR -c $2$extension
    mv $2.o $2.$arch.o
    if ($FCN_DIR != ".") mv $2.$arch.o $FCN_DIR
else
    if ("$#radius") then
	$compiler -I$MDIR -o MKTABLE -DOUTPUT=\"$2\" -DNSTATES=$nstates $2$extension $MDIR/main_loop.${nborhood}r$radius.c -lm && rm -f $2.o main_loop.${nborhood}r$radius.o && ./MKTABLE && if ($TABLE_DIR != ".") mv $2 $TABLE_DIR
    else
	$compiler -I$MDIR -o MKTABLE -DOUTPUT=\"$2\" -DNSTATES=$nstates $2$extension $MDIR/main_loop.$nborhood.c -lm && rm -f $2.o main_loop.$nborhood.o && ./MKTABLE && if ($TABLE_DIR != ".") mv $2 $TABLE_DIR
    endif
    rm -f ./MKTABLE
endif
