/*****
 *
 * File: nborhood.h
 *   By: Dave Hiebeler
 *       Summer 1989
 *
 * Definitions of neighborhood-structures and macros for use with
 * the 256-state computed-function updating.
 *
 *****/

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



typedef unsigned char byte;


/* Use integers, because when you do arithmetic with unsigned
 * characters overflow is a pain.
 */
typedef int cell_value;


typedef struct {
    cell_value tl, l, bl, t, c, b, tr, r, br,
    x, y, time, parm1, parm2;
} moore_nbors;

typedef struct {
    cell_value l, t, c, b, r,
    x, y, time, parm1, parm2;
} vonn_nbors;

typedef struct {
    cell_value c, ccw, opp, cw, phase,
    x, y, time, parm1, parm2;
} margolus_nbors;

typedef struct {
    cell_value l, c, r,
    x, time, parm1, parm2;
} lr1_nbors;

typedef struct {
    cell_value ll, l, c, r, rr,
    x, time, parm1, parm2;
} lr2_nbors;

typedef struct {
    cell_value lll, ll, l, c, r, rr, rrr,
    x, time, parm1, parm2;
} lr3_nbors;

typedef struct {
    unsigned char *array;
    int time;
    int size;
    int parm1, parm2;
} array_info_struct;


cell_value
    tl, l, bl, t, c, b, tr, r, br, ll, rr, lll, rrr, cw, ccw, opp, phase,
    x, y, time, parm1, parm2;

#define Get_moore_nbors \
    tl = nbors->tl; l = nbors->l; bl = nbors->bl; \
    t = nbors->t; c = nbors->c; b = nbors->b; \
    tr = nbors->tr; r = nbors->r; br = nbors->br; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; y = nbors->y ; time = nbors->time;

#define Get_vonn_nbors \
    l = nbors->l; c = nbors->c; r = nbors->r; t = nbors->t; b = nbors->b; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; y = nbors->y ; time = nbors->time;

#define Get_margolus_nbors \
    c = nbors->c; ccw = nbors->ccw; opp = nbors->opp; cw = nbors->cw; \
    phase = nbors->phase; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; y = nbors->y ; time = nbors->time;

#define Get_l_nbors \
    l = nbors->l; c = nbors->c; r = nbors->r; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; time = nbors->time;

#define Get_lr1_nbors Get_l_nbors

#define Get_lr2_nbors \
    ll = nbors->ll; l = nbors->l; c = nbors->c; r = nbors->r; rr = nbors->rr; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; time = nbors->time;

#define Get_lr3_nbors \
    lll = nbors->lll; ll = nbors->ll; l = nbors->l; c = nbors->c; \
    r = nbors->r; rr = nbors->rr; rrr = nbors->rrr; \
    parm1 = nbors->parm1; parm2 = nbors->parm2 ; \
    x = nbors->x ; time = nbors->time;


/* Some aliases */
#define center c
#define north t
#define south b
#define east r
#define west l
#define northeast tr
#define southeast br
#define northwest tl
#define southwest bl
#define clockwise cw
#define counterclockwise ccw
#define opposite opp


typedef unsigned char ((*func_ptr)());
typedef void ((*void_func_ptr)());

extern func_ptr update_function;
extern void_func_ptr before_function, after_function;

