/*****
 *
 * File: cm_cellsim.h
 *
 * Cellsim, cellular automata simulator
 *
 * Includes, defines, variables, etc related to controlling the CM.
 *
 *****/

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/



/*****
 *
 * Includes, typedefs
 *
 *****/

#include "cell.def"
#include "cm_cellproto.h"
#include "sock_rtns.h"

typedef unsigned char byte;


/*****
 *
 * External routines
 *
 *****/

extern void
    display_image(),	/* display image in SunView canvas */
    set_rgb_arrays();	/* set up rgb arrays to send cmap to CM */
extern int
    valid_CM_state(),	/* is current nhood valid for CM? */
    valid_CM_image();	/* is current image-size valid for CM? */


/*****
 *
 * External vars
 *
 *****/

extern byte
    *ca,	/* CA array */
    *ta;	/* lookup table */
extern int
    parm1, parm2,	/* global parms for computed-fcn rules */
    stime, *statecount,
    saved_ox, saved_oy,	/* vars for generating random images */
    saved_sx, saved_sy, saved_density,
    saved_min_val, saved_max_val,
    function, auto_nhood_change,
    TSIZE, SOCKET_INUSE,
    setting_sequence, use_CM;
extern short
    B, S, L, N, NHOOD, R;
extern char
    CM_hostname[80];
extern unsigned short CM_port;




/*****
 *
 * Local vars
 *
 *****/

/*** vars visible to external routines ***/
int
    CM_disp_interval=1,	/* used to skip frames when running w/ display */
    CM_delay=0,		/* delay between updates, to slow down CM */
    CM_zoom, CM_panx=0, CM_pany=0,	/* FB-related variables */
    use_FB, use_Sun_disp;	/* display flags */
char
    CM_image_dir[BUFLEN], CM_LT_dir[BUFLEN], CM_fcn_dir[BUFLEN];

/*** private vars ***/
static int server_fd;	/* fd of socket to CMFE */
static char saved_CM_rule_file[128];


/*****
 *
 * Local routines
 *
 *****/

void
    CM_auto_step(), CM_auto_screen(), CM_set_displays(),
    CM_send_cmap(), CM_send_delay(), CM_set_disp_interval(),
    CM_disconnect();
