      PROGRAM LARKIN                                                     
C                                                                        
C                                                                        
C                                                                        
C                                                                        
C                                                                        
C                                                                        
C                 *****************************                          
C                 *****************************                          
C                 ***                       ***                          
C                 ***      L A R K I N      ***                          
C                 ***      (REV. 3.1)       ***                          
C                 ***                       ***                          
C                 *****************************                          
C                 *****************************                          
C                                                                        
C                                                                        
C                                                                        
C                                                                        
C     *********************************************************          
C     *                                                       *          
C     *            THIS IS REVISION 3.1 OF LARKIN             *          
C     *                                                       *          
C     *             RELEASE DATE: MARCH 1, '86                *          
C     *                                                       *          
C     *********************************************************          
C                                                                        
C*********************************************************************** 
C                     REFERENCES                                       * 
C*********************************************************************** 
C                                                                      * 
C                                                                      * 
C /1/  P. DEUFLHARD, G. BADER, U. NOWAK:                               * 
C      LARKIN - A SOFTWARE PACKAGE FOR THE SIMULATION OF LARGE         * 
C      SYSTEMS ARISING IN CHEMICAL REACTION KINETICS                   * 
C      (UNIV. HEIDELBERG, SFB 123: TECHN. REP. 100 (1980))             * 
C      IN:                                                             * 
C      K.H. EBERT, P. DEUFLHARD, W. JAEGER (ED.):                      * 
C      MODELLING OF CHEMICAL REACTION SYSTEMS.                         * 
C      SPRINGER SERIES CHEM. PHYS. 18 (1981)                           * 
C                                                                      * 
C /2/  G.BADER, U.NOWAK, P.DEUFLHARD:                                  * 
C      AN ADVANCED SIMULATION PACKAGE FOR LARGE                        * 
C      CHEMICAL REACTION SYSTEMS                                       * 
C      UNIV. HEIDELBERG, SFB 123: TECHN. REP. 149 (1982)               * 
C                                                                      * 
C /3/  D.WALKOWIAK:                                                    * 
C      NUMERISCHE BEHANDLUNG GROSSER, ADIABATER CHEMISCHER             * 
C      REAKTIONSSYSTEME                                                * 
C      UNIV. HEIDELBERG, DIPLOMARBEIT, (1986)                          * 
C                                                                      * 
C                                                                      *
C                                                                      *
C                                                                      *
C                                                                      *
C                                                                      *
C                                                                      *
C* Licence                                                             *
C  -------                                                             *
C                                                                      *
C  You may use or modify this code for your own non-commercial         *
C  purposes for an unlimited time.                                     *
C  In any case you should not deliver this code without a special      *
C  permission of ZIB.                                                  *
C  In case you intend to use the code commercially, we oblige you      *
C  to sign an according licence agreement with ZIB.                    *
C                                                                      *
C                                                                      *
C* Warranty                                                            *
C  --------                                                            *
C                                                                      *
C  This code has been tested up to a certain level. Defects and        *
C  weaknesses, which may be included in the code, do not establish     *
C  any warranties by ZIB. ZIB does not take over any liabilities       *
C  which may follow from aquisition or application of this code.       *
C                                                                      *
C                                                                      *
C* Software status                                                     *
C  ---------------                                                     *
C                                                                      *
C  This code is under care of ZIB and belongs to ZIB software          *
C  class I.                                                            *
C                                                                      *
C                                                                      *
C                                                                      * 
C*********************************************************************** 
C    DRIVER ROUTINE FOR THE (INTERACTIVE) USE OF THE LARKIN PACKAGE    * 
C*********************************************************************** 
C                                                                      * 
C                                                                      * 
C  BEFORE STARTING THIS DRIVING ROUTINE, PLEASE OBSERVE (AT LEAST)     * 
C  THE FOLLOWING REMARKS:                                              * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C             STRUCTURAL DIAGRAM OF LARKIN - REV. 3.1                  * 
C*********************************************************************** 
C                                                                      * 
C                                                                      * 
C                             ----------                               * 
C                             ! DRIVER !                               * 
C                             ----------                               * 
C                              ! !  ! !                                * 
C        ----------------------- !  ! ------------------------         * 
C        !                 -------  ---------                !         * 
C        !                 !                !                !         * 
C        !                 !                !                !         * 
C   -----------       ----------       ----------       -----------    * 
C   ! COMPILE !       ! SIMULA !       ! NUMOUT !       ! GRAPHIC !    * 
C   -----------       ----------       ----------       -----------    * 
C     !    !           !     !           !  !             !    !       * 
C     !    -----    ----     ----    ----------------------    !       * 
C     !        !    !           !    !      !                  !       * 
C     !       ---------        ---------    !                  !       * 
C     !       ! INVAL !        !  OUT  !    !                  !       * 
C     !       ---------        ---------    !                  !       * 
C     !                                     !                  !       * 
C     !                                     !                  !       * 
C     !--------------------                 !                  !       * 
C     !                   !                 !                  !       * 
C   ----------        ----------       ------------     ------------   * 
C   ! CHEMIN !        ! THERMO !       ! PRINTER  !     ! PLOTTER  !   * 
C   ----------        ----------       ------------     ------------   * 
C                                      ! TERMINAL !     ! TERMINAL !   * 
C                                      ------------     ------------   * 
C                                                                      * 
C                                                                      * 
C  USER LEVEL:                                                         * 
C-------------                                                         * 
C  DRIVER  : CALL OF ALL OTHER PROGRAM BLOCKS                          * 
C                                                                      * 
C  PROGRAM LEVEL:                                                      * 
C----------------                                                      * 
C  COMPILE : 'CHEMICAL COMPILER', READING AND INTERPRETING OF INPUT.   * 
C  SIMULA  : SIMULATION (INTEGRATION) OF THE CHEMICAL SYSTEM.          * 
C  NUMOUT  : HANDLING OF NUMERICAL OUTPUT.                             * 
C  GRAPHIC : PLOT OF SOLUTION PROFILES                                 * 
C                                                                      * 
C  INPUT DATA SETS:                                                    * 
C------------------                                                    * 
C  CHEMIN  : CHEMICAL INPUT                                            * 
C  THERMO  : NASA-FITS OF THERMODYNAMIC POLYNOMIALS                    * 
C                                                                      * 
C  INTERMEDIATE DATA SETS: (STILL AVAILABLE AFTER LARKIN SESSION)      * 
C-------------------------                                             * 
C  INVAL   : OUTPUT OF COMPILATION, INPUT OF SIMULATION.               * 
C  OUT     : OUTPUT DATA SET WITH SOLUTION OF THE SIMULATION.          * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C             INTERACTIVE/BATCH USE                                    * 
C*********************************************************************** 
C                                                                      * 
C                                                                      * 
C  USE LARKIN WITH FULL INTERACTIVE DIALOG FACILITIES:                 * 
C  SET                                                                 * 
C    IBATCH = 0  (LINES ENCLOSED IN '  **  BATCH **' MAY BE DELETED)   * 
C                                                                      * 
C  USE LARKIN IN BATCH:                                                * 
C  SET                                                                 * 
C    IBATCH = 1  (LINES ENCLOSED IN '** BATCH **' MAY BE DELETED)      * 
C                A DIALOG SESSIN OF LARKIN IS SIMULATED. FILE 'ITERM'  * 
C                HAS TO BE ALLOCATED TO A DATASET, WHICH CONTAINS      * 
C                (LINE BY LINE) THE ANSWERS TO THE QUESTIONS OF THE    * 
C                DIALOG SYSTEM. ALL PRINT OUTPUT (INCLUDING DIALOG     * 
C                QUESTIONS) IS WRITTEN ON PRINTER.                     * 
C                                                                      * 
C  OR                                                                  * 
C    IBATCH = 2  (LINES ENCLOSED IN '**  DIALOG  **' MAY BE DELETED)   * 
C                 ONLY SUBSYSTEMS 'COMPILE' , 'SIMULATE' AND           * 
C                 'NUMERICAL OUTPUT' ARE AVAILABLE. DEFAULT VALUES     * 
C                 FOR OUTPUT CONTROL ARE SET INTERNALLY BUT MAY BE     * 
C                 CHANGED. ALL PRINT OUTPUT IS WRITTEN ON PRINTER.     * 
C                                                                      * 
C                                                                      * 
C  IMPLEMENTED STANDARD VALUE: IBATCH = 0                              * 
C                              ----------                              * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C             PRINT OUTPUT CONTROL                                     * 
C*********************************************************************** 
C                                                                      * 
C  PRINT OUTPUT IS CONTROLLED BY PARAMETER KPRINT. POSSIBLE VALUES     * 
C  FOR KPRINT ARE: 0/1/2 (READ 0/1/2 AS: 0 OR 1 OR 2)                  * 
C  ACCORDING TO KPRINT THE FOLLOWING OUTPUT IS WRITTEN                 * 
C                                                                      * 
C  IN DRIVER:                                                          * 
C    KPRINT = 0    ERROR MESSAGES AND DIALOG QUESTIONS                 * 
C           = 1/2  ERRORS,QUESTIONS AND CPU-TIMES                      * 
C                  (ONLY AVAILABLE IF SUITABLE TIME ROUTINES ARE SET   * 
C                   AND PARAMETER ITIME=1)                             * 
C                                                                      * 
C  IN SUBSYSTEM 'COMPILE':                                             * 
C    KPRINT = 0    ERROR MESSAGES ONLY                                 * 
C           = 1    ERROR MESSAGES AND WARNINGS                         * 
C           = 2    ERROR MESSAGES, WARNINGS AND COMIPLER INPUT         * 
C                  LISTING                                             * 
C                                                                      * 
C  IN SUBSYSTEM 'SIMULATE':                                            * 
C    KPRINT = 0    ERROR MESSAGES ONLY                                 * 
C           = 1    INTEGRATION MONITOR                                 * 
C           = 2    ENHANCED INTEGRATION MONITOR                        * 
C                                                                      * 
C  IN SUBSYSTEM 'NUMERICAL OUTPUT':                                    * 
C    KPRINT = 0    FIXED STANDARD OUTPUT LISTING                       * 
C           = 1,2  DIALOG QUESTIONS AND SELECTED (BY DIALOG) OUTPUT    * 
C                                                                      * 
C                                                                      * 
C  IN CASE OF IBATCH=0 THE OUTPUT IS WRITTEN ON TERMINAL. FOR          * 
C  IBATCH=1/2 ON PRINTER.                                              * 
C  (I.E.: KPRINT=1 WITH IBATCH=2 IS NOT POSSIBLE FOR SUBSYSTEM 'NUM.   * 
C   OUTPUT')                                                           * 
C                                                                      * 
C  FOR IBATCH=0 THE OUTPUT CAN BE DIRECTED TO THE PRINTER IF INSTEAD   * 
C  OF KPRINT=1/2/3  KPRINT=10/11/12 IS SET.                            * 
C                                                                      * 
C                                                                      * 
C  IMPLEMENTED STANDARD VALUE: KPRINT = 1                              * 
C                              ----------                              * 
C  (MAY BE TEMPORARY OVERWRITTEN IN DIALOG SESSION)                    * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C             CPU-TIME ROUTINES                                        * 
C*********************************************************************** 
C                                                                      * 
C  THE CALLS OF TIME ROUTINES ARE CONTROLLED BY PARAMETER ITIME        * 
C                                                                      * 
C  ITIME = 0   NO CALL OF TIME ROUTINES (AND NO ASSOCIATED PRINT       * 
C              OUTPUT). TIME ROUTINES MAY BE DUMMY ROUTINES.           * 
C                                                                      * 
C        = 1   TIME ROUTINES ARE NEEDED TO COMPUTE THE CPU-TIMES       * 
C              USED BY EACH SUBSYSTEM (VARIBLE 'STIME') AND OVERALL    * 
C              USED CPU-TIME (VARIABLE 'OTIME')                        * 
C                                                                      * 
C*********************************************************************** 
C                DIMENSIONS / MODEL PARAMETER                          * 
C*********************************************************************** 
C                                                                      * 
C  THE LARKIN-REV.3.1 PACKAGE PERFORMS THE VARIOUS MODELLINGS OF THE   * 
C  CHEMICAL SYSTEM ACCORDING TO A MODEL-PARAMETER 'MODEL', WHICH HAS   * 
C  TO BE DEFINED IN THE CHEMICAL INPUT FILE 'CHEMIN', WHERE:           * 
C                                                                      * 
C  MODEL = 1: ISOTHERMIC MODEL. (COMPARABLE TO VERSION REV.2.1)        * 
C        = 2: PRESCRIBED TEMPERATURE MODEL.                            * 
C        = 3: CONSTANT DENSITY MODEL.                                  * 
C        = 4: PRESCRIBED DENSITY MODEL.                                * 
C        = 5: CONSTANT PRESSURE MODEL.                                 * 
C        = 6: PRESCRIBED PRESSURE MODEL.                               * 
C                                                                      * 
C......................................................................* 
C           MAXIMUM DIMENSIONS, TO BE DECLARED BY THE USER             * 
C       ( MAY BE ADAPTED TO THE MAXIMUM EXPECTED PROBLEM SIZE)         * 
C......................................................................* 
C                                                                      * 
C  MAXEL: MAXIMUM NUMBER OF DIFFERENT ELEMENTS USED FOR                * 
C         STOICHIOMETRIC CHECK (.LE.10)                                * 
C                                                                      * 
C  MAXSP: MAXIMUM NUMBER OF DIFFERENT SPECIES IN CHEMICAL REACTION     * 
C         SYSTEM (.LT.1000)                                            * 
C                                                                      * 
C  MAXEQ: MAXIMUM NUMBER OF REACTION EQUATIONS (.LT.1000)              * 
C         ( REVERSIBLE EQUATIONS ARE COUNTED BY TWO)                   * 
C         ( MAXEQ HAS TO BE SET .GE.MAXSP )                            * 
C                                                                      * 
C  MAXENT: MAXIMUM NUMBER OF SPECIES ENTRIES IN CHEMICAL EQUATIONS     * 
C          (APPROXIMATELY : .LE.4  *MAXEQ)                             * 
C                                                                      * 
C  NRW: DIMENSION OF REAL WORK ARRAY RW                                * 
C                                                                      * 
C  NRWC: DIMENSION OF REAL WORK ARRAY RWC                              * 
C                                                                      * 
C  NIW: DIMENSION OF INTEGER WORK ARRAY IW                             * 
C                                                                      * 
C  NIWP: DIMENSION OF INTEGER WORK ARRAY IWP                           * 
C                                                                      * 
C  NCW: DIMENSION OF CHARACTER WORK SPACE                              * 
C                                                                      * 
C......................................................................* 
C           MAXIMUM DIMENSIONS, INTERNALLY CALCULATED                  * 
C......................................................................* 
C                                                                      * 
C  MAXDG: MAXIMUM NUMBER OF DIFFERENTIAL EQUATIONS ( = MAXSP + 2)      * 
C                                                                      * 
C  MAXCO: MAXIMUM NUMBER OF SPECIES, FOR WHICH THERMODYNAMICAL DATA    * 
C         IS GIVEN.  ( .LE. MAXSP )                                    * 
C                                                                      * 
C  MAXBB: VARIABLE PART OF LEFT HAND SIDE MATRIX B FOR MODELLATION     * 
C         OF CONSTANT/PRESCRIBED PRESSURE MODEL.                       * 
C         = MAXSP  FOR MODEL.GE.5                                      * 
C         = 1      ELSE                                                * 
C                                                                      * 
C  MAXTB: MAXIMUM NUMBER OF THIRD BODIES USED IN REACTION SYSTEM       * 
C         ( .LE. 5)                                                    * 
C                                                                      * 
C  MAXEF: MAXIMUM NUMBER OF EFFICIENCIES USED IN DEFINITION OF         * 
C         A L L  THIRD BODIES.  ( .LE. 5*MAXSP )                       * 
C                                                                      * 
C......................................................................* 
C                  ACTUAL DIMENSIONS                                   * 
C    ( INTERNALLY CALCULATED AND ADAPTED TO THE ACTUAL PROBLEM SIZE)   * 
C......................................................................* 
C                                                                      * 
C  IEL: ACTUAL NUMBER OF DIFFERENT ELEMENTS USED FOR                   * 
C       BALANCE CHECK                                                  * 
C                                                                      * 
C  NSP: ACTUAL NUMBER OF DIFFERENT SPECIES IN CHEMICAL REACTION        * 
C       SYSTEM                                                         * 
C                                                                      * 
C  N  : ACTUAL NUMBER OF DIFFERENTIAL EQUATIONS                        * 
C       = NSP       FOR MODEL = 1,2                                    * 
C       = NSP + 1   FOR MODEL = 3,4                                    * 
C       = NSP + 2   FOR MODEL = 5,6                                    * 
C                                                                      * 
C  NCEQ: ACTUAL NUMBER OF REACTION EQUATIONS                           * 
C        ( REVERSIBLE EQUATIONS ARE COUNTED BY TWO)                    * 
C                                                                      * 
C  LDIM: NUMBER OF NONZEROS IN JACOBIAN                                * 
C                                                                      * 
C  NTB:  NUMBER OF THIRD BODIES USED IN REACTION SYSTEM                * 
C                                                                      * 
C  NCTB: NUMBER OF EFFICIENCIES USED IN DEFINITION OF ALL THIRD BODIES * 
C                                                                      * 
C  NCO:  NUMBER OF SPECIES, FOR WHICH THERMODYNAMICAL DATA IS GIVEN    * 
C                                                                      * 
C  NB1:  = NSP FOR MODEL=5,6                                           * 
C        = 1   ELSE                                                    * 
C                                                                      * 
C  NLU: NUMBER OF NONZEROS IN DECOMPOSED JACOBIAN                      * 
C                                                                      * 
C  NLR: NUMBER OF POINTERS REPRESENTING THE STRUCTURE OF CHEMICAL      * 
C       SYSTEM AND RIGHT HAND SIDE OF ASSOCIATED ODE-SYSTEM (FCN)      * 
C                                                                      * 
C  ITPM: NUMBER OF OUTPUT POINTS                                       * 
C                                                                      * 
C*********************************************************************** 
C             DECLARATIONS                                             * 
C*********************************************************************** 
C                                                                      * 
C----------------------------------------------------------------------* 
C           STORAGE ESTIMATION OF WORK ARRAYS                          * 
C----------------------------------------------------------------------* 
C                        REAL:                                         * 
C                        -----                                         * 
C  FOR STORAGE OF CONSTANTS (UNCHANGED DURING SIMULATION)              * 
C      RWC(NRWC): NRWC = 3*MAXEQ + 14*MAXSP                            * 
C                 -------------------------                            * 
C  REMARK: THE 14*MAXSP STORAGE LOCATIONS ARE ONLY REQUIRED, IF THE    * 
C          NASA-FITS FOR ENTHALPIES ETC. ARE NEEDED FOR SIMULATION.    * 
C                                                                      * 
C  FOR INTERMEDIATE STORAGE                                            * 
C      RW(NRW): NRW = LDIM + NLU + 16*MAXDG + 2*MAXBB                  * 
C               -------------------------------------                  * 
C               WHERE APPROXIMATELY:  LDIM = 15*MAXDG                  * 
C                                     NLU  = 30*MAXDG                  * 
C               SO THAT AS A RULE OF THUMB: NRW = 63*MAXDG             * 
C                                           --------------             * 
C                                                                      * 
C  REMARK: THE ESTIMATIONS FOR LDIM AND NLU ARE VERY RUDE AND RATHER   * 
C          HIGH FOR GENERAL APPLICATIONS. THEY INCLUDE THE FULL ROWS   * 
C          AND COLUMNS OF THE JACOBIAN FOR NON-ISOTHERMIC SIMULATION.  * 
C          FOR ISOTHERMIC MODELLATION VALUES OF LDIM=8, NLU=16 ARE     * 
C          SUFFICIENT IN MANY CASES.                                   * 
C          SO PLEASE, OBSERVE THE STORAGE MESSAGES OF LARKIN FOR       * 
C          POSSIBLE REDUCTIONS.                                        * 
C                                                                      * 
C                     INTEGER:                                         * 
C                     --------                                         * 
C  FOR STORAGE OF POINTERS (UNCHANGED DURING SIMULATION)               * 
C      IWP(NIWP): NIWP = LDIM + 2*MAXEQ + 2*MAXDG + MAXCO              * 
C                 ---------------------------------------              * 
C                 AS A RULE OF THUMB: NIWP = 18*MAXDG + 2*MAXEQ        * 
C                                     -------------------------        * 
C                                                                      * 
C  FOR INTERMEDIATE STORGE                                             * 
C      IW(NIW): NIW = NLU + 13*MAXDG + MAXEF                           * 
C               ----------------------------                           * 
C               AS A RULE OF THUMB: NIW = 44*MAXDG                     * 
C                                   --------------                     * 
C                                                                      * 
C                     CHARACTER:                                       * 
C                     ----------                                       * 
C  FOR STORAGE OF NAMES                                                * 
C      CW(NCW): NCW = MAX( MAXSP*NAMEL , 360 )                         * 
C               ------------------------------                         * 
C               AS A RULE OF THUMB: NCW = 10*MAXSP                     * 
C                                   --------------                     * 
C                                                                      * 
C                                                                      * 
C                      COMMON BLOCKS:                                  * 
C                      --------------                                  * 
C                                                                      * 
C  FOR ADDITIONAL WORK ARRAYS:                                         * 
C                                                                      * 
C  GENERAL REMARK:                                                     * 
C  ADJUST IN ALL SUBROUTINES THE DIMENSIONING OF ARRAYS DEFINED IN     * 
C  COMMON, IF THE COMPILER DOESN'T ACCEPT THE DUMMY DIMENSIONING       * 
C  ARRAY(1) INSTEAD OF ARRAY(IDIM) WITH IDIM=EXPLICIT DEFINED          * 
C  DIMENSIONS OF ARRAY IN THE DRIVER                                   * 
C                                                                      * 
C                                                                      * 
C     COMMON / LARK1 / LR(MAXENT)                                      * 
C                      RULE OF THUMB: MAXENT=4*MAXEQ                   * 
C       USED IN MUBROUTINE: SIMULA , FCN , JACOBI , LIST               * 
C                                                                      * 
C     COMMON / LARK2 / PLR(2*MAXEQ)                                    * 
C       USED IN SUBROUTINE: SIMULA , FCN , JACOBI , LIST               * 
C                                                                      * 
C     COMMON / KINPAR / RK(MAXEQ)                                      * 
C       USED IN SUBROUTINE: SIMULA , SIMDAT , FCN , JACOBI             * 
C                                                                      * 
C     COMMON / RATE1 / R(L), L=MAX(MAXEQ,90)                           * 
C       USED IN SUBROUTINE: SIMULA , METASC , SIMDAT , FCN , JACOBI    * 
C                                                                      * 
C     COMMON / DELHR / DHR(MAXEQ)                                      * 
C       USED IN SUBROUTINE: METASC , SIMDAT , SIGNIF                   * 
C                                                                      * 
C  FOR LOGICAL UNITS:                                                  * 
C                                                                      * 
C     COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT* 
C     ( THIS COMMON BLOCK IS USED IN THE WHOLE PACKAGE )               * 
C                                                                      * 
C  FOR MACHINE DEPENDENT CONSTANTS:                                    * 
C                                                                      * 
C     COMMON / MACHIN / EPMACH , SMALL , EXPTT                         * 
C                                                                      * 
C      EPMACH: RELATIVE MACHINE PRECISION                              * 
C      SMALL : SQUARE ROOT OF SMALLEST POSITIVE MACHINE NUMBER         * 
C      EXPTT : BIGGEST NUMBER X ALLOWED FOR USE IN EXP(X)              * 
C                                                                      * 
C                                                                      * 
C  FOR HELP INFORMATION:                                               * 
C                                                                      * 
C     COMMON / INFORM / IHELP , INFDAT                                 * 
C                                                                      * 
C      IHELP: FLAG                                                     * 
C             =0  NO HELP INFORMATION AVAILABLE,                       * 
C                 I.E. SUBROUTINE HELP BECOMES A DUMMY ROUTINE AND     * 
C                 NO READ FROM LOGICAL UNIT INFDAT OCCURS              * 
C             =1  HELP INFORMATION IS WRITTEN IF AN INVALID ANSWER     * 
C                 TO A QUESTION OF AN DIALOG BLOCK IS ENTERED          * 
C                                                                      * 
C      INFDAT: LOGICAL UNIT FOR READ IN SUBROUTINE HELP (FROM THE      * 
C              DATABASE CONTAINING THE HELP INFORMATION ('INFO'))      * 
C                                                                      * 
C                                                                      * 
C                                                                      * 
C                                                                      * 
C--------------------------------------------------                    * 
C  IMPLEMENTED DECLARATIONS HOLDS FOR:                                 * 
C  MAXEL=10 , MAXSP=500 , MAXEQ=999 , MAXENT=4000 ,                    * 
C  RW=20000 , NIW=20000 , RWC=20000 , IWP=20000   , NCW=8000           * 
C--------------------------------------------------                    * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C              USER SUPPLIED SUBROUTINES/FUNCTIONS                     * 
C*********************************************************************** 
C                                                                      * 
C  FOR 'STANDARD SIMULATION', I.E. MODEL=1,3,5 NO SUBROUTINES OR       * 
C  FUNCTIONS HAVE TO BE SUPPLIED BY THE USER. ALL REQUIRED ROUTINES    * 
C  ARE ALREADY IMPLEMENTED IN LARKIN.                                  * 
C  IF  T I M E  - DEPENDENT PROFILES OF TEMPERATURE, DENSITY OR        * 
C  PRESSURE SHALL BE INVOLVED IN THE SIMULATION, THE FOLLOWING         * 
C  SUBROUTINES/FUNCTIONS HAVE TO BE SUPPLIED BY THE USER:              * 
C                                                                      * 
C  MODEL = 2 :    (DOUBLE PRECISION) FUNCTION HEAT(T)                  * 
C                     T     :  ACTUAL TIME POINT                       * 
C                     HEAT  :  TEMPERATURE(T)                          * 
C  MODEL = 4 :    SOUBROUTINE DPROF (T,DENSY,DDOT)                     * 
C                     T     :  ACTUAL TIME POINT                       * 
C                     DENSY :  DENSITY(T)                              * 
C                     DDOT  :  TIME DERIVATIVE OF DENSITY AT T         * 
C  MODEL = 6 :    SOUBROUTINE PPROF (T,PRESS,PDOT)                     * 
C                     T     :  ACTUAL TIME POINT                       * 
C                     PRESS :  PRESSURE(T)                             * 
C                     PDOT  :  TIME DERIVATIVE OF PRESSURE AT T        * 
C                                                                      * 
C  REMARK 1: THESE SUBROUTINES ARE ONLY CALLED IN SUBROUTINE 'FCN'.    * 
C            LARKIN PROVIDES DUMMY-SUBROUTINES IN THE CASES            * 
C            MODEL=1,3,5.                                              * 
C                                                                      * 
C*********************************************************************** 
C             INPUT/OUTPUT FILES                                       * 
C*********************************************************************** 
C                                                                      * 
C  LARKIN REQUIRES THE FOLLOWING FILES:                                * 
C  ( FIXED LOGICAL RECORD LENGTH = 80  (CARD IMAGE) )                  * 
C                                                                      * 
C  LOGICAL UNIT               FILE                                     * 
C                                                                      * 
C      ITIN                   'TERMINAL'                               * 
C      ITOUT                  'TERMINAL' ('PRINTER')*                    
C      MOUT                   MONITOR OUTPUT: 'TERMINAL' ('PRINTER')*    
C      EOUT                   ERROR OUTPUT: 'TERMINAL' ('PRINTER')*      
C      POUT                   'PRINTER'                                * 
C                                                                      * 
C      CIN                    CHEMICAL INPUT  (DATABASE 'CHEMIN')      * 
C                                                                      * 
C      DOUT                   NUMERICAL OUTPUT  (DATABASE 'OUT')       * 
C                             (FOR STORAGE OF OUTPUT FROM 'SIMULA'     * 
C                              USED AS INPUT FOR 'NUM. OUT','PLOT')    * 
C                                                                      * 
C      HDS                    WORK FILE 1                              * 
C                             (FOR INTERMEDIATE OUTPUT STORAGE)        * 
C                                                                      * 
C      SIN                    SIMULATION INPUT (DATABASE 'INVAL')      * 
C                             (FOR STORAGE OF OUTPUT FROM 'CHEMICAL    * 
C                              COMPILER', USED AS INPUT FOR 'SIMULA',  * 
C                              'OPTIONS')                              * 
C                                                                      * 
C      THDAT                  NASA -FITS OF THE THERMODYNAMICAL        * 
C                             POLYNOMIALS FOR ENTHALPY, HEAT CAPACITY  * 
C                             AND ENTROPY OF THE SPECIES.              * 
C                             (REQUIRED FOR INTERNAL COMPUTATION OF    * 
C                              REVERSE REACTION CONSTANTS AND IN ANY   * 
C                              CASE FOR NON-ISOTHERMIC MODELLATION,    * 
C                              I.E. FOR MODEL.GE.3)                    * 
C                                                                      * 
C  OPTIONAL:                                                           * 
C      INFDAT                 HELP INFORMATON (DATABASE 'INFO')        * 
C                                                                      * 
C                                                                      * 
C  IMPLEMENTED STANDARD VALUES:                                        * 
C      ITIN=5, ITOUT=6, MOUT=6, EOUT=6, CIN=8, HDS=9, POUT=10,         * 
C      SIN=11, DOUT=12, THDAT=13                                       * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C    OPTIONAL STANDARD SETTINGS FOR LARKIN SUBBLOCKS/SUBROUTINES       * 
C*********************************************************************** 
C                                                                      * 
C----------------------------------------------------------------------* 
C               FOR SUBBLOCK 'SIMULATION'                              * 
C----------------------------------------------------------------------* 
C  COMPUTATION OF REACTION CONSTANTS FOR REVERSE REACTIONS:            * 
C                                                                      * 
C  THERE ARE TWO WAYS OF HANDLING REVERSE REACTION CONSTANTS, DETER-   * 
C  MINED BY PARAMETER KREV. IT IS FOR                                  * 
C        KREV = 1 : COMPUTATION OF REVERSE REACTION CONSTANTS BY MASS- * 
C                   ACTION-LAW FOR EVERY CHANGE IN TEMPERATURE, IF NO  * 
C                   KINETIC PARAMETERS ARE GIVEN.                      * 
C        KREV = 2 : FOR A USER DEFINED TEMPERATURE RANGE (TLOW,THIGH)  * 
C                   THE KINETIC PARAMETERS (A,E,ALPHA) FOR REVERSE     * 
C                   REACTION ARE COMPUTED  O N C E  INITIALLY (USING   * 
C                   MASS-ACTION-LAW), SO THAT (MODIFIED) ARRHENIUS LAW * 
C                   CAN BE USED.                                       * 
C                                                                      * 
C        ACTUAL SETTINGS : KREV = 1 , TLOW=600 , THIGH=2500            * 
C        --------------------------------------------------            * 
C                                                                      * 
C----------------------------------------------------------------------* 
C               FOR SUBROUTINE 'SIMDAT'                                * 
C----------------------------------------------------------------------* 
C                                                                      * 
C  THE PRINT PARAMETER 'IPRINT', DEFINED IN INPUT DATA-SET 'CHEMIN',   * 
C  ACTUALLY CAUSES THE FOLLOWING OUTPUT HANDLING:                      * 
C  (MAY BE ALTERED BY THE SKILLFULL USER)                              * 
C                                                                      * 
C  AT EACH INTEGRATION POINT (I.E. CALL OF SIMDAT) THE FOLLOWING DATA  * 
C  ARE WRITTEN ON OUTPUT DATASET 'OUT':                                * 
C  1.) VALUE OF T                                                      * 
C  2.) VALUES OF CONC(I),I=1,NSP                                       * 
C  3.) VALUE OF T                                                      * 
C  4.) VALUE OF P,  P = SUM OF CONC(I),I=1,NSP                         * 
C  5.) VALUE OF T                                                      * 
C  6.) REACTION CONDITIONS (TEMPERATURE,DENSITY,PRESSURE,VOLUME)       * 
C                                                                      * 
C  ADDITIONALLY, FOR                                                   * 
C  IPRINT = 1  AND  T=TOUT(I),I=1,IOUT  (I.E. LPRINT = TRUE):          * 
C    7.) T                                                             * 
C    8.) RK(I),I=1,NCEQ (KINETIC PARAMETERS)                           * 
C  IPRINT = 2  AND  T=TOUT(I),I=1,IOUT  (I.E. LPRINT = TRUE):          * 
C    7.) T                                                             * 
C    8.) R(I),I=1,NCEQ   (RATES)                                       * 
C    9.) T                                                             * 
C   10.) DHR(I),I=1,NCEQ  (ENTHALPY PER REACTION)                      * 
C  IPRINT = 3  AND  T=TOUT(I),I=1,IOUT  (I.E. LPRINT = TRUE):          * 
C    7.) T                                                             * 
C    8.) RK(I),I=1,NCEQ                                                * 
C    9.) T                                                             * 
C   10.) R(I),I=1,NCEQ                                                 * 
C   11.) T                                                             * 
C   12.) DHR(I),I=1,NCEQ  (ENTHALPY PER REACTION)                      * 
C                                                                      * 
C                                                                      * 
C  FOR:                                                                * 
C  IPRINT = 4:                                                         * 
C    7.) T                                                             * 
C    8.) RK(I),I=1,NCEQ (KINETIC PARAMETERS)                           * 
C  IPRINT = 5:                                                         * 
C    7.) T                                                             * 
C    8.) R(I),I=1,NCEQ   (RATES)                                       * 
C    9.) T                                                             * 
C   10.) DHR(I),I=1,NCEQ  (ENTHALPY PER REACTION)                      * 
C  IPRINT = 6:                                                         * 
C    7.) T                                                             * 
C    8.) RK(I),I=1,NCEQ                                                * 
C    9.) T                                                             * 
C   10.) R(I),I=1,NCEQ                                                 * 
C   11.) T                                                             * 
C   12.) DHR(I),I=1,NCEQ  (ENTHALPY PER REACTION)                      * 
C                                                                      * 
C----------------------------------------------------------------------* 
C               FOR SUBROUTINE 'LIST'                                  * 
C----------------------------------------------------------------------* 
C                                                                      * 
C  IF THE DESIRED OUTPUT IS NOT CHOSEN BY DIALOG, LARKIN COMPOSES      * 
C  A FIXED STANDARD OUTPUT LISTING, WHICH IS ACTUALLY SET TO:          * 
C                                                                      * 
C       1.) ELEMENT AND SPECIES INFO                                   * 
C       2.) MOLAR CONCENTRATIONS                                       * 
C       3.) SUM OF MOLAR CONCENTRATIONS                                * 
C       4.) GAS CONDITIONS (TEMP.,PRESS.,DENSITY,VOLUME)               * 
C           (TOP AND HEAD ARE ALWAYS WRITTEN)                          * 
C                                                                      * 
C  AND WILL BE LISTED AT EACH OUTPUT POINT DEFINED IN 'CHEMIN', IF     * 
C  AVAILABLE FROM DATA-SET 'OUT'.                                      * 
C                                                                      * 
C  THE COMPOSITION OF THE FIXED STANDARD OUTPUT MAY BE ALTERED BY      * 
C  THE SKILLFUL USER IN SUBROUTINE 'LIST'.                             * 
C                                                                      * 
C*********************************************************************** 
C             MACHINE DEPENDENT STATEMENTS                             * 
C*********************************************************************** 
C                                                                      * 
C                                                                      * 
C  NOTE THAT MACHINE DEPENDENT STATEMENTS ARE ENCLOSED IN '==='-LINES  * 
C  THEY APPEAR ONLY IN THIS DRIVER AND IN SUBROUTINE PLOT1.            * 
C  CURRENTLY ADAPTED TO IBM 3081-D  OF UNIVERSITY OF HEIDELBERG        * 
C  AND CALCOMP-SOFTWARE                                                * 
C                                                                      * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
C----------------------------------------------------------------------- 
C                      DECLARATIONS                                      
C----------------------------------------------------------------------- 
C                                                                        
      DOUBLE PRECISION RW(20000),RWC(20000)                              
CSP       REAL RW(20000),RWC(20000)                                      
C                                                                        
CI4       INTEGER IW(20000),IWP(20000)                                   
      INTEGER*2 IW(20000),IWP(20000)                                     
      INTEGER MAXEL,MAXSP,MAXEQ,MAXENT                                   
      INTEGER NRW,NIW,NRWC,NIWP,IBATCH,KPRINT                            
      INTEGER ITIME,KREV,NRW4,NCW,KFLAG,IFLAG,NIW4                       
C                                                                        
      REAL OTIME,STIME,COMPTI,SIMTI,OUTTI,ALLTI,ZEIT1,ZEIT2              
      CHARACTER*1 CW(8000)                                               
C                                                                        
      DOUBLE PRECISION EPMACH,EXPTT,RK,SMALL,TLOW,THIGH,X                
CSP       REAL EPMACH,EXPTT,RK,SMALL,TLOW,THIGH,X                        
C                                                                        
      REAL FLOAT,R,DHR                                                   
C                                                                        
      INTEGER NUM(2),IFIXO,IEXO,IUND,IFIXD,IFLD                          
C                                                                        
      INTEGER ITERM,ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT     
C                                                                        
CI4       INTEGER LR,PLR                                                 
      INTEGER*2 LR,PLR                                                   
C                                                                        
      CHARACTER*1 TAB(2,5)  
      CHARACTER*18  FTYP(6)
      INTEGER       NFTYP(6),LFNO(6),NOFF
C                                                                        
      LOGICAL MASK
      INTEGER LP
      LOGICAL ABORT1,ABORT2,ABORT3
      INTEGER IRNCP,ICNCP,IRANK,MINIRN,MINICN 
      DOUBLE PRECISION EPS,RMIN
CSP       REAL EPS,RMIN
      DOUBLE PRECISION RESID 
CSP       REAL RESID
      INTEGER NSTEP,NFCN,NANFA,NTFAC,NFAC,NSOL,NTHERM,NKIP     
      DOUBLE PRECISION TEMP,DENSY,PRESS,VOLUME,XMASS 
CSP       REAL TEMP,DENSY,PRESS,VOLUME,XMASS 
      INTEGER ICOUNT                                                     
     
C                                                                        
C----------------------------------------------------------------------- 
C               COMMON - BLOCKS                                          
C----------------------------------------------------------------------- 
C                                                                        
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
      COMMON / MACHIN / EPMACH,SMALL,EXPTT                               
C                                                                        
      COMMON / INFORM / IHELP,INFDAT                                     
C                                                                        
      COMMON / LARK1  / LR(5000)                                         
C                       PLR(MAXENT)                                      
      COMMON / LARK2  / PLR(2000)                                        
C                       LR(2*MAXEQ)                                      
      COMMON / KINPAR / RK(1000)                                         
C                       RK(MAXEQ)                                        
      COMMON / RATE1  / R(1000)                                          
C                       R(L),L:=MAX(MAXEQ,90)                            
      COMMON / DELHR  / DHR(1000)                                        
C                       DHR(MAXEQ) 
      COMMON /MA30LE/ LP,ABORT1,ABORT2,ABORT3
C
      COMMON /MA30LF/ IRNCP,ICNCP,IRANK,MINIRN,MINICN 
C
      COMMON /MA30LG/ EPS,RMIN 
C
      COMMON /MA30LH/ RESID 
C
      COMMON / COUNT  / NSTEP,NFCN,NANFA,NTFAC,NFAC,NSOL,NTHERM,NKIP     
C                                                                        
      COMMON / RECOND / TEMP,DENSY,PRESS,VOLUME,XMASS 
C                                                    
      COMMON / CCC / ICOUNT      
C                                                                        
C----------------------------------------------------------------------- 
C               MAXIMUM DIMENSIONS AND CONSTANTS                         
C----------------------------------------------------------------------- 
C                                                                        
C  DEFINE MAXIMUM DIMENSIONS FOR PROBLEM SIZE                            
      DATA MAXEL/10/ , MAXSP/500/ , MAXEQ/999/ , MAXENT/5000/            
C                                                                        
C  DEFINE DIMENSIONS OF WORK ARRAYS                                      
      DATA NRW/20000/ , NIW/20000/ , NRWC/20000/ , NIWP/20000/ ,         
     &     NCW/8000/                                                     
C                                                                        
C  DEFINE HOLLERITH CONSTANTS (FOR INTERACTIVE DIALOG)                   
      DATA TAB(1,1)/'C'/ , TAB(1,2)/'S'/ , TAB(1,3)/'N'/ ,               
     &     TAB(1,4)/'P'/ , TAB(1,5)/'Q'/ ,                               
     &     TAB(2,1)/'c'/ , TAB(2,2)/'s'/ , TAB(2,3)/'n'/ ,               
     &     TAB(2,4)/'p'/ , TAB(2,5)/'q'/  
      DATA FTYP/'CHEMIN' , 'THERMO' , 'WORK' , 'PRINTER' ,
     &          'INVAL' , 'OUT' /  
      DATA NFTYP/6,6,4,7,5,3/
      DATA NOFF/6/, LFNO/10,15,11,12,13,14/                  
C                                                                        
C----------------------------------------------------------------------- 
C               DEFINE LOGICAL UNITS                                     
C----------------------------------------------------------------------- 
C                                                                        
      ITIN=5                                                             
      ITOUT=6                                                            
      CIN=10                                                             
      HDS=11                                                             
      POUT=12                                                            
      SIN=13                                                             
      DOUT=14                                                            
      THDAT=15                                                           
C                                                                        
                                                      
      MOUT=ITOUT                                                         
      EOUT=ITOUT                                                         
C                                                                        
C                                                                        
C----------------------------------------------------------------------- 
C             SET STANDARD VALUES (MAY BE ALTERED)                       
C----------------------------------------------------------------------- 
C                                                                        
C  FOR DIALOG/BATCH OPTION OF DRIVER                                     
C-----------------------------------                                     
C                                                                        
      IBATCH=0                                                           
C                                                                        
C                                                                        
C  FOR OUTPUT CONTROL                                                    
C--------------------                                                    
C                                                                        
      KPRINT=1                                                           
C                                                                        
C                                                                        
C  FOR CPU-TIME CONTROL                                                  
C----------------------                                                  
C                                                                        
      ITIME=1                                                            
C                                                                        
C                                                                        
C  FOR HELP INFORMATION                                                  
C----------------------                                                  
C                                                                        
      IHELP=1                                                            
C                                                                        
C                                                                        
C  FOR COMPUTATION OF REVERSE REACTION CONSTANTS                         
C-----------------------------------------------                         
C                                                                        
      KREV=1                                                             
      TLOW=6.D2                                                          
CSP       TLOW=6.E2                                                      
      THIGH=2.5D3                                                        
CSP       THIGH=2.5E3                                                    
C                                                                        
C                                                                        
C----------------------------------------------------------------------- 
C                SET MACHINE DEPENDENT STATEMENTS                        
C         (ADAPTED TO IBM 3081-D, UNIVERSITY OF HEIDELBERG)              
C----------------------------------------------------------------------- 
C                                                                        
C======================================================================= 
C                                                                        
C  RELATIVE MACHINE PRECISION                                            
C----------------------------                                            
      EPMACH=0.111D-15                                                   
CSP       EPMACH=0.569E-7                                                
C                                                                        
C  SQUARE-ROOT OF SMALLEST POSITIVE MACHINE-NUMBER                       
C-------------------------------------------------                       
      SMALL=0.149D-153                                                   
CSP       SMALL=0.108E-18                                                
C                                                                        
C  BIGGEST REAL NUMBER ALLOWED FOR USE OF 'EXP(..)' OR 'DEXP(...)'       
C-----------------------------------------------------------------       
      EXPTT=0.707D3                                                      
CSP       EXPTT=0.864E2                                                  
C                                                                        
C  SUPPRESS UNDERFLOW                                                    
C--------------------                                                    
      MASK=.TRUE.                                                        
C     CALL ERRSET (208,256,-1,1,1,207)                                   
C     IFIXO=10                                                           
C     IEXO=10                                                            
C     IUND=10000                                                         
C     IFIXD=10                                                           
C     IFLD=10                                                            
C     CALL TRAPS (IFIXO,IEXO,IUND,IFIXD,IFLD)                            
C======================================================================= 
C                                                                        
C  WRITE TOP                                                             
C-----------                                                             
C                                                                        
      IF(IBATCH.GE.1) ITOUT=POUT                                         
      WRITE(ITOUT,8000)                                                  
C                                                                        
      WRITE(ITOUT,8005)
C
      CALL ANSMOD(FTYP,NFTYP,NOFF)                                      
C                                                                        
C     OPEN(UNIT=9)                                                       
C     OPEN(UNIT=6) 
      DO 10 I=1,NOFF
      OPEN(UNIT=LFNO(I), FILE=FTYP(I)(:NFTYP(I)))
10    CONTINUE                                                      
C                  C                                                                        
      IF(IBATCH.EQ.2) GOTO 1000                                          
C                                                                        
C                                                                        
C*********************************************************************** 
C                START DIALOG WITH LARKIN                                
C*********************************************************************** 
C                                                                        
      OTIME=0.                                                           
C                                                                        
C-----------------------------                                           
C  CONTROL INTERACTIVE SESSION                                           
C-----------------------------                                           
C                                                                        
100   CONTINUE                                                           
C                                                                        
C  RESET STANDARD VALUES                                                 
      KFLAG=KPRINT                                                       
C     ITOUT=ITIN                                                         
      IF(IBATCH.GE.1) ITOUT=POUT 
C
      WRITE(ITOUT,8010)                                                  
C                                                                        
C                                                                        
      CALL ANSNUM (TAB,5,NUM,1,X,IFLAG,1)                                
C                                                                        
      IF(NUM(1).GE.0.AND.NUM(1).LE.13) KFLAG=NUM(1)                      
C                                                                        
C=================================                                       
      CALL SECOND(ZEIT1)                                                 
C=================================                                       
C                                                                        
      GOTO (300,400,500,600,800) , IFLAG                                 
C                                                                        
      GOTO 800                                                           
C                                                                        
C  CALL SUBSYSTEM 'CHEMICAL COMPILER'                                    
C--------------------------------------                                  
C                                                                        
300   CONTINUE                                                           
      IF(KFLAG.LT.10) GOTO 301                                           
      KFLAG=KFLAG-10                                                     
      ITOUT=POUT                                                         
301   CONTINUE                                                           
C                                                                        
330   CONTINUE                                                           
      CALL COMPIL (MAXSP,MAXEQ,MAXEL,MAXENT,NIW,NIWP,IW,IWP,LR,          
     &             PLR(1),PLR(MAXEQ+1),CW,NCW,KFLAG)                     
C                                                                        
      IF(ITIME.EQ.0) GOTO 310                                            
C                                                                        
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      STIME=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      OTIME=OTIME+STIME                                                  
      IF(KPRINT.GE.1) WRITE(ITOUT,8100) STIME                            
310   IF(KFLAG.GE.0) GOTO 100                                            
      WRITE(ITOUT,9300)                                                  
      IF(IBATCH.GE.1) GOTO 800                                           
      GOTO 100                                                           
C                                                                        
C  CALL SUBSYSTEM 'SIMULATION'                                           
C-----------------------------                                           
C                                                                        
400   CONTINUE                                                           
      IF(KFLAG.LT.10) GOTO 401                                           
      KFLAG=KFLAG-10                                                     
      ITOUT=POUT                                                         
401   CONTINUE                                                           
C                                                                        
      RW(1)=TLOW                                                         
      RW(2)=THIGH                                                        
      IW(1)=KREV                                                         
      CALL SIMULA (RW,NRW,RWC,NRWC,IW,NIW,IWP,NIWP,CW,NCW,KFLAG)         
C                                                                        
      IF(ITIME.EQ.0) GOTO 420                                            
C                                                                        
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      STIME=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      OTIME=OTIME+STIME                                                  
      IF(KPRINT.GE.1) WRITE(ITOUT,8100) STIME                            
420   IF(KFLAG.GE.0) GOTO 100                                            
      WRITE(ITOUT,9400)                                                  
      IF(IBATCH.GE.1) GOTO 800                                           
      GOTO 100                                                           
C                                                                        
C  CALL SUBSYSTEM 'NUMERICAL OUTPUT'                                     
C-----------------------------------                                     
C                                                                        
500   CONTINUE                                                           
C                                                                        
      CALL NUMOUT (NRW,RW,NIWP,IWP,NCW,CW,KFLAG)                         
C                                                                        
      IF(ITIME.EQ.0) GOTO 502                                            
C                                                                        
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      STIME=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      OTIME=OTIME+STIME                                                  
      IF(KPRINT.GE.1) WRITE(ITOUT,8100) STIME                            
502   IF(KFLAG.GE.0) GOTO 100                                            
      WRITE(ITOUT,9500)                                                  
      IF(IBATCH.GE.1) GOTO 800                                           
      GOTO 100                                                           
C                                                                        
C  CALL SUBSYSTEM 'GRAPHIC OUTPUT'                                       
C---------------------------------                                       
C                                                                        
600   CONTINUE                                                           
      NRW4=NRW*2                                                         
CSP       NRW4=NRW                                                       
      NIW4=NIW/2                                                         
C                                                                        
C     CALL GRAPH (RW,NRW4,IW,NIW4,KFLAG)                                 
C                                                                        
      WRITE(ITOUT,9699)                                                  
C                                                                        
      IF(ITIME.EQ.0) GOTO 602                                            
C                                                                        
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      STIME=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      OTIME=OTIME+STIME                                                  
      IF(KPRINT.GE.1) WRITE(ITOUT,8100) STIME                            
602   IF(KFLAG.GE.0) GOTO 100                                            
      WRITE(ITOUT,9600)                                                  
      IF(IBATCH.GE.1) GOTO 800                                           
      GOTO 100                                                           
C                                                                        
C  END INTERACTIVE LARKIN SESSION                                        
C--------------------------------                                        
C                                                                        
800   CONTINUE                                                           
      WRITE(ITOUT,8900)                                                  
      WRITE(ITOUT,8910) OTIME                                            
C                                                                        
      STOP                                                               
C                                                                        
C                                                                        
C*********************************************************************** 
C                   END DIALOG WITH LARKIN                               
C*********************************************************************** 
C                                                                        
1000  CONTINUE                                                           
C                                                                        
C*********************************************************************** 
C                   START LARKIN IN BATCH                                
C*********************************************************************** 
C                                                                        
C  OUTPUT TO PRINTER                                                     
      ITOUT=POUT                                                         
C                                                                        
C SET PRINT OPTION FOR COMPILER (KFLAG = 0/1/2)                          
      KFLAG=2                                                            
C                                                                        
C=================================                                       
      CALL SECOND(ZEIT1)                                                 
C=================================                                       
      CALL COMPIL (MAXSP,MAXEQ,MAXEL,MAXENT,NIW,NIWP,IW,IWP,LR,          
     &             PLR(1),PLR(MAXEQ+1),CW,NCW,KFLAG)                     
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      COMPTI=ZEIT2-ZEIT1                                                 
C============================                                            
C                                                                        
      IF(KFLAG.LT.0) GOTO 1100                                           
C                                                                        
C SET PRINT OPTION FOR SIMULATION (KFLAG = 0/1/2)                        
      KFLAG=2                                                            
C                                                                        
      RW(1)=TLOW                                                         
      RW(2)=THIGH                                                        
      IW(1)=KREV                                                         
C=================================                                       
      CALL SECOND(ZEIT1)                                                 
C=================================                                       
      CALL SIMULA (RW,NRW,RWC,NRWC,IW,NIW,IWP,NIWP,CW,NCW,KFLAG)         
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      SIMTI=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      IF(KFLAG.LT.0) GOTO 1100                                           
C                                                                        
C SET PRINT OPTION FOR NUMERICAL OUTPUT (KFLAG = 0)                      
      KFLAG=0                                                            
C                                                                        
C=================================                                       
      CALL SECOND(ZEIT1)                                                 
C=================================                                       
      CALL NUMOUT (NRW,RW,NIWP,IWP,NCW,CW,KFLAG)                         
C============================                                            
      CALL SECOND(ZEIT2)                                                 
      OUTTI=ZEIT2-ZEIT1                                                  
C============================                                            
C                                                                        
      ALLTI=COMPTI + SIMTI + OUTTI                                       
      WRITE(ITOUT,18900) COMPTI,SIMTI,OUTTI,ALLTI                        
C                                                                        
      IF(KFLAG.LT.0) GOTO 1100                                           
C                                                                        
      STOP                                                               
C                                                                        
C                                                                        
C*********************************************************************** 
C                  END LARKIN IN BATCH                                   
C*********************************************************************** 
C                                                                        
C*********************************************************************** 
C                  ERROR EXIT                                            
C*********************************************************************** 
C                                                                        
1100  WRITE(ITOUT,9990)                                                  
C                                                                        
      STOP                                                               
C                                                                        
C                                                                        
C                                                                        
C*********************************************************************** 
C                  F O R M A T S                                         
C*********************************************************************** 
C                                                                        
C----------------------------------------------------------------------- 
C               FORMATS (FOR TERMINAL)                                   
C----------------------------------------------------------------------- 
8000  FORMAT(///,19X,'**************',/,19X,'*   LARKIN   *',/,          
     &           19X,'*  REV. 3.1  *',/,19X,'**************',/)  
8005  FORMAT(/,' Give the <name> of your chemical model',
     &         ' (max. 10 characters).',/,
     &         ' described in your file CHEMIN.<name>',/,
     &         ' if no name is given the input file CHEMIN is used.',/)        
8010  FORMAT(/,' INVOKE LARKIN SUBSYSTEM:',/,                            
     &' / COMPILE / SIMULATE / NUM. OUT / PLOT / Q / ?')                 
8900  FORMAT(///,19X,'END OF LARKIN SESSION',///)                        
8100  FORMAT(/,' CPU-TIME:',F6.2,' SEC',/)                               
8910  FORMAT(//,' OVERALL CPU-TIME:',F6.2,' SEC',/)                      
C                                                                        
C----------------------------------------------------------------------- 
C               FORMATS FOR LARKIN IN BATCH                              
C----------------------------------------------------------------------- 
18900 FORMAT(///,' ',24('-'),/,' CPU-TIMES IN SECONDS FOR ',/,           
     &' ',24('-'),/,                                                     
     &' COMPILATION     :',F9.4,/,                                       
     &' SIMULATION      :',F9.4,/,                                       
     &' OUTPUT-HANDLING :',F9.4,/,                                       
     &' OVER-ALL        :',F9.4,///)                                     
C                                                                        
C----------------------------------------------------------------------- 
C               ERROR OUTPUT                                             
C----------------------------------------------------------------------- 
C                                                                        
9300  FORMAT(//,' *** ERROR RETURN FROM SUBSYSTEM ''COMPILE'' ***',/)    
9400  FORMAT(//,' *** ERROR RETURN FROM SUBSYSTEM ''SIMULATE'' ***',/)   
9500  FORMAT(//,' *** ERROR RETURN FROM SUBSYSTEM ''NUMERICAL',          
     &       ' OUTPUT'' ***',/)                                          
9600  FORMAT(//,' *** ERROR RETURN FROM SUBSYSTEM ''GRAPHIC',            
     &       ' OUTPUT'' ***',/)                                          
9699  FORMAT(/,' ** GRAPHIC CURRENTLY NOT AVAILABLE **',/)               
9990  FORMAT(//,' LARKIN ENDED DUE TO ERROR',/)                          
C                                                                        
C*********************************************************************** 
C            END DRIVER ROUTINE FOR LARKIN                               
C*********************************************************************** 
C                                                                        
      END                                                                
      SUBROUTINE ANSNUM (TAB,NTAB,NUM,NNUM,X,KFLAG,IHELP)                
C                                                                        
C---------------------------------------------------------------------   
C  ANSNUM COMPARES AN ANSWER OF THE USER WITH THE FEASIBLE ANSWERS       
C  AND SETS AN ASSOCIATED FLAG. OPTIONAL ADDITIONAL GIVEN NUMBERS ARE    
C  CHECKED AND CONVERTED FROM STRING IMAGE TO INTEGER (REAL) VALUES      
C---------------------------------------------------------------------   
C                                                                        
C                                                                        
C DATE OF LATEST CHANGE: APRIL 27, '82                                   
C                                                                        
C                                                                        
C*********************************************************************   
C                                                                    *   
C  INPUT PARAMETERS                                                  *   
C        TAB:      TABLE OF FEASIBLE ANSWERS                         *   
C        NTAB:     NUMBER OF FEASIBLE ANSWERS                        *   
C        NNUM:     NUMBER OF (POSSIBLY GIVEN) INTEGER NUMBERS        *   
C                  (OR NNUM=-1 IF ONE REAL NUMBER HAS TO BE ANALYSED)*   
C        IHELP:    INDICATOR FOR HELP INFORMATION                    *   
C                                                                    *   
C  OUTPUT PARAMETERS                                                 *   
C        NUM(1/2): POSSIBLY ANALYSED INTEGER NUMBERS                 *   
C        X:        ANALYSED REAL NUMBER                              *   
C                  (ONLY IF NNUM.EQ.-1 AND TABLE SEARCH UNSUCCESSFULL)   
C        KFLAG:    ERROR AND TABLE FLAG                              *   
C                  .LT.0: INVALID ANSWER                             *   
C                  .EQ.0: BLANK LINE                                 *   
C                  .GT.0: USER ANSWER FOUND IN TAB(2,KFLAG)            *   
C                                                                    *   
C*********************************************************************   
C                                                                        
      DOUBLE PRECISION X                                                 
CSP       REAL X                                                         
      CHARACTER*1 TAB(2,NTAB),KEY(80),MKEY,BLANK                         
      INTEGER NUM(2),IHELP                                               
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C                                                                        
      INTEGER I,K,L,M,M1,M2                                          
      INTEGER IFLAG                                                      
C                                                                        
      DATA BLANK/' '/                                                    
C                                                                        
      K=0                                                                
      NUM(1)=-1                                                          
      NUM(2)=-1                                                          
      DO 1 I=1,73                                                        
1     KEY(I)=BLANK                                                       
C                                                                        
2     READ(ITIN,9000) (KEY(L),L=1,73)                                    
      K=K+1                                                              
      IF(KEY(73).NE.BLANK) WRITE(ITOUT,8200) (KEY(L),L=63,72)            
      KEY(73)=BLANK                                                      
      DO 3 I=1,72                                                        
      M=I                                                                
      IF(KEY(M).NE.BLANK) GOTO 10                                        
3     CONTINUE                                                           
      GOTO 20                                                            
10    MKEY=KEY(M)                                                        
      DO 12 I=1,NTAB                                                     
      KFLAG=I                                                            
      IF(TAB(1,I).EQ.MKEY) GOTO 30                                       
      IF(TAB(2,I).EQ.MKEY) GOTO 30                                       
12    CONTINUE                                                           
      KFLAG=0                                                            
      IF(NNUM.NE.-1) GOTO 20                                             
      CALL RNUM (KEY,1,72,X,IFLAG)                                       
      IF(IFLAG.NE.0) KFLAG=-1                                            
      RETURN                                                             
C                                                                        
C  BLANK LINE OR WRONG ANSWER GIVEN                                      
C20    CALL HELP (IHELP)                                                 
20    WRITE(ITOUT,8000) (TAB(1,L),L=1,NTAB)                              
      IF(K.LT.5) GOTO 2                                                  
      WRITE(ITOUT,8100)                                                  
      RETURN                                                             
C                                                                        
30    IF(NNUM.EQ.0) RETURN                                               
C                                                                        
C  ANALYSE NUMBER(S)                                                     
40    M=M+1                                                              
      IF(M.GT.72) RETURN                                                 
      IF(KEY(M).NE.BLANK) GOTO 40                                        
41    M=M+1                                                              
      IF(M.GT.72) RETURN                                                 
      IF(KEY(M).EQ.BLANK) GOTO 41                                        
      M1=M                                                               
      M2=72                                                              
42    M=M+1                                                              
      IF(M.GT.72) GOTO 43                                                
      IF(KEY(M).NE.BLANK) GOTO 42                                        
      M2=M                                                               
43    CALL INUM (KEY,M1,M2,NUM(1),IFLAG)                                 
      IF(IFLAG.NE.0.OR.NNUM.EQ.1) RETURN                                 
      CALL INUM (KEY,M2,72,NUM(2),IFLAG)                                 
      RETURN                                                             
C                                                                        
9000  FORMAT(73A1)                                                       
8000  FORMAT(//,' ENTER NOW YOUR ANSWER: ',/,' / ',8(A1,' / '))          
8100  FORMAT(//' TOO MANY ATTEMPTS')                                     
8200  FORMAT(/,' LINE TRUNCATED AFTER : ...',10A1,/,                     
     &         ' ENTER CONTINUATION CARD')                               
C                                                                        
C  END ANSNUM                                                            
C                                                                        
      END  
      SUBROUTINE ANSMOD (FTYP,NFTYP,NOFF)
C
      CHARACTER*18  FTYP(6)
      CHARACTER*1   KEY(80),BLANK
      INTEGER       NFTYP(6), NOFF, L, I, K, M, N
C
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
C
      DATA BLANK/' '/                                                    
C                                                                        
      DO 1 I=1,73                                                        
1     KEY(I)=BLANK                                                       
C                                                                        
2     READ(ITIN,9000) (KEY(L),L=1,73)                                    
      K=K+1                                                              
      IF(KEY(73).NE.BLANK) WRITE(ITOUT,8200) (KEY(L),L=63,72)    
      KEY(73)=BLANK                                                      
      DO 3 I=1,72
         M=I
         IF(KEY(M) .NE. BLANK) GOTO 10
3     CONTINUE
      GOTO 900
10    DO 15 I=M,72
         N=I
         IF(KEY(I) .EQ. BLANK) GOTO 20
15    CONTINUE
20    IF(N-M.GT.10) N=M+10
      DO 200 I=1,NOFF
         FTYP(I)=FTYP(I)(:NFTYP(I)) // '.'
         NFTYP(I)=NFTYP(I)+1
         DO 100 J=M,N-1
            FTYP(I)=FTYP(I)(:NFTYP(I)) // KEY(J)
            NFTYP(I)=NFTYP(I)+1
100      CONTINUE
200   CONTINUE
C
900   WRITE(ITOUT,8300) (FTYP(L)(:NFTYP(L)),L=1,NOFF)  
C
      RETURN
C
C    
8200  FORMAT(/,' LINE TRUNCATED AFTER : ...',10A1,/,                     
     &         ' ENTER CONTINUATION CARD')  
8300  FORMAT(/,' Chemical input will be read from ',A,/,
     &         ' Thermodynamic data may be read from ',A,/,
     &         ' possible output files are ',A,/,
     &         '                           ',A,/,          
     &         '                           ',A,/,          
     &         '                           ',A,/)          
9000  FORMAT(73A1)                                                       
C
C
C  END ANSMOD            
C
      END                                                                
      SUBROUTINE MONIT                                                   
      CHARACTER*6 NAME(20),NAME0                                         
      CHARACTER*20 TEXT                                                  
      CHARACTER*(*) TEXTH                                                
      CHARACTER*8 EXAMPL                                                 
      REAL SEC(20),ASEC(20),PC1(20),PC2(20),SUM,PC10,SUM0,PC20           
      INTEGER COUNT(20),MONI,INFO,IGRAPH,I,I0,NOEQ,N,NULL                
C                                                                        
      SAVE SEC,COUNT,ASEC,PC1,PC2,INDEXO,TIME1,TIME0,MAXIND,NAME         
      SAVE SEC0,NAME0,TEXT,N                                             
C                                                                        
C                                                                        
      DATA MONI/20/ , INFO/1/ , IGRAPH/1/, NULL/0/, EXAMPL/'        '/   
C                                                                        
      RETURN                                                             
C                                                                        
C                                                                        
      ENTRY MONINI (NUMBER,TEXTH,NOEQ)                                   
      IF(NUMBER.GT.20) GOTO 1090                                         
      N=NOEQ                                                             
C                                                                        
      IF(NUMBER.EQ.6) THEN                                               
           NAME0='METAS1'                                                
           NAME(1)='FCNINT'                                              
           NAME(2)='JACOB1'                                              
           NAME(3)='MA30LA'                                              
           NAME(4)='MA30LD'                                              
           NAME(5)='MA30LB'                                              
           NAME(6)='MA30LC'                                              
      ENDIF                                                              
C                                                                        
      IF(NUMBER.EQ.2) THEN                                               
        NAME0='CHECOM'                                                   
        NAME(1)='HASH'                                                   
        NAME(2)='JSTRCT'                                                 
      ENDIF                                                              
C                                                                        
      MAXIND=NUMBER                                                      
      TEXT=TEXTH                                                         
      DO 100 I=1,MAXIND                                                  
      SEC(I)=0.                                                          
      ASEC(I)=0.                                                         
      COUNT(I)=0                                                         
100   CONTINUE                                                           
C                                                                        
      SEC0=0.                                                            
      CALL SECOND (TIME1)                                                
C                                                                        
C      IF(IGRAPH.GT.0) CALL GMINI(MAXIND,NAME0,NAME)                     
C                                                                        
      RETURN                                                             
C                                                                        
C                                                                        
      ENTRY MONON (INDEX)                                                
      IF(INDEX.GT.MAXIND.OR.INDEX.LE.0) GOTO 1010                        
      CALL SECOND(TIME0)                                                 
      INDEXO=INDEX                                                       
      SEC0=SEC0+TIME0-TIME1                                              
      IF(INFO.GT.1) WRITE(MONI,*) ' ENTER',NAME(INDEX),TIME0             
C                                                                        
C      IF(IGRAPH.GT.0) CALL GMON(INDEX,SEC0)                             
C                                                                        
      RETURN                                                             
C                                                                        
C                                                                        
      ENTRY MONOFF (INDEX)                                               
      IF(INDEX.NE.INDEXO) GOTO 1020                                      
      CALL SECOND(TIME1)                                                 
      SEC(INDEX)=SEC(INDEX)+TIME1-TIME0                                  
      COUNT(INDEX)=COUNT(INDEX)+1                                        
      IF(INFO.GT.1) WRITE(MONI,*) ' EXIT ',NAME(INDEX),TIME1             
C                                                                        
C      IF(IGRAPH.GT.0) CALL GMOFF(INDEX,SEC(INDEX))                      
C                                                                        
      RETURN                                                             
C                                                                        
C                                                                        
      ENTRY MONEND                                                       
      CALL SECOND (TIME0)                                                
      SEC0=SEC0+TIME0-TIME1                                              
C                                                                        
      SUM=1.E-10                                                         
      DO 200 I=1,MAXIND                                                  
      SUM=SUM+SEC(I)                                                     
      IF(COUNT(I).LE.0) GOTO 200                                         
      ASEC(I)=SEC(I)/FLOAT(COUNT(I))                                     
200   CONTINUE                                                           
      SUM0=SUM+SEC0                                                      
C                                                                        
      DO 250 I=1,MAXIND                                                  
      PC1(I)=100.*SEC(I)/SUM0                                            
      PC2(I)=100.*SEC(I)/SUM                                             
250   CONTINUE                                                           
      PC10=100.*SEC0/SUM0                                                
      PC20=100.*SEC0/SUM                                                 
C                                                                        
C*      WRITE(MONI,9500)                                                 
C*      WRITE(MONI,9510)                                                 
C*      WRITE(MONI,9505)                                                 
C*9500  FORMAT(///)                                                      
C*9510  FORMAT(1X,66('#'))                                               
C*9505  FORMAT(' #',64X,'#')                                             
C*      WRITE(MONI,9505)                                                 
C*      WRITE(MONI,9512) TEXT                                            
C*9512  FORMAT(' #   RESULTS FROM TIME MONITOR PROGRAM  ',A20,6X,'#')    
C*      WRITE(MONI,9505)                                                 
C*      WRITE(MONI,9514) SUM0,SUM                                        
C*9514  FORMAT(' #   TOTAL TIME:',F11.3,5X,'SUM OF PARTS:',F11.3,10X,'#' 
C*      WRITE(MONI,9505)                                                 
C*      WRITE(MONI,9520)                                                 
C*9520  FORMAT(' #   ',2X,'NAME',3X,'CALLS',7X,'TIME',4X,'AV-TIME',      
C*     1       4X,'% TOTAL',6X,'% SUM   #')                              
C                                                                        
      IF(N.EQ.1) THEN                                                    
         EXAMPL='LAMBDA  '                                               
      ELSE IF(N.EQ.7) THEN                                               
         EXAMPL='H2O2HOPP'                                               
      ELSE IF(N.EQ.25) THEN                                              
         EXAMPL='HEXBAS  '                                               
      ELSE IF(N.EQ.50) THEN                                              
         EXAMPL='HAVC4   '                                               
      ELSE IF(N.EQ.59) THEN                                              
         EXAMPL='HEXAN1  '                                               
      ELSE IF(N.EQ.65) THEN                                              
         EXAMPL='GLYCO1  '                                               
      ELSE IF(N.EQ.138) THEN                                             
         EXAMPL='SOOT    '                                               
      ELSE IF(N.EQ.156) THEN                                             
         EXAMPL='POLY1   '                                               
      ELSE IF(N.EQ.179) THEN                                             
         EXAMPL='NHEX31  '                                               
      ELSE IF(N.EQ.352) THEN                                             
         EXAMPL='RNA1    '                                               
      ENDIF                                                              
      WRITE(MONI,9500) TEXT,EXAMPL                                       
9500  FORMAT(' ; ========  ',A20,' FUER ',A8,'  ==========',/,           
     & ' ;   EQ   NO   CALLS       TIME    AV-TIME    % TOTAL',          
     & '      % SUM')                                                    
      WRITE(MONI,9530)                                                   
9530  FORMAT(' &DATA')                                                   
      I0=1                                                               
      WRITE(MONI,9550) N,NULL,I0,SEC0,SEC0,PC10,PC20                     
9550  FORMAT('  ',2(I5),I8,F11.3,F11.4,F11.2,F11.2)                      
C                                                                        
      DO 300 I=1,MAXIND                                                  
      WRITE(MONI,9550) N,I,COUNT(I),SEC(I),ASEC(I),PC1(I),PC2(I)         
300   CONTINUE                                                           
C                                                                        
C  FOR SIMULA                                                            
C                                                                        
      IF(MAXIND.EQ.6) THEN                                               
      NAME(20)='LU-DEC'                                                  
      COUNT(20)=COUNT(3)+COUNT(4)+COUNT(5)                               
      SEC(20)=SEC(3)+SEC(4)+SEC(5)                                       
      IF(COUNT(20).LE.0) GOTO 400                                        
      ASEC(20)=SEC(20)/FLOAT(COUNT(20))                                  
400   CONTINUE                                                           
      PC1(20)=PC1(3)+PC1(4)+PC1(5)                                       
      PC2(20)=PC2(3)+PC2(4)+PC2(5)                                       
      I=20                                                               
      WRITE(MONI,9550) N,I,COUNT(I),SEC(I),ASEC(I),PC1(I),PC2(I)         
      COUNT(I)=COUNT(I)+COUNT(6)                                         
      SEC(I)=SEC(I)+SEC(6)                                               
      ASEC(I)=ASEC(I)+ASEC(6)                                            
      PC1(I)=PC1(I)+PC1(6)                                               
      PC2(I)=PC2(I)+PC2(6)                                               
      WRITE(MONI,9550) N,I+1,COUNT(I),SEC(I),ASEC(I),PC1(I),PC2(I)       
      ENDIF                                                              
C                                                                        
C                                                                        
C*      WRITE(MONI,9505)                                                 
C*      WRITE(MONI,9510)                                                 
C*      WRITE(MONI,9500)                                                 
C                                                                        
C                                                                        
C      IF(IGRAPH.GT.0) CALL GMEND                                        
C                                                                        
      RETURN                                                             
C                                                                        
C  ERROR EXITS                                                           
C                                                                        
1010  CONTINUE                                                           
      WRITE(MONI,9010) INDEX                                             
9010  FORMAT(/,' ERROR IN SUBROUTINE MONON',/,'   INDEX OUT OF RANGE',/, 
     1         '   INDEX=',I4)                                           
      GOTO 1111                                                          
C                                                                        
1020  CONTINUE                                                           
      WRITE(MONI,9020) INDEX                                             
9020  FORMAT(/,' ERROR IN SUBROUTINE MONOFF',/,'   INDEX OUT OF RANGE',/ 
     1         '   INDEX=',I4)                                           
      GOTO 1111                                                          
C                                                                        
1090  CONTINUE                                                           
      WRITE(MONI,9090) NUMBER                                            
9090  FORMAT(/,' ERROR IN SUBROUTINE MONINI',/,'   MAXIND GT 20 ',/,     
     1         '   MAXIND=',I4)                                          
      GOTO 1111                                                          
C                                                                        
1111  STOP                                                               
C                                                                        
C  END SUBROUTINE MONITOR                                                
C                                                                        
      END                                                                
      SUBROUTINE INUM (IN,L1,L2,INTVAL,KFLAG)                            
C                                                                        
C---------------------------------------------------------------------   
C SUBROUTINE INUM CREATES AN INTEGER VALUE FROM A GIVEN STRING OF DIGITS 
C---------------------------------------------------------------------   
C                                                                        
C DATE OF LATEST CHANGE: APRIL 1, '83                                    
C                                                                        
C*********************************************************************   
C                                                                    *   
C  INPUT PARAMETERS:                                                 *   
C    IN:       INTEGER ARRAY, CONTAINS THE STRING TO BE ANALYSED     *   
C                                                                    *   
C    L1/L2:    POINTER TO THE FIRST/LAST ELEMENT OF ARRAY IN, WHICH  *   
C              HAS TO BE ANALYSED                                    *   
C                                                                    *   
C                                                                    *   
C  OUTPUT PARAMETERS:                                                *   
C    INTVAL:   COMPUTED INTEGER VALUE                                *   
C                                                                    *   
C    KFLAG:    .EQ. 0: SUCCESSFULL ANALYSE                           *   
C                   1: BLANK LINE FOUND (NUM:=0)                     *   
C                  -1: ANALYSE FAILED                                *   
C                                                                    *   
C*********************************************************************   
C                                                                        
      CHARACTER*1 IN(80),Z(10),BLANK,PLUS,MINUS,CHAR                     
      LOGICAL BMINUS                                                     
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT 
      SAVE /LUNIT/
C                                                                        
      INTEGER L,K                                                      
C                                                                        
      DATA Z(1)/'0'/ ,Z(2)/'1'/ , Z(3)/'2'/, Z(4)/'3'/ , Z(5)/'4'/ ,     
     &     Z(6)/'5'/ ,Z(7)/'6'/ , Z(8)/'7'/, Z(9)/'8'/ , Z(10)/'9'/ ,    
     &     BLANK/' '/ , PLUS/'+'/ , MINUS/'-'/                           
C                                                                        
      BMINUS=.FALSE.                                                     
      KFLAG=1                                                            
      INTVAL=0                                                           
      DO 10 L=L1,L2                                                      
      CHAR=IN(L)                                                         
      IF(KFLAG.EQ.0) GOTO 1                                              
      IF(CHAR.EQ.BLANK) GOTO 10                                          
      IF(CHAR.EQ.PLUS) GOTO 10                                           
      IF(CHAR.NE.MINUS) GOTO 1                                           
      BMINUS=.TRUE.                                                      
      GOTO 10                                                            
1     DO 4 K=1,10                                                        
      IF(CHAR.NE.Z(K)) GOTO 4                                            
      INTVAL=INTVAL*10 + K-1                                             
      KFLAG=0                                                            
      GOTO 10                                                            
4     CONTINUE                                                           
      IF(BMINUS) INTVAL=-INTVAL                                          
      IF(CHAR.EQ.BLANK) RETURN                                           
      GOTO 100                                                           
10    CONTINUE                                                           
      IF(BMINUS) INTVAL=-INTVAL                                          
      RETURN                                                             
C                                                                        
C  ERROR HANDLING                                                        
100   WRITE(ITOUT,9100) (IN(L),L=L1,L2)                                  
      KFLAG=-1                                                           
      RETURN                                                             
C                                                                        
9100  FORMAT(/,' *** ERROR ***',/,' INVALID INTEGER DETECTED:',/,        
     &       1X,72A1,//)                                                 
C                                                                        
C  END INUM                                                              
C                                                                        
      END                                                                
      SUBROUTINE RNUM (IN,L1,L2,X,KFLAG)                                 
C                                                                        
C---------------------------------------------------------------------   
C  SUBROUTINE RNUM CREATES A REAL VALUE FROM A GIVEN STRING OF DIGITS    
C---------------------------------------------------------------------   
C                                                                        
C DATE OF LATEST CHANGE: APRIL 27, '82                                   
C                                                                        
C*********************************************************************   
C                                                                    *   
C  INPUT PARAMETERS:                                                 *   
C  IN :  INTEGER ARRAY, CONTAINS THE STRING TO BE ANALYSED           *   
C                                                                    *   
C  L1/L2:  POINTER TO THE FIRST/LAST ELEMENT OF ARRAY IN, WHICH      *   
C          HAS TO BE ANALYSED                                        *   
C                                                                    *   
C                                                                    *   
C  OUTPUT PARAMETERS:                                                *   
C    X   :  COMPUTED REAL VALUE                                      *   
C                                                                    *   
C    KFLAG:  .EQ. 0: SUCCESSFULL ANALYSE                             *   
C                 1: BLANK LINE FOUND (X:=0.)                        *   
C                -1: ANALYSE FAILED                                  *   
C                                                                    *   
C*********************************************************************   
C                                                                        
      DOUBLE PRECISION X,TEN,ZERO,XBASE,DBLE                             
CSP       REAL X,TEN,ZERO,XBASE,FLOAT                                    
      CHARACTER*1 IN(80),Z(10),BLANK,PLUS,MINUS,POINT,CHAR               
      CHARACTER*1 DD,EE                                                  
      LOGICAL BMINUS,BPOINT,BEXP,BSIGN,BBASE                             
C                                                                        
      INTEGER          ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT  
      COMMON / LUNIT / ITIN,ITOUT,MOUT,EOUT,CIN,HDS,POUT,SIN,DOUT,THDAT 
      SAVE /LUNIT/
C                                                                        
      INTEGER I,II,L,K                                                
      INTEGER IH,IZ,IFLAG,IEXP                                           
C                                                                        
      DATA Z(1)/'0'/ ,Z(2)/'1'/ , Z(3)/'2'/, Z(4)/'3'/ , Z(5)/'4'/ ,     
     &     Z(6)/'5'/ ,Z(7)/'6'/ , Z(8)/'7'/, Z(9)/'8'/ , Z(10)/'9'/      
      DATA BLANK/' '/ , PLUS/'+'/ , MINUS/'-'/ , POINT/'.'/              
      DATA DD/'D'/ , EE/'E'/                                             
      DATA ZERO/0.D0/ , TEN /1.D1/                                       
CSP       DATA ZERO/0./ , TEN /1.E1/                                     
C                                                                        
      BMINUS=.FALSE.                                                     
      BPOINT=.FALSE.                                                     
      BEXP=.FALSE.                                                       
      BSIGN=.FALSE.                                                      
      BBASE=.FALSE.                                                      
      IFLAG=0                                                            
      IH=0                                                               
      IZ=0                                                               
      XBASE=ZERO                                                         
      IEXP=0                                                             
      X=ZERO                                                             
      DO 100 L=L1,L2                                                     
      CHAR=IN(L)                                                         
      IF(CHAR.EQ.BLANK) GOTO 100                                         
      GOTO (1,5,7) , IFLAG                                               
      IF(CHAR.EQ.POINT) GOTO 10                                          
      IF(CHAR.EQ.PLUS) GOTO 100                                          
      IF(CHAR.EQ.MINUS) GOTO 40                                          
1     IF(CHAR.EQ.DD.OR.CHAR.EQ.EE) GOTO 20                               
      DO 2 K=1,10                                                        
      IF(CHAR.NE.Z(K)) GOTO 2                                            
      XBASE=XBASE*TEN + DBLE(K-1)                                        
CSP       XBASE=XBASE*TEN + FLOAT(K-1)                                   
      IF(BPOINT) IEXP=IEXP-1                                             
      BBASE=.TRUE.                                                       
      GOTO 100                                                           
2     CONTINUE                                                           
      GOTO 200                                                           
5     IF(CHAR.EQ.MINUS) GOTO 30                                          
      IF(CHAR.EQ.PLUS) GOTO 32                                           
7     DO 9 K=1,10                                                        
      IF(CHAR.NE.Z(K)) GOTO 9                                            
      IH=IH*10 + K-1                                                     
      IZ=IZ+1                                                            
      IF(IZ.LT.3) GOTO 100                                               
      GOTO 300                                                           
9     CONTINUE                                                           
      GOTO 200                                                           
10    BPOINT=.TRUE.                                                      
      IFLAG=1                                                            
      GOTO 100                                                           
20    BEXP=.TRUE.                                                        
      IFLAG=2                                                            
      GOTO 100                                                           
30    BSIGN=.TRUE.                                                       
32    IFLAG=3                                                            
      GOTO 100                                                           
40    BMINUS=.TRUE.                                                      
100   CONTINUE                                                           
      IF(.NOT.BBASE) GOTO 150                                            
      IF(BEXP.AND.IZ.EQ.0) GOTO 400                                      
      IF(BSIGN) IH=-IH                                                   
      X=XBASE*TEN**(IEXP+IH)                                             
      IF(BMINUS) X=-X                                                    
      KFLAG=0                                                            
      RETURN                                                             
C                                                                        
150   IF(IFLAG.NE.0) GOTO 500                                            
C  BLANK LINE FOUND                                                      
98    KFLAG=1                                                            
      RETURN                                                             
C                                                                        
C  ERROR HANDLING                                                        
200   WRITE(ITOUT,9200) (IN(L),L=L1,L2)                                  
      GOTO 600                                                           
300   WRITE(ITOUT,9300) (IN(L),L=L1,L2)                                  
      GOTO 600                                                           
400   WRITE(ITOUT,9400) (IN(L),L=L1,L2)                                  
      GOTO 600                                                           
500   WRITE(ITOUT,9500) (IN(L),L=L1,L2)                                  
600   KFLAG=-1                                                           
      RETURN                                                             
C                                                                        
9200  FORMAT(/' *** ERROR ***',/,' NON-ARITHMETIC DIGIT FOUND:',/,       
     &  1X,72A1,//)                                                      
9300  FORMAT(/' *** ERROR ***',/,' TOO MANY DIGITS FOR POWER:',/,        
     &  1X,72A1,//)                                                      
9400  FORMAT(/' *** ERROR ***',/,' MISSING DIGITS FOR POWER:',/,         
     &  1X,72A1,//)                                                      
9500  FORMAT(/' *** ERROR ***',/,' MISSING MANTISSA:',/,1X,72A1,//)      
C                                                                        
C  END RNUM                                                              
C                                                                        
      END                                                                
      SUBROUTINE NLDIM (NF,NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM,KFOUND)   
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLDIM SEARCHES FOR STRING &DIM IN FILE 'NF' FROM          
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF                                    
C        NSP, MODEL, NCEQ, IEL, NTB, NLR, IU, AND ITPM ARE READ. ELSE   
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      INTEGER NF,NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM,KFOUND              
      CHARACTER*5 STRING,CHAR                                           
      CHARACTER*4 END                                                   
C                                                                       
      DATA STRING/'&DIM '/, END/'&END'/                                 
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100,ERR=20) NSP,MODEL,NCEQ,IEL,NTB,NLR,IU,ITPM           
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A5)                                                     
9100  FORMAT(5X,I6,8X,I1,7X,I6,6X,I6,/,5X,I1,6X,I6,5X,I1,7X,I3)         
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLRATE (NF,T,RK,NCEQ,KFOUND)                           
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLRATE SEARCHES FOR STRING &RATE IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T AND RK ARE READ. ELSE            
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,RK(NCEQ)                                                   
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&RATE '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T                                                   
      READ(NF,9200,ERR=20) (RK(L),L=1,NCEQ)                             
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12)                                                 
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLDHRE (NF,T,DHR,NCEQ,KFOUND)                          
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLDHRE SEARCHES FOR STRING &DHRE IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T AND DHR ARE READ. ELSE           
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,DHR(NCEQ)                                                  
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&DHRE '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T                                                   
      READ(NF,9200,ERR=20) (DHR(L),L=1,NCEQ)                            
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12)                                                 
9200  FORMAT(5(1X,D13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLFCN1 (NF,LR,NLR,KFOUND)                              
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLFCN1 SEARCHES FOR STRING &FCN1 IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF LR ARE READ. ELSE                  
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
CI4       INTEGER LR(NLR)                                               
      INTEGER*2 LR(NLR)                                                 
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&FCN1 '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (LR(L),L=1,NLR)                              
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
9200  FORMAT(12(I5,1X))                                                 
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLFCN2 (NF,PLR,NCEQ2,KFOUND)                           
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLFCN2 SEARCHES FOR STRING &FCN2 IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF PLR ARE READ. ELSE                 
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
CI4       INTEGER PLR(NCEQ2)                                            
      INTEGER*2 PLR(NCEQ2)                                              
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&FCN2 '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (PLR(L),L=1,NCEQ2)                           
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
9200  FORMAT(12(I5,1X))                                                 
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLTOUT (NF,TP,NTP,KFOUND)                              
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLTOUT SEARCHES FOR STRING &TOUT IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF TP ARE READ. ELSE                  
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
CDP       DOUBLE PRECISION TP(NTP)                                      
      REAL TP(NTP)                                                      
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&TOUT '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (TP(L),L=1,NTP)                              
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
CDP 9200  FORMAT(3(1X,D21.12,1X))                                       
9200  FORMAT(3(1X,E21.12,1X))                                           
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLEATW (NF,RK,IEL,KFOUND)                              
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLEATW SEARCHES FOR STRING &EATW IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF RK ARE READ. ELSE                  
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL RK(IEL)                                                      
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&EATW '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (RK(L),L=1,IEL)                              
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLSATW (NF,RK,NSP,KFOUND)                              
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLSATW SEARCHES FOR STRING &SATW IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF RK ARE READ. ELSE                  
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL RK(NSP)                                                      
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&SATW '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (RK(L),L=1,NSP)                              
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLCONC (NF,T,CONC,NSP,KFOUND)                          
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLCONC SEARCHES FOR STRING &CONC IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T AND CONC ARE READ. ELSE          
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,CONC(NSP)                                                  
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&CONC '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T                                                   
      READ(NF,9200) (CONC(L),L=1,NSP)                                   
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12)                                                 
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLKIPA (NF,T,RK,NCEQ,KFOUND)                           
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLKIPA SEARCHES FOR STRING &KIPA IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T AND RK ARE READ. ELSE            
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,RK(NCEQ)                                                   
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&KIPA '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T                                                   
      READ(NF,9200) (RK(L),L=1,NCEQ)                                    
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12)                                                 
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLSUMC (NF,T,SUM,KFOUND)                               
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLSUMC SEARCHES FOR STRING &SUMC IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T AND SUM ARE READ. ELSE           
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,SUM                                                        
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
C                                                                       
      DATA STRING/'&SUMC '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T,SUM                                               
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12,6X,E13.6)                                        
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLRECO (NF,T,TEMP,DENSY,PRESS,VOLUME,KFOUND)           
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLRECO SEARCHES FOR STRING &RECO IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF T, TEMP, DENSY, PRESS, AND         
C                                    VOLUME ARE READ. ELSE              
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL T,TEMP,DENSY,PRESS,VOLUME                                    
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
C                                                                       
      DATA STRING/'&RECO '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100) T,TEMP,DENSY,PRESS,VOLUME                           
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X,E21.12,/,7X,E14.7,9X,E14.7,/,8X,E14.7,10X,E14.7)        
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLTBO1 (NF,LR,NLR,NCTB,KFOUND)                         
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLTBO1 SEARCHES FOR STRING &TBO1 IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF LR ARE READ. ELSE                  
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
CI4       INTEGER LR(NLR)                                               
      INTEGER*2 LR(NLR)                                                 
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER I1, I2, I3, I4, I5, J1, J2, J3, J4, J5, L                 
C                                                                       
      DATA STRING/'&TBO1 '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100,ERR=20) LR(1),LR(2),LR(3),LR(4),LR(5)                
      I1=6                                                              
      I2=6+LR(1)                                                        
      I3=6+LR(1)+LR(2)                                                  
      I4=6+LR(1)+LR(2)+LR(3)                                            
      I5=6+LR(1)+LR(2)+LR(3)+LR(4)                                      
      J1=I1+LR(1)                                                       
      J2=I2+LR(2)                                                       
      J3=I3+LR(3)                                                       
      J4=I4+LR(4)                                                       
      J5=I5+LR(5)                                                       
      READ(NF,9200,ERR=20) (LR(L),L=I1,J1),(LR(L),L=I2,J2),             
     &                     (LR(L),L=I3,J3),(LR(L),L=I4,J4),             
     &                     (LR(L),L=I5,J5)                              
      NCTB=LR(1)+LR(2)+LR(3)+LR(4)+LR(5)                                
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(4X,5(I5,1X))                                               
9200  FORMAT(12(I5,1X))                                                 
9900  FORMAT(1X,A4)                                                     
      END                                                               
      SUBROUTINE NLTBO2 (NF,C,NCTB,KFOUND)                              
C                                                                       
C*********************************************************************  
C                                                                       
C  SUBROUTINE NLTBO2 SEARCHES FOR STRING &TBO2 IN FILE 'NF' FROM        
C  ACTUAL POSITION TO END OF FILE. IF STRING WAS FOUND,                 
C  KFOUND IS SET TO +1 AND VALUES OF C ARE READ. ELSE                   
C  KFOUND IS SET TO -1.                                                 
C                                                                       
C*********************************************************************  
C                                                                       
      REAL C(NCTB)                                                      
      CHARACTER*6 STRING,CHAR                                           
      CHARACTER*4 END                                                   
      INTEGER L                                                         
C                                                                       
      DATA STRING/'&TBO2 '/, END/'&END'/                                
C                                                                       
10    CONTINUE                                                          
      READ(NF,9000,END=20) CHAR                                         
      IF(CHAR.NE.STRING) GOTO 10                                        
C                                                                       
C  STRING WAS FOUND, READ NOW DATA                                      
      READ(NF,9100)                                                     
      READ(NF,9200,ERR=20) (C(L),L=1,NCTB)                              
      READ(NF,9900,END=20) CHAR                                         
      IF(CHAR.NE.END) GOTO 20                                           
      KFOUND=1                                                          
      RETURN                                                            
C  STRING NOT FOUND                                                     
20    CONTINUE                                                          
      KFOUND=-1                                                         
      RETURN                                                            
9000  FORMAT(1X,A6)                                                     
9100  FORMAT(3X)                                                        
9200  FORMAT(5(1X,E13.6,1X))                                            
9900  FORMAT(1X,A4)                                                     
      END                                                               
