 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

/* 
 *  UT_find_min_pos_2 ()   A search routine which searches through the 
 *                         upper triangular part of a matrix for the minimum 
 *                         value.  The minimum value, along with the row
 *                         and column for that value, are returned.  The
 *                         only rows/columns which are searched are those
 *                         for which a negative diagonal element exists.
 *
 *                         An unsuccessful search will return a position
 *                         of (-1,-1).  
 *
 *
 *  Written by:  Patrick M. Kelly
 *  Date:        8/6/91
 */

void UT_find_min_pos_2 ( A, dim, min, row, col, START_MIN )

float **A;		/* The SM matrix */
int dim;			/* Size of the SM matrix */
float *min;		/* The minimum value in the SM matrix */
int *row;			/* Row where it was found */
int *col;			/* Column where it was found */
float START_MIN;	/* Starting value to initialize the min. */

{
	int r, c;		/*  Loop control */

	/*
	 *  INITIALIZE THE SEARCH.  FIND A VALID STARTING VALUE.
	 */
	*row = -1;
	*col = -1;
	*min = START_MIN;

	/*
	 *  SEARCH 
	 */

	for ( r = 0 ; r < dim ; r ++ ) {

		if ( A [r][r] < 0.0 ) {
		for ( c = r+1 ; c < dim ; c ++ ) {

			if ( (A [c][c] < 0.0) && (A [r][c] > 0.0) ) {
			if ( A [r][c] < *min ) {
				*min = A [r][c];
				*row = r;
				*col = c;
			}
			}

		}
		}

	}

	return;
}
