 /*
  * Khoros: $Id: form_info.c,v 1.1 1991/05/10 15:58:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.1 1991/05/10 15:58:54 khoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.1  1991/05/10  15:58:54  khoros
 * Initial revision
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Wed Nov  7 15:29:50 1990
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_UI_view
*
*       Purpose: Fills in the user-specified
*                'UI_view'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'UI_view'
*
*       Output:  current values stored in  UI_view
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_UI_view(formptr, forminfo)

xvf_form *formptr;
UI_view *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'UI_view' Form Information structure *****/


	index = 1;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->show_selected = line_info.selected;
	_xvf_get_show(formptr, forminfo->show);

}

/********************************************************
*
*  Routine Name: xvf_get_show
*
*       Purpose: Fills in the user-specified
*                'UI_view_show'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'UI_view_show'
*
*       Output:  current values stored in  'UI_view_show'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_show(formptr, subforminfo)

xvf_form *formptr;
UI_view_show *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 2;


	/*** extracting 'UI_view->show'
 	   Subform Information structure ***/


	index = 2;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->preview_selected = line_info.selected;
	_xvf_get_preview(formptr, subforminfo->preview);

}



/********************************************************
*
*  Routine Name: xvf_get_preview
*
*       Purpose: Fills in the user-specified
*                'show_preview'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'show_preview'
*
*       Output:  current values stored in  'show_preview'
*
*    Called By:  xvf_get_show
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_preview(formptr, paneinfo)

xvf_form *formptr;
show_preview *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 3;


	/* extracting 'UI_view->show->preview'
 	   Pane Information structure */

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->i = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->i = NULL;

	paneinfo->i_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->revisit = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->edit = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


