 /*
  * Khoros: $Id: composer.c,v 1.2 1991/10/02 00:18:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: composer.c,v 1.2 1991/10/02 00:18:56 khoros Exp $";
#endif

 /*
  * $Log: composer.c,v $
 * Revision 1.2  1991/10/02  00:18:56  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: composer.c
 >>>>
 >>>>      Program Name: composer
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program is for interactive editing  of  user  interface
 >>>>	specification (UIS) and program specifications (PS).
 >>>>	
 >>>>	

 >>>>            Author: John Rasure
 >>>>
 >>>> Date Last Updated: Sat Sep 28 12:45:38 1991
 >>>>
 >>>>          Routines: main- the main program for composer
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "composer.h"


/****************************************************************
 *
 * Routine Name:  main program for composer
 *
 *       Input:  
 *
 *
 *          [-pane] User Interface Specification (UIS)file
 *          [-prog] Program and code Specification (PS) file
 *          [-name] name of program to be edited or generated
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        char *ex_prog_name;
        FILE  *file;
        char  **keynames[2], **gw_read_progfile();

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();

        valid_prog_file = FALSE;        /* set that no files read yet */
        demo_form = NULL;               /* xvf_form structure for gui_spec */

        gui_spec = prog_spec = ex_prog_spec = NULL;

        valid_pane_file = FALSE;

        /* set the global name pointers to NULL */
        glob_pane_name = glob_prog_name = glob_routine_name = NULL;

        if (composer->pane_flag) {
            if ( !get_pane(composer->pane_file)) {
                (void) fprintf(stderr, 
                "%s: Pane specification (-pane) is incorrect\n", program);
            }
            else {
                valid_pane_file = TRUE;
                glob_pane_name = VStrcpy(composer->pane_file);
            }
        }

        if (composer->prog_flag) {
            if ( !get_prog(composer->prog_file)) {
                (void) fprintf(stderr, 
                "%s: Program specification (-prog) is incorrect\n", program);
            }
            else {
                valid_prog_file = TRUE;
                glob_prog_name = VStrcpy(composer->prog_file);
            }
        }

        if (composer->name_flag & composer->name_string != NULL) {
            glob_routine_name = VStrcpy(composer->name_string);
        }

/* -main_before_lib_call_end */

/* -main_library_call */
        /* read in example program specification */
        ex_prog_name = xvf_strcpy("KHOROS_HOME/repos/composer/example.prog");
        ex_prog_name = vfullpath(ex_prog_name, NULL, NULL);
        if (!(file = fopen(ex_prog_name, "r"))) {
           (void) fprintf(stderr,"Unable to open '%s' to read program specification file" , ex_prog_name);
           khoros_close();
        }
        gw_init_keynames(keynames);

        ex_prog_spec = gw_read_progfile(file, keynames);

        if (ex_prog_spec == NULL) {
           (void) fprintf(stderr,"%s: Example Program specification is incorrect\n", program);
           khoros_close();
        }
        fclose(file);

        /* initialize various global strings */
        init_lines();
        init_instructions();

        /* if the if's above were successful, then the global variables are
           passed into run_Composer:  gui_spec, prog_spec, and the various
           names (pane, prog and routine).
           */

        run_Composer(argc, argv, program);

/* -main_library_call_end */

/* -main_after_lib_call */

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for composer 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "composer :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program is for interactive editing  of  user  interface\n");
	fprintf(stderr, "\tspecification (UIS) and program specifications (PS).\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */

/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-pane]  User Interface Specification (UIS)file (infile) [null]\n");
	fprintf(stderr,"\t[-prog]  Program and code Specification (PS) file (infile) [null]\n");
	fprintf(stderr,"\t[-name]  name of program to be edited or generated (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for composer\n");
	fprintf(stderr, "\t[-V] Gives the version for composer\n");
	fprintf(stderr, "\t[-U] Gives the usage for composer\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called composer.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses composer.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for composer
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*pane_pstr = 
	"\nEnter: (pane) User Interface Specification (UIS)file \n        {infile}: "; 
char	*prog_pstr = 
	"\nEnter: (prog) Program and code Specification (PS) file \n        {infile}: "; 
char	*name_pstr = 
	"\nEnter: (name) name of program to be edited or generated \n        {string}: "; 
char	*name_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "composer", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "composer.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "composer: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "composer.ans");
		}

	     }

	}

	/*
	 * allocate the composer structure
	 */
	composer = (composer_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (composer_struct));

	/*
	 * get optional arguments for composer
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	composer->pane_flag = vget_infile(fid, prompt_flag,
	"-pane", pane_pstr, &(composer->pane_file))
;

	composer->prog_flag = vget_infile(fid, prompt_flag,
	"-prog", prog_pstr, &(composer->prog_file))
;

	composer->name_flag = vget_string(fid, prompt_flag,
	"-name", name_pstr, &(composer->name_string),
	name_def);

	if (prompt_flag == FALSE)
	{
	    if ((composer->name_flag == 1)&&(composer->name_string == NULL))
    	{
		fprintf(stderr, "composer:\n");
		fprintf(stderr, "you must specify a name following '-name'\n");
		gw_usage();
		exit(1);
		}
	}

}



