 /*
  * Khoros: $Id: variables.c,v 1.2 1991/12/18 09:03:37 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: variables.c,v 1.2 1991/12/18 09:03:37 dkhoros Exp $";
#endif

 /*
  * $Log: variables.c,v $
 * Revision 1.2  1991/12/18  09:03:37  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  variables.c                           <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_eval_variables()                  <<<<
   >>>>                 xvl_global_variables()                <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_eval_variables
*
*      Purpose:  process requests from the variables pane.
*
*        Input:  workspace - workspace that the request came from
*		 form      - the form in which the request came from
*		 subform   - the subform in which the request came from
*
*   Written By: Mark Young
*
*************************************************************/


xvl_eval_variables(workspace, form, subform)

Workspace    *workspace;
xvf_form     *form;
xvf_sub_form *subform;
{
	Line_Info	 lineinfo;
	xvf_guide_button *guide_ptr;
	xvf_selection	 *select_ptr;

	long		 id;
	float		 value;
	FILE		 *file;
	char		 temp[512], error[1024], *filename;


	guide_ptr = xvf_search_sel_guide(subform);
	if (guide_ptr == NULL)
	   return;

	if (guide_ptr->pane == NULL)
	   return;

	id = (long) workspace->glyphform;
	select_ptr = guide_ptr->pane->sel_list;
	while (select_ptr != NULL)
	{
	   xvl_parse_line(form->db, select_ptr->index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
	      if (strcmp(lineinfo.variable,"eval") == 0 &&
		  lineinfo.selected == True && lineinfo.literal != NULL)
	      {
		 if (xve_eval_float(id, lineinfo.literal, &value, error)==False)
		 {
		    xvf_error_wait(error, "xvl_eval_variables", NULL);
		 }
		 else
		 {
		    /*
	 	     *  Open the history expression file so that we can record
		     *  the expression commands to it.
		     */
		    if (workspace->var_name == NULL)
		    {
		       if ((workspace->var_name = xvl_tempnam("hist.expr", NULL,
					NULL)) != NULL)
		       {
			  if (!(workspace->var_file = fopen(workspace->var_name,
				 "w")))
			     workspace->var_file = stderr;
		       }
		       else workspace->var_file = stderr;
		    }
		    fprintf(workspace->var_file," %s\n", lineinfo.literal);
		    sprintf(temp, " %g  ", value);
		    xvf_change_input(form, select_ptr->index+2, xvf_title_chng,
				     temp, 0);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"list") == 0 &&
		       lineinfo.selected == True)
	      {
		 if ((filename = xvl_tempnam("listing.var", NULL,NULL)) != NULL)
		 {
		    if ((file = fopen(filename,"w")) != NULL)
		    {
		       if (xve_list_variables(id, file))
		       {
			  fclose(file);
			  sprintf(temp,"Listing of Variable Definitions");
			  xvl_help(filename, temp, True);
		       }
		       else
		       {
			  xvf_error_wait("Error!  Unable to create listing of \variables.", "xvl_eval_variables", NULL); 
			  fclose(file);
			  unlink(filename);
		       }
		    }
		    free(filename);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"hist") == 0 &&
		       lineinfo.selected == True)
	      {
		 if (workspace->var_name == NULL)
		 {
		    xvf_error_wait("Warning!  Expression history is currently \
empty.  Please enter at least one expression before trying to review this \
file.", "xvl_eval_variables", NULL);
		 }
		 else if (workspace->var_file == stderr)
		 {
		    xvf_error_wait("Warning!  Cantata was unable to create a \
temporary history file and has been logging all expressions to standard error.",
"xvl_eval_variables", NULL);
		 }
		 else
		 {
		    fflush(workspace->var_file);
		    sprintf(temp,"History of Variable Definitions");
		    xvl_help(workspace->var_name, temp, False);
		 }
	      }
	   }
	   select_ptr = select_ptr->next;
	}
}



/************************************************************
*
* Routine Name:  xvl_global_variables
*
*      Purpose:  Set the scope of the variables for the workspace.
*		 If global_variables is false then we call
*		 xve_unset_parent() to make evaluation of variables
*		 only local to this workspace.  Otherwise we call
*		 xve_set_parent() with the parent's variable id.
*
*        Input:  workspace - workspace that the request came from
*
*   Written By: Mark Young
*
*************************************************************/


xvl_global_variables(workspace)

Workspace *workspace;
{
	long      id, parent_id;
	Workspace *parent_workspace, *attributes;


	/*
	 *  If the workspace parent glyph is NULL then this is the toplevel
	 *  workspace, and therefore always has local variables.
	 */
	if (workspace->parent == NULL)
	   return;

	/*
	 *  If global variables is False then unset the parent and return,
	 *  otherwise get the parent's xvexpr id.
	 */
	id = (long) workspace->glyphform;
	attributes = xvl_get_attributes(workspace);

	if (attributes->global_variables == False)
	{
	   xve_unset_parent(id);
	   return;
	}

        /*
         *  Set the workspace's xvexpr id (the glyphform) to be the parent's
         *  xvexpr id.
         */
	parent_workspace = workspace->parent->workspace;
	if (parent_workspace == NULL)
	   return;

        parent_id = (long) parent_workspace->glyphform;
	xve_set_parent(id, parent_id);
}
