 /*
  * Khoros: $Id: find.c,v 1.2 1991/12/18 09:01:21 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: find.c,v 1.2 1991/12/18 09:01:21 dkhoros Exp $";
#endif

 /*
  * $Log: find.c,v $
 * Revision 1.2  1991/12/18  09:01:21  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name:  util.c					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>>      routines:  xvl_find_run_button()			<<<<
   >>>>                 xvl_find_stop_button()			<<<<
   >>>>                 xvl_find_undo_button()			<<<<
   >>>>                 xvl_find_glyph()			<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_find_run_button
*
*      Purpose:  This routine is used to find the run button
*		 on a pane.  If no run button (-R) specification
*		 exists then we return NULL otherwise we return
*		 the selection.
*
*        Input:  
*
*
*   Written By: Mark Young
*
*************************************************************/


int xvl_find_run_button(database, guide, exec_type)

char		 *database[];
xvf_guide_button *guide;
XtEnum		 *exec_type;
{
	Line_Info     lineinfo;
	xvf_selection *selection;


	/*
	 *  Make sure that we don't have an empty guide or guide pane
	 */
	if (guide == NULL)
	   return(False);

	if (guide->pane == NULL)
	   return(False);
	else
	   selection = guide->pane->sel_list;

	/*
	 *  Race thru the guide list looking for the first Routine
	 *  Selection.
	 */
	while (selection != NULL)
	{
	   if (xvf_get_line_type(database[selection->index]) == Routine)
	   {
	      xvf_clear_line_info(&lineinfo);
	      xvl_parse_line(database, selection->index, &lineinfo);

	      *exec_type = lineinfo.exec_type;
	      return(True);
	   }

	   selection = selection->next;
	}
	*exec_type = NORUN;
	return(False);
}



/************************************************************
*
* Routine Name:  xvl_find_stop_button
*
*      Purpose:  This routine is used to find the stop autorun button
*		 on the menu form.  If no stop button is found we
*		 return NULL otherwise we return the widget
*
*        Input:  
*
*
*   Written By: Stephanie Hallet & Mark Young
*
*************************************************************/


Widget xvl_find_stop_button(form)

xvf_form *form;
{
	Line_Info    lineinfo;
	xvf_sub_form *subform;


	xvf_clear_line_info(&lineinfo);
	subform = form->subform;

	while (subform != NULL)
	{
	   if ((subform->type == MasterAction) && (subform->index <= 0))
	   {
	      xvl_parse_line(form->db, subform->button_index, &lineinfo);

	      if (strcmp(lineinfo.variable,"stop_auto_run") == 0)
		 return(subform->button);
	   }
	   subform = subform->next_subform;
	}
	return(NULL);
}



/************************************************************
*
* Routine Name:  xvl_find_undo_button
*
*      Purpose:  This routine is used to find the undo button
*		 on a pane.  If no run button (-n) specification
*		 exists then we return NULL otherwise we return
*		 the subform.
*
*        Input:  
*
*
*   Written By: Mark Young
*
*************************************************************/


xvf_sub_form *xvl_find_undo_button(form)

xvf_form *form;
{
	Line_Info    lineinfo;
	xvf_sub_form *subform;


	xvf_clear_line_info(&lineinfo);
	subform = form->subform;

	while (subform != NULL)
	{
	   if ((subform->type == MasterAction) && (subform->index <= 0))
	   {
	      xvl_parse_line(form->db, subform->button_index, &lineinfo);

	      if (strcmp(lineinfo.variable,"undo") == 0)
		 return(subform);
	   }
	   subform = subform->next_subform;
	}
	return(NULL);
}



/************************************************************
*
* Routine Name:  xvl_find_glyph
*
*      Purpose:  This routine is used to find glyph with the name
*		 specified in the 'glyph_name' array.
*
*        Input:  glyphlist - the glyph list to search the glyph's from
*		 glyph_name - the name of the glyph to be found.
*
*
*   Written By: Mark Young
*
*************************************************************/


Glyph *xvl_find_glyph(glyphlist, glyph_name)

GlyphList   *glyphlist;
char	    *glyph_name;
{
	Glyph	   *glyph;
	Workspace  *macro;


	while (glyphlist != NULL)
	{
	   glyph = glyphlist->glyph;
	   if (strcmp(glyph_name, glyph->restore_name) == 0)
	      return(glyph);

	   if (glyph->type == PROCEDURE)
	   {
	      macro = glyph->val.macro;
	      if ((glyph = xvl_find_glyph(macro->glyphs, glyph_name)) != NULL)
		 return(glyph);
	   }
	   glyphlist = glyphlist->next;
	}
	return(NULL);
}
