 /*
  * Khoros: $Id: blink.c,v 1.1 1991/05/10 15:57:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: blink.c,v 1.1 1991/05/10 15:57:48 khoros Exp $";
#endif

 /*
  * $Log: blink.c,v $
 * Revision 1.1  1991/05/10  15:57:48  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  blink.c                               <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_blink_glyph()                     <<<<
   >>>>                 xvl_unblink_glyph()                   <<<<
   >>>>                 xvl_blink_cb()                        <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



static GlyphList *blinklist = NULL;


/************************************************************
*
* Routine Name: xvl_blink_glyph
*
*      Purpose: This routine is used to make a glyph start
*		blinking.
*
*       Output: None
*
*    CALLED BY:
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


xvl_blink_glyph(glyph)

Glyph	 *glyph;
{
	XtAppContext   app_context;


	if (blinklist == NULL)
	{
	   app_context = XtWidgetToApplicationContext(glyph->toplevel);
	   (void) XtAppAddTimeOut(app_context, BlinkRate, xvl_blink_cb, NULL);
	}
	blinklist = xvl_add_to_glyphlist(glyph, blinklist);
}



/************************************************************
*
* Routine Name: xvl_unblink_glyph
*
*      Purpose: This routine is used to make a glyph stop
*		blinking.
*
*       Output: None
*
*    CALLED BY:
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/


xvl_unblink_glyph(glyph)

Glyph	 *glyph;
{

	blinklist = xvl_delete_from_glyphlist(glyph, blinklist);
}



/************************************************************
*
* Routine Name:  xvl_blink_cb
*
*      Purpose:  This routine is used to make a glyph appear to blink.
*		 This is done by installing a timer callback routine
*		 and inverting the glyph's current color.
*
*        Input:  clientData   - Not used
*		 id	      - the timeout callback id
*
*
*   Written By: Mark Young
*
*************************************************************/


void xvl_blink_cb(clientData, id)

caddr_t	      clientData;
XtIntervalId  id;
{
	Glyph	       *glyph;
	GlyphList      *glyphlist;
	XtAppContext   app_context;


	glyphlist = blinklist;
	while (glyphlist != NULL)
	{
	   glyph = glyphlist->glyph;
	   xvf_reverse_colors(glyph->error);
	   glyphlist = glyphlist->next;
	}

	if (blinklist != NULL)
	{
	   glyph = blinklist->glyph;
	   app_context = XtWidgetToApplicationContext(glyph->toplevel);
	   (void) XtAppAddTimeOut(app_context, BlinkRate, xvl_blink_cb, NULL);
	}
}
