 /*
  * Khoros: $Id: deparser.c,v 1.2 1991/10/02 00:16:19 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: deparser.c,v 1.2 1991/10/02 00:16:19 khoros Exp $";
#endif

 /*
  * $Log: deparser.c,v $
 * Revision 1.2  1991/10/02  00:16:19  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"
#include "deparser.h"

#define MaxLength 512

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>                file name: deparser.c                  <<<<
   >>>>                                                       <<<<
   >>>>		       Deparsing  Routines                    <<<<
   >>>>                                                       <<<<
   >>>>	       Deparse lines into the User Interface          <<<<
   >>>>	       Specification Structure			      <<<<
   >>>>                                                       <<<<
   >>>>		xvf_deparse_startform_line()		      <<<<   
   >>>>		xvf_deparse_startmaster_line()		      <<<<   
   >>>>		xvf_deparse_startsubmenu_line()		      <<<<   
   >>>>		xvf_deparse_startsubform_line()		      <<<<   
   >>>>		xvf_deparse_subformbutton_line()	      <<<<   
   >>>>		xvf_deparse_psuedosubform_line()	      <<<<   
   >>>>		xvf_deparse_master_action_line()	      <<<<   
   >>>>		xvf_deparse_startguide_line()		      <<<<   
   >>>>		xvf_deparse_startpane_line()		      <<<<   
   >>>>		xvf_deparse_guide_line()		      <<<<   
   >>>>		xvf_deparse_quit_line()			      <<<<   
   >>>>		xvf_deparse_subform_action_line()	      <<<<   
   >>>>		xvf_deparse_help_line()		      	      <<<<   
   >>>>		xvf_deparse_input_line()		      <<<<   
   >>>>		xvf_deparse_output_line()		      <<<<   
   >>>>		xvf_deparse_int_line()		      	      <<<<   
   >>>>		xvf_deparse_float_line()		      <<<<   
   >>>>		xvf_deparse_logic_line()		      <<<<   
   >>>>		xvf_deparse_string_line()		      <<<<   
   >>>>		xvf_deparse_routine_line()	      	      <<<<   
   >>>>		xvf_deparse_toggle_line()		      <<<<   
   >>>>		xvf_deparse_blank_line()		      <<<<   
   >>>>		xvf_deparse_pane_action_line()		      <<<<   
   >>>>		xvf_deparse_includepane_line()		      <<<<   
   >>>>		xvf_deparse_includesubform_line()             <<<<   
   >>>>		xvf_deparse_mutexcl_line()		      <<<<   
   >>>>		xvf_deparse_workspace_line()		      <<<<   
   >>>>		xvf_deparse_ansinfile_line()		      <<<<   
   >>>>		xvf_deparse_ansoutfile_line()		      <<<<   
   >>>>		xvf_deparse_end_line()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */




/************************************************************
*
*      Routine: xvf_deparse_startform_line
*
*      Purpose: deparses a Start Form line  (-F:  typeflag = StartForm)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startform_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_variable[MaxLength];
	float  version = 4.2; 

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->variable == NULL) sprintf(tmp_variable, " ");
	else sprintf(tmp_variable, "%s", line_info->variable);

	(void) sprintf(line, startform_print,  version, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}





/************************************************************
*
*      Routine: xvf_deparse_startmaster_line
*
*      Purpose: deparses a StartMaster line  (-S:  typeflag = StartMaster)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startmaster_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength];

	(void) sprintf(line, startmaster_print, 
		       line_info->activate, line_info->logical_val);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_startsubmenu_line
*
*      Purpose: deparses a StartSubMenu line  (-D:  typeflag = StartSubMenu)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startsubmenu_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_variable[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->variable == NULL) sprintf(tmp_variable, " ");
	else sprintf(tmp_variable, "%s", line_info->variable);


	(void) sprintf(line, startsubmenu_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_startsubform_line
*
*      Purpose: deparses a StartSubForm line  (-M:  typeflag = StartSubForm)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startsubform_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_variable[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->variable == NULL) sprintf(tmp_variable, " ");
	else sprintf(tmp_variable, "%s", line_info->variable);

	(void) sprintf(line, startsubform_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_startguide_line
*
*      Purpose: deparses a Start Guide line  (-G:  typeflag = StartGuide)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startguide_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	(void) sprintf(line, startguide_print, line_info->activate,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_startpane_line
*
*      Purpose: deparses a Start Pane line  (-P:  typeflag = StartPane)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_startpane_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_variable[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->variable == NULL) sprintf(tmp_variable, " ");
	else sprintf(tmp_variable, "%s", line_info->variable);

	(void) sprintf(line, startpane_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_subformbutton_line
*
*      Purpose: deparses a SubFormButton line  (-d:  typeflag = SubFormButton)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_subformbutton_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	(void) sprintf(line, subformbutton_print, 
		       line_info->activate, line_info->selected, 
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       tmp_title);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_psuedosubform_line
*
*      Purpose: deparses a PsuedoSubForm line  (-u:  typeflag = PsuedoSubForm)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_psuedosubform_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	(void) sprintf(line, psuedosubform_print, 
		       line_info->activate, line_info->selected, 
		       line_info->width, line_info->height,
		       line_info->x,line_info->y, tmp_title);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_master_action_line
*
*      Purpose: deparses Master Action line (-n: typeflag = MasterAction)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_master_action_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{

	char line[MaxLength], 
	     tmp_title[MaxLength], tmp_desc[MaxLength], tmp_var[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL) sprintf(tmp_desc, " ");
        else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL) sprintf(tmp_var, " ");
        else sprintf(tmp_var, "%s", line_info->variable);

	(void) sprintf(line, master_action_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_desc, tmp_var);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_guide_line
*
*      Purpose: deparses a Guide line  (-g:  typeflag = GuideButton)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_guide_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_variable[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->variable == NULL) sprintf(tmp_variable, " ");
	else sprintf(tmp_variable, "%s", line_info->variable);

	(void) sprintf(line, guidebutton_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_variable);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}

 


/************************************************************
*
*      Routine: xvf_deparse_quit_line
*
*      Purpose: deparses a Quit line  (-Q:  typeflag = QuitForm)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_quit_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{

	char line[MaxLength], tmp_title[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

        (void) sprintf(line, quitform_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, tmp_title);
	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_subform_action_line
*
*      Purpose: deparses Subform Action line (-m: typeflag = SubformAction)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_subform_action_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{

	char line[MaxLength], 
	     tmp_title[MaxLength], tmp_desc[MaxLength], tmp_var[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL) sprintf(tmp_desc, " ");
        else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL) sprintf(tmp_var, " ");
        else sprintf(tmp_var, "%s", line_info->variable);

	(void) sprintf(line, subform_action_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_desc, tmp_var);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_help_line
*
*      Purpose: deparses a Help line (-H:  typeflag = HelpSel)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_help_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_file[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL) sprintf(tmp_desc, " ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->help_file == NULL) sprintf(tmp_file, " ");
	else sprintf(tmp_file, "%s", line_info->help_file);


        (void) sprintf(line, help_print, line_info->activate,
                       line_info->width, line_info->height, 
		       line_info->x,line_info->y,
		       tmp_title, tmp_desc, tmp_file);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*      Routine: xvf_deparse_input_line
*
*      Purpose: deparses an Input line (-I:  typeflag = InputFile)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_input_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength], tmp_def[MaxLength],
	     tmp_file[MaxLength], tmp_literal[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL) sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	if (line_info->file_def == NULL)  sprintf(tmp_def," ");
	else sprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  sprintf(tmp_file," ");
	else sprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == false)
        {
	(void) sprintf (line, input_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live, line_info->file_type,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	tmp_def, tmp_title, tmp_desc, 
                       	tmp_var, tmp_file, tmp_literal);
	 }
        else
        {
        (void) sprintf (line, input_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live, line_info->file_type,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        tmp_def, tmp_title, tmp_desc, tmp_var);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_output_line
*
*      Purpose: deparses an Output line (-O:  typeflag = OutputFile)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_output_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength], 
	     tmp_def[MaxLength], tmp_file[MaxLength],
	     tmp_literal[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	if (line_info->file_def == NULL)  sprintf(tmp_def," ");
	else sprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  sprintf(tmp_file," ");
	else sprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == false)
        {
	(void) sprintf	(line, output_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live, line_info->file_type,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	tmp_def, tmp_title, tmp_desc, 
                       	tmp_var, tmp_file, tmp_literal);
        }
        else
        {
        (void) sprintf  (line, output_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live, line_info->file_type,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        tmp_def, tmp_title, tmp_desc, tmp_var);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}

 


/************************************************************
*
*      Routine: xvf_deparse_int_line
*
*      Purpose: deparses an Integer line (-i:  typeflag = IntegerOpt)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_int_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength],
	     tmp_literal[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

        if (line_info->write == false)
        {
	(void) sprintf	(line, int_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	line_info->lower_int, line_info->upper_int,
		       	line_info->int_def, tmp_title,
                       	tmp_desc, tmp_var, line_info->int_val, tmp_literal);
	}
        else
        {
        (void) sprintf  (line, int_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        line_info->lower_int, line_info->upper_int,
                        line_info->int_def, tmp_title, tmp_desc, tmp_var);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_float_line
*
*      Purpose: deparses a Float line (-f:  typeflag = FloatOpt)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_float_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength],
	     tmp_literal[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == false)
        {
	(void) sprintf	(line, float_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	line_info->lower_float, line_info->upper_float,
		       	line_info->float_def, tmp_title, tmp_desc, 
		       	tmp_var, line_info->float_val, tmp_literal);
        }
        else
        {
        (void) sprintf  (line, float_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        line_info->lower_float, line_info->upper_float,
                        line_info->float_def, tmp_title, tmp_desc, tmp_var);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_logic_line
*
*      Purpose: deparses a Logic line (-l:  typeflag = LogicOpt)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_logic_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength],
	     tmp_label0[MaxLength], tmp_label1[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->val_labels[0] == NULL)  sprintf(tmp_label0," ");
	else sprintf(tmp_label0, "%s", line_info->val_labels[0]);

	if (line_info->val_labels[1] == NULL)  sprintf(tmp_label1," ");
	else sprintf(tmp_label1, "%s", line_info->val_labels[1]);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

        if (line_info->write == false)
        {
	(void) sprintf(line, logic_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->xpos, line_info->ypos,
		       line_info->logical_def, tmp_title, 
		       tmp_label0, tmp_label1, tmp_desc, 
		       tmp_var, line_info->logical_val);
        }
        else
        {
        (void) sprintf(line, logic_write,
                       line_info->activate, line_info->selected,
                       line_info->optional, line_info->opt_sel,
                       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->xpos, line_info->ypos,
                       line_info->logical_def, tmp_title,
                       tmp_label0, tmp_label1, tmp_desc, tmp_var);
        }


	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}





/************************************************************
*
*      Routine: xvf_deparse_cycle_line
*
*      Purpose: deparses a Cycle line (-c:  typeflag = Cycle)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_cycle_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmpline[MaxLength],
	     tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength];
	int  i;

	if (line_info->title == NULL) sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	(void) sprintf(tmpline, cycle_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->xpos, line_info->ypos,
		       line_info->cycle_num, line_info->cycle_val,
		       tmp_title, tmp_desc, tmp_var);

	for (i = 0; i < line_info->cycle_num; i++)
	{
	      sprintf(tmpline, "%s '%s'", tmpline, line_info->val_labels[i]);
	}
	sprintf(line, "%s", tmpline);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}





/************************************************************
*
*      Routine: xvf_deparse_list_line
*
*      Purpose: deparses a List line (-x:  typeflag = List)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_list_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmpline[MaxLength],
	     tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength];
	int  i;

	if (line_info->title == NULL) sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	(void) sprintf(tmpline, list_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->xpos, line_info->ypos,
		       line_info->list_num, line_info->list_val,
		       tmp_title, tmp_desc, tmp_var);

	for (i = 0; i < line_info->list_num; i++)
	{
	      sprintf(tmpline, "%s '%s'", tmpline, line_info->val_labels[i]);
	}
	sprintf(line, "%s", tmpline);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_string_line
*
*      Purpose: deparses a String line (-s:  typeflag = StringOpt)
*
*        Input: line_info - the line info structure dictating what
*			    the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_string_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[34*MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength], tmp_def[10*MaxLength],
	     tmp_val[10*MaxLength], tmp_literal[10*MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	if (line_info->string_def == NULL)  sprintf(tmp_def," ");
	else sprintf(tmp_def, "%s", line_info->string_def);

	if (line_info->string_val == NULL)  sprintf(tmp_val," ");
	else sprintf(tmp_val, "%s", line_info->string_val);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	/*
	 *  tics are saved as 0x1f - replace with ' coming in.
	 */
	(void) vreplace_char(tmp_val, '\'', 0x1f, tmp_val);
	(void) vreplace_char(tmp_def, '\'', 0x1f, tmp_def);
	(void) vreplace_char(tmp_literal, '\'', 0x1f, tmp_literal);

        if (line_info->write == false)
        {
	(void) sprintf	(line, string_print, 
			line_info->activate, line_info->selected,
			line_info->optional, line_info->opt_sel,
			line_info->live,
			line_info->width, line_info->height,
			line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	tmp_def, tmp_title, tmp_desc, 
                       	tmp_var, tmp_val, tmp_literal);
	}
        else
        {
        (void) sprintf  (line, string_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        tmp_def, tmp_title, tmp_desc, tmp_var);
        }


	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_routine_line
*
*      Purpose: deparses a Routine line (-r:  typeflag = Routine)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_routine_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_comm[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->routine == NULL)  sprintf(tmp_comm," ");
	else sprintf(tmp_comm, "%s", line_info->routine);

	(void) sprintf(line, routine_print, line_info->activate,
		       line_info->selected, line_info->exec_type,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
		       tmp_title, tmp_desc, tmp_comm, 
		       line_info->exec_bg);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_toggle_line
*
*      Purpose: deparses a Toggle line (-T:  typeflag = Toggle)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_toggle_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength], tmp_desc[MaxLength]; 
	char tmp_var[MaxLength]; 

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

        if (line_info->write == false)
        {
	(void) sprintf  (line, toggle_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	line_info->toggle_def, tmp_title, tmp_desc, 
			tmp_var, line_info->toggle_val);
	}
        else
        {
        (void) sprintf  (line, toggle_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        line_info->toggle_def, tmp_title, tmp_desc, tmp_var);
        }


	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_pane_action_line
*
*      Purpose: deparses a Pane Action line (-a:  typeflag = PaneAction)
*
*        Input: line_info - the line info structure dictating what
*			    the database description will be
*		database -  the internal database structure
*		index    -  index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_pane_action_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_desc[MaxLength], tmp_var[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL) sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

	(void) sprintf(line, pane_action_print, line_info->activate,
		       line_info->selected,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       tmp_title, tmp_desc, tmp_var);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}





/************************************************************
*
*      Routine: xvf_deparse_blank_line(line_info, line);
*
*      Purpose: deparses a Blank line (-b:  typeflag = Blank)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_blank_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength];

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	(void) sprintf(line, blank_print, line_info->xpos,
		       line_info->ypos, tmp_title);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_includepane_line(line_info, line);
*
*      Purpose: deparses an IncludePane line (-p:  typeflag = IncludePane)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/


xvf_deparse_includepane_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_file[MaxLength];

	if (line_info->filename == NULL)  
	{
	     fprintf(stderr, "xvf_deparse_includepane_line:\n");
	     fprintf(stderr, "you must set line_info->filename to desired\n");
	     fprintf(stderr, "'filename.pane' before calling this routine.\n");
	     return;
	}

	(void) sprintf(line, includepane_print, tmp_file);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}


/************************************************************
*
*      Routine: xvf_deparse_includesubform_line(line_info, line);
*
*      Purpose: deparses an IncludeSubForm line (-k:  typeflag = IncludeSubForm)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/


xvf_deparse_includesubform_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_file[MaxLength];

	if (line_info->filename == NULL)  
	{
	     fprintf(stderr, "xvf_deparse_includesubform_line:\n");
	     fprintf(stderr, "you must set line_info->filename to desired\n");
	     fprintf(stderr, "'filename.subform' before calling this routine.\n");
	     return;
	}

	(void) sprintf(line, includesubform_print, tmp_file);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_end_line(line_info, line);
*
*      Purpose: deparses an End line (-E:  typeflag = End)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/


xvf_deparse_end_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength];

	(void) sprintf(line, "-E");

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_mutexcl_line(line_info, line);
*
*      Purpose: deparses a Mutually Exclusive line (-C:  typeflag = MutExcl)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/


xvf_deparse_mutexcl_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength];

	(void) sprintf(line, "-C %d", line_info->logical_val);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_workspace_line
*
*      Purpose: deparses a Workspace line  (-w:  typeflag = WorkWidget)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro 
*
**************************************************************/

xvf_deparse_workspace_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength]; 
	char tmp_title[MaxLength], tmp_desc[MaxLength], tmp_var[MaxLength];
        long tmp_wksp_address;

	if (line_info->title == NULL)  sprintf(tmp_title," ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->description == NULL)  sprintf(tmp_desc," ");
	else sprintf(tmp_desc, "%s", line_info->description);

	if (line_info->variable == NULL)  sprintf(tmp_var," ");
	else sprintf(tmp_var, "%s", line_info->variable);

        if (line_info->workspace != NULL) 
	    tmp_wksp_address = (long) line_info->workspace;

	if (line_info->write == false)
        {
	(void) sprintf(line, workspace_print, 
		       line_info->width, line_info->height,
                       line_info->x, line_info->y,
                       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_desc, tmp_var, tmp_wksp_address);
        }
        else
        {
        (void) sprintf(line, workspace_write,
                       line_info->width, line_info->height,
                       line_info->x, line_info->y,
                       line_info->xpos, line_info->ypos,
                       tmp_title, tmp_desc, tmp_var);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}




/************************************************************
*
*      Routine: xvf_deparse_libcall_line(line_info, line);
*
*      Purpose: deparses a LibCall line (-L:  typeflag = LibCall)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro 
*
**************************************************************/


xvf_deparse_libcall_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_call[MaxLength];

	if (line_info->lib_call == NULL)  
	{
	     fprintf(stderr, "xvf_deparse_libcall_line:\n");
	     fprintf(stderr, "you must set line_info->filename to desired\n");
	     fprintf(stderr, "library call before calling this routine.\n");
	     return;
	}

	(void) sprintf(line, libcall_print, tmp_call);

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_ansinfile_line
*
*      Purpose: deparses an AnswerInfile line (-A:  typeflag = AnswerInfile)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro & Stephanie Hallett
*
**************************************************************/

xvf_deparse_ansinfile_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_var[MaxLength], tmp_def[MaxLength],
	     tmp_file[MaxLength], tmp_literal[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->file_def == NULL)  sprintf(tmp_def," ");
	else sprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  sprintf(tmp_file," ");
	else sprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == false)
        {
	(void) sprintf (line, ansinfile_print, 
			line_info->activate, line_info->selected,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	tmp_def, tmp_title, tmp_file, tmp_literal);
	 }
        else
        {
        (void) sprintf (line, ansinfile_write,
                        line_info->activate, line_info->selected,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        tmp_def, tmp_title);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}



/************************************************************
*
*      Routine: xvf_deparse_ansoutfile_line
*
*      Purpose: deparses an AnswerInfile line (-A:  typeflag = AnswerInfile)
*
*        Input: line_info - the line info structure dictating what
*			   the database description will be
*		database - the internal database structure
*		index    - index into the database for the desired line
*
*       Output: pointer to the created line put together according
*		to the fields in the line_info structure
*
*     Written by: Danielle Argiro 
*
**************************************************************/

xvf_deparse_ansoutfile_line(line_info, database, index)
Line_Info *line_info;
char 	  *database[];
int	  index;
{
	char line[MaxLength], tmp_title[MaxLength],
	     tmp_var[MaxLength], tmp_def[MaxLength],
	     tmp_file[MaxLength], tmp_literal[MaxLength];

	if (line_info->title == NULL) sprintf(tmp_title, " ");
	else sprintf(tmp_title, "%s", line_info->title);

	if (line_info->file_def == NULL)  sprintf(tmp_def," ");
	else sprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  sprintf(tmp_file," ");
	else sprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  sprintf(tmp_literal," ");
	else sprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == false)
        {
	(void) sprintf (line, ansoutfile_print, 
			line_info->activate, line_info->selected,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
                       	line_info->xpos, line_info->ypos,
		       	tmp_def, tmp_title, tmp_file, tmp_literal);
	 }
        else
        {
        (void) sprintf (line, ansoutfile_write,
                        line_info->activate, line_info->selected,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        line_info->xpos, line_info->ypos,
                        tmp_def, tmp_title);
        }

	if (database[index] != NULL)
 	{
		free(database[index]); 
		database[index] = xvf_strcpy(line);
	}
	else database[index] = xvf_strcpy(line);
}


