 /*
  * Khoros: $Id: vfft.h,v 1.4 1992/01/17 00:43:50 dkhoros Exp $
  */

 /*
  * $Log: vfft.h,v $
 * Revision 1.4  1992/01/17  00:43:50  dkhoros
 * HellPatch4
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfft.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Wed Jan 15 10:00:29 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vfft_h_
#define _vfft_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vfft Argument Structure
*
****************************************************************/

typedef struct _vfft  {

/*
 *  complex or real image (Required infile)
 */
char	*i1_file;	/* complex or real image FILENAME */
int	 i1_flag;	/* complex or real image FLAG */

/*
 *  imaginary image (Optional infile)
 */
char	*i2_file;	/* imaginary image FILENAME */
int	 i2_flag;	/* imaginary image FLAG */

/*
 *  complex output image (Optional outfile)
 */
char	*o1_file;	/* complex output image FILENAME */
int	 o1_flag;	/* complex output image FLAG */

/*
 *  real output image (Optional outfile)
 */
char	*o2_file;	/* real output image FILENAME */
int	 o2_flag;	/* real output image FLAG */

/*
 *  imaginary output image (Optional outfile)
 */
char	*o3_file;	/* imaginary output image FILENAME */
int	 o3_flag;	/* imaginary output image FLAG */

/*
 *  FFT direction (0 is forward, 1 is inverse) (Optional logical)
 */
int	 d_logic;	/* FFT direction (0 is forward, 1 is inverse) LOGIC */
int	 d_flag;  	/* FFT direction (0 is forward, 1 is inverse) FLAG */

}  vfft_struct;

vfft_struct *vfft;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image1) \
    if (vfft->i1_flag == TRUE) { \
       image1 = readimage(vfft->i1_file); \
       if (image1 == NULL){ \
          (void) fprintf(stderr,"vfft: Input image could not be read\\n"); \
          exit(1); \
          } \
       }

#define CHECKINPUT(program, image1) \
    (void) proper_num_images(program,image1,1,TRUE); \
    (void) proper_map_enable(program,image1,VFF_MAP_OPTIONAL,TRUE); \
    (void) proper_num_bands(program,image1,1,TRUE)

#define MATCHINPUT(program, image1, image2) \
    (void) match_num_images(program, image1, image2, TRUE); \
    (void) match_num_bands(program, image1, image2, TRUE); \
    (void) match_map_enable(program, image1, image2, TRUE); \
    (void) matchsize(program, image1, image2, TRUE)

/* -include_macros_end */

#endif
