 /*
  * Khoros: $Id: vextract.c,v 1.2 1991/12/18 09:36:18 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vextract.c,v 1.2 1991/12/18 09:36:18 dkhoros Exp $";
#endif

 /*
  * $Log: vextract.c,v $
 * Revision 1.2  1991/12/18  09:36:18  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vextract.c
 >>>>
 >>>>      Program Name: vextract
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extract a rectangular piece from an image and put  it  in  a
 >>>>	subimage
 >>>>	
 >>>>	

 >>>>            Author: John Rasure, Mark Young
 >>>>
 >>>> Date Last Updated: Thu Nov  7 11:59:21 1991
 >>>>
 >>>>          Routines: main- the main program for vextract
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vextract.h"


/****************************************************************
 *
 * Routine Name:  main program for vextract
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-i1] input coordinate image
 *          [-x] specifies upper left x coordinate of subimage  (value >= 0)
 *          [-y] specifies upper left y coordinate of subimage  (value >= 0)
 *          [-w] specifies the subimage width in pixels  (value > 0)
 *          [-h] specifies the subimage height in pixels  (value > 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *coord_img, *readimage();
int hvalue, vvalue, nc;
char *cptr;
short *sptr;
int *lptr;
float *fptr;
double *dptr;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

img1 = readimage(vextract->i_file);
if (img1 == NULL) exit(1);    /* Quit if bad image */

CHECKINPUT(program,img1);   /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
if ((vextract->i1_flag) && (vextract->w_flag || vextract->h_flag ||
        vextract->x_flag || vextract->y_flag))
{
   (void) fprintf(stderr, "vextract: Error, can specify either the coordinate image or the specific coordinate values\n");
   exit(1);

}

if (vextract->i1_flag)
{
   coord_img = readimage(vextract->i1_file);
   if (coord_img == NULL) exit(1);    /* Quit if bad image */

   CHECKCOORDINPUT(program,coord_img);   /* Verify coord input image */
   nc = coord_img->row_size;

   switch(coord_img->data_storage_type)
   {
        case VFF_TYP_1_BYTE:
           cptr = (char *) coord_img->imagedata;
           hvalue =  (int) (cptr[nc] - cptr[0]);
           vvalue =  (int) (cptr[(2 * nc) + 1] - cptr[1]);
           vextract->x_int = (int) cptr[0];
           vextract->y_int = (int) cptr[1];
           break;
        case VFF_TYP_2_BYTE:
           sptr = (short *) coord_img->imagedata;
           hvalue =  (int) (sptr[nc] - sptr[0]);
           vvalue =  (int) (sptr[(2*nc) + 1] - sptr[1]);
           vextract->x_int = (int) sptr[0];
           vextract->y_int = (int) sptr[1];
           break;
        case VFF_TYP_4_BYTE:
           lptr = (int *) coord_img->imagedata;
           hvalue =  (int) (lptr[nc] - lptr[0]);
           vvalue =  (int) (lptr[(2*nc) + 1] - lptr[1]);
           vextract->x_int = (int) lptr[0];
           vextract->y_int = (int) lptr[1];
           break;
        case VFF_TYP_FLOAT:
           fptr = (float *) coord_img->imagedata;
           hvalue =  (int) (fptr[nc] - fptr[0]);
           vvalue =  (int) (fptr[(2*nc) + 1] - fptr[1]);
           vextract->x_int = (int) fptr[0];
           vextract->y_int = (int) fptr[1];
           break;
        case VFF_TYP_DOUBLE:
           dptr = (double *) coord_img->imagedata;
           hvalue =  (int) (dptr[nc] - dptr[0]);
           vvalue =  (int) (dptr[(2*nc) + 1] - dptr[1]);
           vextract->x_int = (int) dptr[0];
           vextract->y_int = (int) dptr[1];
           break;
        default:
           (void) fprintf(stderr,
             "vextract: Error, Coordinate image has an Invalid data type\n"); 
           (void) fprintf(stderr,
             "      Data types supported are Byte, Short, Int, and Float\n");
           exit(1);
           break;
   }

   if (hvalue <= 0)
   {
        (void) fprintf(stderr, 
            "vextract: Error, Coordinate image data point 0 is greater than\n");
        (void) fprintf(stderr, "point 1 in the horizontal direction");
        exit(1);

   } 
   else
     vextract->w_int = hvalue;

   if (vvalue <= 0)
   {
        (void) fprintf(stderr, 
            "vextract: Error, Coordinate image data point 0 is greater than\n");
        (void) fprintf(stderr, "point 2 in the vertical direction");
        exit(1);

   } 
   else
     vextract->h_int = vvalue;
}


if(! lvextract(img1,&img2,vextract->w_int ,vextract->h_int,vextract->x_int,vextract->y_int, TRUE))
  {
     (void) fprintf(stderr, "lvextract Failed\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vextract->o_file,img2);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vextract 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vextract :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtract a rectangular piece from an image and put  it  in  a\n");
	fprintf(stderr, "\tsubimage\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i1]  input coordinate image (infile) [null]\n");
	fprintf(stderr,"\t[-x]  specifies upper left x coordinate of subimage (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-y]  specifies upper left y coordinate of subimage (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-w]  specifies the subimage width in pixels (integer, > 0) [128]\n");
	fprintf(stderr,"\t[-h]  specifies the subimage height in pixels (integer, > 0) [128]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vextract\n");
	fprintf(stderr, "\t[-U] Gives the usage for vextract\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vextract.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vextract.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vextract
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*i1_pstr = 
	"\nEnter: (i1) input coordinate image \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) specifies upper left x coordinate of subimage \n        {integer, >= 0 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) specifies upper left y coordinate of subimage \n        {integer, >= 0 [0] }: "; 
char	*w_pstr = 
	"\nEnter: (w) specifies the subimage width in pixels \n        {integer, > 0 [128] }: "; 
char	*h_pstr = 
	"\nEnter: (h) specifies the subimage height in pixels \n        {integer, > 0 [128] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vextract", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vextract.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vextract: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vextract.ans");
		}

	     }

	}

	/*
	 * allocate the vextract structure
	 */
	vextract = (vextract_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vextract_struct));

	/*
	 * get required arguments for vextract
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vextract->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vextract->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vextract->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vextract->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vextract->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vextract->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vextract->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vextract->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vextract->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vextract->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vextract
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vextract->i1_flag = vget_infile(fid, prompt_flag,
	"-i1", i1_pstr, &(vextract->i1_file))
;

	vextract->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vextract->x_int),
	0, 1, 1);

	vextract->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vextract->y_int),
	0, 1, 1);

	vextract->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(vextract->w_int),
	128, 2, 2);

	vextract->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(vextract->h_int),
	128, 2, 2);


}



