 /*
  * Khoros: $Id: vgcirc.h,v 1.2 1991/12/18 09:41:26 dkhoros Exp $
  */

 /*
  * $Log: vgcirc.h,v $
 * Revision 1.2  1991/12/18  09:41:26  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgcirc.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Dec  9 23:22:49 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgcirc_h_
#define _vgcirc_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgcirc Argument Structure
*
****************************************************************/

typedef struct _vgcirc  {

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 * Selects data type of output image (Required string toggle - )
 */
char	*t_toggle;		/* Selects data type of output image STRING TOGGLE */
int	 t_flag;		/* Selects data type of output image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  Desired number of rows in output image (Optional integer)
 */
int	 r_int; 	/* Desired number of rows in output image INT */
int	 r_flag;	/* Desired number of rows in output image FLAG */

/*
 *  Desired number of columns in output image (Optional integer)
 */
int	 c_int; 	/* Desired number of columns in output image INT */
int	 c_flag;	/* Desired number of columns in output image FLAG */

/*
 *  Diameter of circle (in pixels) (Optional float)
 */
float	 d_float;	/* Diameter of circle (in pixels) FLOAT */
int	 d_flag;   	/* Diameter of circle (in pixels) FLAG */

/*
 *  X coordinate of center of circle (Optional float)
 */
float	 x_float;	/* X coordinate of center of circle FLOAT */
int	 x_flag;   	/* X coordinate of center of circle FLAG */

/*
 *  Y coordinate of center of circle (Optional float)
 */
float	 y_float;	/* Y coordinate of center of circle FLOAT */
int	 y_flag;   	/* Y coordinate of center of circle FLAG */

/*
 *  Background level (Optional float)
 */
float	 b_float;	/* Background level FLOAT */
int	 b_flag;   	/* Background level FLAG */

/*
 *  Foreground level (Optional float)
 */
float	 f_float;	/* Foreground level FLOAT */
int	 f_flag;   	/* Foreground level FLAG */

}  vgcirc_struct;

vgcirc_struct *vgcirc;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
