 /*
  * Khoros: $Id: venhpatch.c,v 1.1 1991/05/10 15:49:24 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: venhpatch.c,v 1.1 1991/05/10 15:49:24 khoros Exp $";
#endif

 /*
  * $Log: venhpatch.c,v $
 * Revision 1.1  1991/05/10  15:49:24  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: venhpatch.c
 >>>>
 >>>>      Program Name: venhpatch
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Equalize or stretch image contrast based on local  histogram
 >>>>	information.
 >>>>	
 >>>>	
 >>>>            Author: John Rasure
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:32:51 1991
 >>>>
 >>>>          Routines: main- the main program for venhpatch
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "venhpatch.h"


/****************************************************************
 *
 * Routine Name:  main program for venhpatch
 *
 *       Input:  
 *           -i  input image 
 *           -o  resulting output image 
 *           -w  specifies local width of region   (1 < value < 256)
 *           -h  specifies local height of region   (1 < value < 256)
 *
 *
 *           [-t] Choose Stretch [False] or Equalize [True]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1, *img2, *readimage();

    unsigned long rsize, csize;
    unsigned long xoffset, yoffset;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    img1 = readimage(venhpatch->i_file);
    if (img1 == NULL)
      {
        (void) fprintf(stderr,"venhpatch: Unable to read input image.\n");
        exit(1);    /* Quit if bad image */
      }

    CHECKINPUT(program,img1);
/* -main_before_lib_call_end */

/* -main_library_call */
/*
Calculate coordinates for local regions and then pass to lvextract2()
*/

    rsize = img1->row_size;  /* set row and column size */
    csize = img1->col_size;

    for (xoffset=0; xoffset < rsize; xoffset=xoffset+venhpatch->w_int)
    {
      for (yoffset=0; yoffset < csize; yoffset=yoffset+venhpatch->h_int)
      {
        if(!lvextract(img1, &img2, venhpatch->w_int, venhpatch->h_int, xoffset, yoffset, FALSE))
        {
          (void) fprintf(stderr, "venhpatch: lvextract2 Failed\n");
          exit(1);
        }

        if (venhpatch->t_logic)    /* if t_logic is set, then equalize */
        {
           if(!lvheq(img2,PHOTO_POS))
           {
              (void) fprintf(stderr, "venhpatch: lvheq Failed\n");
              exit(1);
           }
        }
        else                   /* t_logic = 0, so stretch image */
        {
           if(!lvhstr(img2,PHOTO_POS))
           {
              (void) fprintf(stderr, "venhpatch: lvhstr Failed\n");
              exit(1);
           }
        }

        if(!lvinsert(img1,img2,xoffset,yoffset))
        {
           (void) fprintf(stderr, "venhpatch: lvinsert Failed\n");
           exit(1);
        }
      }
      freeimage(img2); /* lvextract2 will malloc new space for img2 */
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(venhpatch->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for venhpatch 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "venhpatch :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tEqualize or stretch image contrast based on local  histogram\n");
	fprintf(stderr, "\tinformation.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-w  specifies local width of region  (integer, 1 to 256)\n");
	fprintf(stderr,"\t-h  specifies local height of region  (integer, 1 to 256)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  Choose Stretch [False] or Equalize [True] (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for venhpatch\n");
	fprintf(stderr, "\t[-U] Gives the usage for venhpatch\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called venhpatch.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses venhpatch.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for venhpatch
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) specifies local width of region \n        {integer, 1 to 256}: "; 
char	*h_pstr = 
	"\nEnter: (h) specifies local height of region \n        {integer, 1 to 256}: "; 
char	*t_pstr = 
	"\nEnter: (t) Choose Stretch [False] or Equalize [True] \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "venhpatch", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "venhpatch.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "venhpatch: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "venhpatch.ans");
		}

	     }

	}

	/*
	 * allocate the venhpatch structure
	 */
	venhpatch = (venhpatch_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (venhpatch_struct));

	/*
	 * get required arguments for venhpatch
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(venhpatch->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(venhpatch->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhpatch->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    venhpatch->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(venhpatch->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhpatch->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(venhpatch->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhpatch->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    venhpatch->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(venhpatch->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhpatch->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(venhpatch->w_int),
			20, 1, 256)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhpatch->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    venhpatch->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(venhpatch->w_int),
		    20, 1, 256);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhpatch->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(venhpatch->h_int),
			20, 1, 256)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhpatch->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    venhpatch->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(venhpatch->h_int),
		    20, 1, 256);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for venhpatch
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	venhpatch->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(venhpatch->t_logic), 1);


}



