 /*
  * Khoros: $Id: venhance.c,v 1.1 1991/05/10 15:49:22 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: venhance.c,v 1.1 1991/05/10 15:49:22 khoros Exp $";
#endif

 /*
  * $Log: venhance.c,v $
 * Revision 1.1  1991/05/10  15:49:22  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: venhance.c
 >>>>
 >>>>      Program Name: venhance
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Enhances an image using the  local  standard  deviation  and
 >>>>	mean.
 >>>>	
 >>>>	
 >>>>            Author: Marcelo Teran
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:32:44 1991
 >>>>
 >>>>          Routines: main- the main program for venhance
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "venhance.h"


/****************************************************************
 *
 * Routine Name:  main program for venhance
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *          -w  window width of local area   (1 < value < 100)
 *          -h  window height of local area   (1 < value < 100)
 *          -k  specifies scale factor   (0.000 < value < 1.000)
 *          -v  specifies minimum standard deviation   (0.000 < value < 2000.000)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    image = readimage(venhance->i_file);
    if (image == NULL){
        (void)fprintf(stderr,"vhmed: Image could not be read\n");
         exit(1);               /* Quit if bad image */
    }

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvenhance(image,venhance->w_int,venhance->h_int,venhance->k_float,
                venhance->v_float)){
        (void) fprintf(stderr, "lvhmed Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(venhance->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for venhance 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "venhance :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tEnhances an image using the  local  standard  deviation  and\n");
	fprintf(stderr, "\tmean.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr,"\t-w  window width of local area  (integer, 1 to 100)\n");
	fprintf(stderr,"\t-h  window height of local area  (integer, 1 to 100)\n");
	fprintf(stderr,"\t-k  specifies scale factor  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-v  specifies minimum standard deviation  (float,  0.000 to 2000.000)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for venhance\n");
	fprintf(stderr, "\t[-U] Gives the usage for venhance\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called venhance.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses venhance.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for venhance
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) window width of local area \n        {integer, 1 to 100}: "; 
char	*h_pstr = 
	"\nEnter: (h) window height of local area \n        {integer, 1 to 100}: "; 
char	*k_pstr = 
	"\nEnter: (k) specifies scale factor \n        {float,  0.000 to 1.000}: "; 
char	*v_pstr = 
	"\nEnter: (v) specifies minimum standard deviation \n        {float,  0.000 to 2000.000}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "venhance", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "venhance.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "venhance: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "venhance.ans");
		}

	     }

	}

	/*
	 * allocate the venhance structure
	 */
	venhance = (venhance_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (venhance_struct));

	/*
	 * get required arguments for venhance
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(venhance->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(venhance->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    venhance->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(venhance->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhance->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(venhance->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    venhance->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(venhance->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhance->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(venhance->w_int),
			3, 1, 100)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    venhance->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(venhance->w_int),
		    3, 1, 100);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhance->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(venhance->h_int),
			3, 1, 100)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    venhance->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(venhance->h_int),
		    3, 1, 100);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhance->k_flag = vget_float(fid, prompt_flag,
			"-k", k_pstr, &(venhance->k_float),
			0.500000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->k_flag))
		{
		    fprintf(stderr, "\t\tk is required, please re-enter: \n");
		    venhance->k_flag = vget_float(fid, prompt_flag,
		    "-k", k_pstr, &(venhance->k_float),
		    0.500000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-k' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(venhance->v_flag = vget_float(fid, prompt_flag,
			"-v", v_pstr, &(venhance->v_float),
			1.000000, 0.000000, 2000.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(venhance->v_flag))
		{
		    fprintf(stderr, "\t\tv is required, please re-enter: \n");
		    venhance->v_flag = vget_float(fid, prompt_flag,
		    "-v", v_pstr, &(venhance->v_float),
		    1.000000, 0.000000, 2000.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-v' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



