 /*
  * Khoros: $Id: vdiff.h,v 1.1 1991/05/10 15:48:06 khoros Exp $
  */

 /*
  * $Log: vdiff.h,v $
 * Revision 1.1  1991/05/10  15:48:06  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdiff.h
 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>> Date Last Updated: Tue Mar  5 22:28:46 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vdiff_h_
#define _vdiff_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vdiff Argument Structure
*
****************************************************************/

typedef struct _vdiff  {

/*
 *  input image filename (Required infile)
 */
char	*i1_file;	/* input image filename FILENAME */
int	 i1_flag;	/* input image filename FLAG */

/*
 *  input kernel (operator) in X (Required infile)
 */
char	*i2_file;	/* input kernel (operator) in X FILENAME */
int	 i2_flag;	/* input kernel (operator) in X FLAG */

/*
 *  input kernel (operator) in Y (Required infile)
 */
char	*i3_file;	/* input kernel (operator) in Y FILENAME */
int	 i3_flag;	/* input kernel (operator) in Y FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

}  vdiff_struct;

vdiff_struct *vdiff;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
data_storage_type = VFF_TYP_1_BYTE || VFF_TYP_FLOAT
map_enable = VFF_MAP_OPTIONAL

also checks to make sure that kern1 and kern2 have the same
deminsions and that they are of type INTEGER or FLOAT
*/

#define CHECKINPUT(program, img1, kern1, kern2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,kern1,TRUE); \
        (void) match_num_images(program,img1,kern2,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        (void) match_num_bands(program,img1,kern1,TRUE); \
        (void) match_num_bands(program,img1,kern2,TRUE); \
        \
        (void) propertype(program,img1,VFF_TYP_1_BYTE,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        (void) match_map_enable(program,img1,kern1,TRUE); \
        (void) match_map_enable(program,img1,kern2,TRUE); \
        \
        if (propertype(program,kern1,VFF_TYP_BIT,FALSE) || \
            propertype(program,kern1,VFF_TYP_1_BYTE,FALSE) || \
            propertype(program,kern1,VFF_TYP_2_BYTE,FALSE) || \
            propertype(program,kern1,VFF_TYP_COMPLEX,FALSE)) \
        { \
            (void) fprintf(stderr, "kern1: Image data type should be \
VFF_TYP_4_BYTE || VFF_TYP_FLOAT\n"); \
            exit(1); \
        } \
        \
        if (propertype(program,kern2,VFF_TYP_BIT,FALSE) || \
            propertype(program,kern2,VFF_TYP_1_BYTE,FALSE) || \
            propertype(program,kern2,VFF_TYP_2_BYTE,FALSE) || \
            propertype(program,kern2,VFF_TYP_COMPLEX,FALSE)) \
        { \
            (void) fprintf(stderr, "kern2: Image data type should be \
VFF_TYP_4_BYTE || VFF_TYP_FLOAT\n"); \
            exit(1); \
        } \
        \
        (void) matchsize(program,kern1,kern2,TRUE)
/* -include_macros_end */

#endif
