 /*
  * Khoros: $Id: vconvert.c,v 1.3 1992/03/20 22:53:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vconvert.c,v 1.3 1992/03/20 22:53:45 dkhoros Exp $";
#endif

 /*
  * $Log: vconvert.c,v $
 * Revision 1.3  1992/03/20  22:53:45  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vconvert.c
 >>>>
 >>>>      Program Name: vconvert
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert a Khoros image from one data storage type to another
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sun Feb 23 11:51:24 1992
 >>>>
 >>>>          Routines: main- the main program for vconvert
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vconvert.h"


/****************************************************************
 *
 * Routine Name:  main program for vconvert
 *
 *       Input:  
 *          -i  input image 
 *          -o  resulting output image 
 *
 *
 *          [-b] if true, bands are processed independently
 *          [-t] lets user choose output data type
 *		'bit' (choose bit data type),
 *		'byte' (choose byte data type),
 *		'short' (choose short data type),
 *		'int' (choose integer data type),
 *		'float' (choose float data type),
 *		'complex' (choose complex data type),
 *		'double' (choose double data type),
 *		 or 'dcomplex' (choose double data type)
 *		   [default = byte] 
 *
 *          [-n  specifies normalization value    (value > 0.0) -OR-
 *           -s  specifies scale factor   ) ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *readimage();
        int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        if (!vget_type(&type,vconvert->t_toggle))
          {
            (void)fprintf(stderr,"vconvert: unknown data type!\n");
           exit(1);
          }
        image = readimage(vconvert->i_file);
        if (image == NULL) exit(1);        /* Quit if error reading the image */

        CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvconvert(image,type,vconvert->n_flag,vconvert->s_flag,
                             vconvert->n_float,vconvert->s_float,
                             vconvert->b_logic) )
          {
            (void) fprintf(stderr, "lvconvert Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vconvert->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vconvert 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vconvert :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert a Khoros image from one data storage type to another\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]  if true, bands are processed independently (boolean) [false]\n");
	fprintf(stderr, "\t[-t]  lets user choose output data type\n");
	fprintf(stderr, "\t\t'bit'  (choose bit data type),\n");
	fprintf(stderr, "\t\t'byte'  (choose byte data type),\n");
	fprintf(stderr, "\t\t'short'  (choose short data type),\n");
	fprintf(stderr, "\t\t'int'  (choose integer data type),\n");
	fprintf(stderr, "\t\t'float'  (choose float data type),\n");
	fprintf(stderr, "\t\t'complex'  (choose complex data type),\n");
	fprintf(stderr, "\t\t'double'  (choose double data type),\n");
	fprintf(stderr, "\t\t or 'dcomplex'  (choose double data type)\n");
	fprintf(stderr, "\t\t[default = byte]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-n  specifies normalization value  (float, > 0.0) -OR- \n");
	fprintf(stderr,"\t  -s  specifies scale factor  (float) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vconvert\n");
	fprintf(stderr, "\t[-U] Gives the usage for vconvert\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vconvert.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vconvert.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vconvert
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) if true, bands are processed independently \n        {boolean, (y/n)  [no] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose output data type -- \n      \t\t'bit' (choose bit data type)\n\t\t'byte' (choose byte data type)\n\t\t'short' (choose short data type)\n\t\t'int' (choose integer data type)\n\t\t'float' (choose float data type)\n\t\t'complex' (choose complex data type)\n\t\t'double' (choose double data type)\n\t\tor 'dcomplex' (choose double data type)\n  [byte]:  "; 
char	*n_pstr = 
	"\nEnter: (n) specifies normalization value \n        {float, > 0.0 [255.000000] }: "; 
char	*s_pstr = 
	"\nEnter: (s) specifies scale factor \n        {float [1.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vconvert", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vconvert.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vconvert: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vconvert.ans");
		}

	     }

	}

	/*
	 * allocate the vconvert structure
	 */
	vconvert = (vconvert_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vconvert_struct));

	/*
	 * get required arguments for vconvert
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vconvert->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vconvert->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconvert->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vconvert->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vconvert->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vconvert->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vconvert->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vconvert->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vconvert->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vconvert->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vconvert
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vconvert->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(vconvert->b_logic), 0);


	/*
	 * get optional toggles for vconvert
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vconvert->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vconvert->t_toggle),
		"byte");

		if (((strcmp(vconvert->t_toggle, "bit") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "byte") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "short") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "int") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "float") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "complex") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "double") == 0)) || 
		     ((strcmp(vconvert->t_toggle, "dcomplex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vconvert->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vconvert->t_toggle),
		"byte");

		if (((strcmp(vconvert->t_toggle, "bit") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "byte") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "short") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "int") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "float") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "complex") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "double") != 0)) && 
		     ((strcmp(vconvert->t_toggle, "dcomplex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional mutually exclusive groups for vconvert
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		vconvert->n_flag = vget_float(fid, prompt_flag,
		    "-n", n_pstr, &(vconvert->n_float),
		    255.000000, 2.000000, 2.000000);

    		if(!( (vconvert->n_flag)))
		    vconvert->s_flag = vget_float(fid, prompt_flag,
		    "-s", s_pstr, &(vconvert->s_float),
		    1.000000, 0.000000, 0.000000);

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(vconvert->n_flag = vget_float(fid, prompt_flag,
		    "-n", n_pstr, &(vconvert->n_float),
		    255.000000, 2.000000, 2.000000))
		    count++;

		if(vconvert->s_flag = vget_float(fid, prompt_flag,
		    "-s", s_pstr, &(vconvert->s_float),
		    1.000000, 0.000000, 0.000000))
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -n  -s \n");
		    gw_usage();
		    exit(1);
		}

	}


}



