 /*
  * Khoros: $Id: vbandspt3.c,v 1.1 1991/05/10 15:46:55 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vbandspt3.c,v 1.1 1991/05/10 15:46:55 khoros Exp $";
#endif

 /*
  * $Log: vbandspt3.c,v $
 * Revision 1.1  1991/05/10  15:46:55  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbandspt3.c
 >>>>
 >>>>      Program Name: vbandspt3
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extract 3 data bands from a multiband image
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:23:05 1991
 >>>>
 >>>>          Routines: main- the main program for vbandspt3
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vbandspt3.h"


/****************************************************************
 *
 * Routine Name:  main program for vbandspt3
 *
 *       Input:  
 *           -i  input image filename 
 *
 *
 *           [-o1] output image filename
 *           [-o2] output image filename
 *           [-o3] output image filename
 *           [-b] Data band number to extract  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage(), **images_list, **create_images_list(), *img1, *img2, *img3;

char    *img1_file,
        *img2_file,
        *img3_file;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
       /* read in input image */
image = readimage(vbandspt3->i_file);
if (image == NULL) exit(1);                       /* Quit if bad image */

       /* can only have one image in the input file */
(void) proper_num_images(program,image,1,TRUE);

       /* Make sure that there are enough data bands available in the
          input image. if -b option + 3 must be greater than
          the total number of data bands */

if ( (vbandspt3->b_int + 3)  > image->num_data_bands) {
   (void) fprintf(stderr, "%s: Cannot extract out 3 data bands starting with data band %d,", program,vbandspt3->b_int);
   (void) fprintf(stderr,"\ninput image only contains %d data bands\n", image->num_data_bands );
    exit(1);
}
      /* if the output files were not specified, then use
         the input filename, otherwise just copy the
         output file name to the new variable */

if (vbandspt3->o1_flag)
    img1_file = vbandspt3->o1_file;
else
    img1_file = vbasename(vbandspt3->i_file);
if (vbandspt3->o2_flag)
    img2_file = vbandspt3->o2_file;
else
    img2_file = vbasename(vbandspt3->i_file);
if (vbandspt3->o3_flag)
    img3_file = vbandspt3->o3_file;
else
    img3_file = vbasename(vbandspt3->i_file);

      /* if the output files are not specified, than take
         the input file and append an appropriate suffix
         to it, and use that as the output file name */

APPENDFILENAME(image, vbandspt3);

      /* create a list of pointers to xvimage structures, the
         number in the list will be the number of data bands */

images_list = create_images_list(image->num_data_bands);
if ( images_list == NULL)
{
   (void) fprintf(stderr, "create_images_list Failed\n");
   exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
       /* seprate out all bands into seprate images */

if(! lvbandsprt(image, images_list, vbandspt3->i_file, TRUE))
{
    (void) fprintf(stderr, "lvbandspt1 Failed\n");
    exit(1);
}

      /* since we can only extract 3 bands, extract 3 bands starting
         with the band specified by the -b option */

img1 = images_list[(vbandspt3->b_int)];
img2 = images_list[vbandspt3->b_int+1];
img3 = images_list[vbandspt3->b_int+2];
/* -main_library_call_end */

/* -main_after_lib_call */
/* write out the 3 images */

writeimage(img1_file, img1);
writeimage(img2_file, img2);
writeimage(img3_file, img3);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vbandspt3 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vbandspt3 :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtract 3 data bands from a multiband image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-b]  Data band number to extract (integer, >= 0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vbandspt3\n");
	fprintf(stderr, "\t[-U] Gives the usage for vbandspt3\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vbandspt3.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vbandspt3.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vbandspt3
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) output image filename \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) output image filename \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) output image filename \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) Data band number to extract \n        {integer, >= 0 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vbandspt3", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vbandspt3.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vbandspt3: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vbandspt3.ans");
		}

	     }

	}

	/*
	 * allocate the vbandspt3 structure
	 */
	vbandspt3 = (vbandspt3_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vbandspt3_struct));

	/*
	 * get required arguments for vbandspt3
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vbandspt3->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vbandspt3->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbandspt3->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vbandspt3->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vbandspt3->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vbandspt3
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vbandspt3->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vbandspt3->o1_file))
;

	vbandspt3->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vbandspt3->o2_file))
;

	vbandspt3->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vbandspt3->o3_file))
;

	vbandspt3->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vbandspt3->b_int),
	0, 1, 1);


}



