 /*
  * Khoros: $Id: vnot.c,v 1.1 1991/05/10 15:45:51 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vnot.c,v 1.1 1991/05/10 15:45:51 khoros Exp $";
#endif

 /*
  * $Log: vnot.c,v $
 * Revision 1.1  1991/05/10  15:45:51  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vnot.c
 >>>>
 >>>>      Program Name: vnot
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compliment an image  by  subtracting  pixel  values  from  a
 >>>>	constant.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:58:46 1991
 >>>>
 >>>>          Routines: main- the main program for vnot
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vnot.h"


/****************************************************************
 *
 * Routine Name:  main program for vnot
 *
 *       Input:  
 *      -i  input image 
 *      -o  resulting output image 
 *      -l  level to subtract input image from  
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vnot->i_file);
    if (image == NULL) exit(1);                 /* Quit if bad image */

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvnot(image,vnot->l_float) )
    {
        (void) fprintf(stderr, "lvnot Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vnot->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vnot 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vnot :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompliment an image  by  subtracting  pixel  values  from  a\n");
	fprintf(stderr, "\tconstant.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-l  level to subtract input image from  (float)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vnot\n");
	fprintf(stderr, "\t[-U] Gives the usage for vnot\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vnot.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vnot.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vnot
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*l_pstr = 
	"\nEnter: (l) level to subtract input image from \n        {float}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vnot", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vnot.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vnot: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vnot.ans");
		}

	     }

	}

	/*
	 * allocate the vnot structure
	 */
	vnot = (vnot_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vnot_struct));

	/*
	 * get required arguments for vnot
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vnot->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vnot->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnot->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vnot->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vnot->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vnot->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vnot->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnot->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vnot->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vnot->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vnot->l_flag = vget_float(fid, prompt_flag,
			"-l", l_pstr, &(vnot->l_float),
			255.000000, 255.000000, 255.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnot->l_flag))
		{
		    fprintf(stderr, "\t\tl is required, please re-enter: \n");
		    vnot->l_flag = vget_float(fid, prompt_flag,
		    "-l", l_pstr, &(vnot->l_float),
		    255.000000, 255.000000, 255.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-l' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



