 /*
  * Khoros: $Id: vxor.h,v 1.1 1991/05/10 15:45:30 khoros Exp $
  */

 /*
  * $Log: vxor.h,v $
 * Revision 1.1  1991/05/10  15:45:30  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vxor.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Wed Mar 27 23:56:03 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vxor_h_
#define _vxor_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vxor Argument Structure
*
****************************************************************/

typedef struct _vxor  {

/*
 *  first input image (Required infile)
 */
char	*i1_file;	/* first input image FILENAME */
int	 i1_flag;	/* first input image FLAG */

/*
 *  second input image (Required infile)
 */
char	*i2_file;	/* second input image FILENAME */
int	 i2_flag;	/* second input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

}  vxor_struct;

vxor_struct *vxor;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
map_enable = VFF_MAP_OPTIONAL

and verifies that img1 and img2 match for
the above fields and also
data_storage_type
col_size
row_size.
*/

#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE)
/* -include_macros_end */

#endif
