 /*
  * Khoros: $Id: lvsubstit.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvsubstit.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvsubstit.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvsubstit.c
 >>>>
 >>>>      Program Name: vsubstit
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:19:47 1991 
 >>>>
 >>>>          Routines: lvsubstit - the library call for vsubstit
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvsubstit - library call for vsubstit
*
* Purpose:
*    
*    Substitute each occurence of a  given  pixel  value  with  a
*    different value
*    
*    
* Input:
*    
*    img            VIFF image structure, must be a byte image.
*    
*    old            old pixel value, to be replaced
*    
*    new            new pixel value
*    
*    
* Output:
*    
*    img2           VIFF image structure, image with designated  pixel
*                   values replaced
*    
*    
*
* Written By: Greg Donohoe
*    
*    
****************************************************************/


/* -library_def */
int
lvsubstit(image,old,new)
struct xvimage *image;
int old, new;
/* -library_def_end */

/* -library_code */
{
    int nc,        /* number of columns of image */ 
        nr;        /*   "    "  rows    "  "    */

    char   *program = "lvsubstit";

    int i,k;
    unsigned char *c1; 

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Input image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nc = image->row_size; /* number of columns */
    nr = image->col_size; /* number of rows    */

    c1 = (unsigned char *)(image->imagedata); /* pointer to image's pixels */

    k = nc * nr; /* total number of pixels in the input image */
                                
    /* Scans  and affects the final value of the result image */
    for (i=0; i<k; i++,c1++) 
       if (*c1 == old)
          *c1 = (unsigned char)new;
    
    return(1);
}
/* -library_code_end */
