 /*
  * Khoros: $Id: lvprmap.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvprmap.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvprmap.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvprmap.c
 >>>>
 >>>>      Program Name: vprmap
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:34:12 1991 
 >>>>
 >>>>          Routines: lvprmap - the library call for vprmap
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvprmap - library call for vprmap
*
* Purpose:
*    
*    vprmap prints to a file or the  screen  xviff  map  data  in
*    ascii format.
*    
*    
* Input:
*    
*         An image in xviff,
*         A flag, used for specifing the format for printing.
*         input_file - file name of the viff image
*         printdev _ an File where to write the colormap values
*    
*    
* Output:
*    
*         The colormaps values are send to the printdev
*    
*    
*
* Written By: Tom Sauer
*    
*    Ghosted by Pascal Adam  (Mon Jun 18, 1990)
*    Charlie Gage (Jan. 30, 1991) Fixed  problem  with  map  type
*    ONEPERBAND.
*    
*    
****************************************************************/


/* -library_def */
int
lvprmap(image,mflag,input_file,printdev)
struct  xvimage *image;
int     mflag;
char    *input_file;
FILE    *printdev;
/* -library_def_end */

/* -library_code */
{

unsigned char *cptr;
short *sptr;
int   *iptr;
float *fptr;
char *program = "lvprmap";
int i;

    /* only one image allowed */
    if ( !proper_num_images(program, image, 1, FALSE) ) {
        (void) fprintf(stderr,
              "%s: Only one image per file is allowed.\n",
               program);
        return(0);
    }
  
/*  Print out the row and column size information */

    (void) fprintf(printdev,"\nXVIFF File name: %s.\n",input_file);

    (void) fprintf(printdev,"\nMap size, type and values.\n");
    (void) fprintf(printdev,"---------------------------------\n");
    (void) fprintf(printdev,"Number of Columns in Map = %d\n",image->map_row_size);
    (void) fprintf(printdev,"Number of Rows in Map = %d\n",image->map_col_size);

    
     /* compute the number of columns and maps to print */

    switch(image->map_scheme) {
      case VFF_MS_NONE:
       (void) fprintf(printdev,"Data Band Mapping scheme: NONE\n");
        (void) fprintf(stderr,
              "%s: Error No Map Data to Print, Map Scheme = NONE\n",
               program);
        return(0);
        break;
      case VFF_MS_ONEPERBAND:
        (void) fprintf(printdev,"Data Band Mapping scheme: ONE PER BAND\n");
         switch(image->map_storage_type) {
           case VFF_MAPTYP_1_BYTE:
             (void) fprintf(printdev,"Map storage type: BYTE\n");
             cptr = (unsigned char *)image->maps;
             for ( i = 0 ; i < image->num_data_bands ; i++ ) {
                (void) fprintf(printdev,"\n\nMap For Data Band Number %d\n",i);
                (void) fprintf(printdev,"---------------------------------\n");
                print_map_byte(image, mflag, cptr, printdev);
                cptr += (image->map_col_size * image->map_row_size);
             }
             break;
           case VFF_MAPTYP_2_BYTE:
             (void) fprintf(printdev,"Map storage type: SHORT\n");
             sptr = (short *)image->maps;
             for ( i = 0 ; i < image->num_data_bands ; i++ ) {
                (void) fprintf(printdev,"\n\nMap For Data Band Number %d\n",i);
                (void) fprintf(printdev,"---------------------------------\n");
                print_map_short(image, mflag, sptr, printdev);
                sptr += (image->map_col_size * image->map_row_size);
             }
             break;
           case VFF_MAPTYP_4_BYTE:
             (void) fprintf(printdev,"Map storage type: INTEGER\n");
             iptr = (int *)image->maps;
             for ( i = 0 ; i < image->num_data_bands ; i++ ) {
                (void) fprintf(printdev,"\n\nMap For Data Band Number %d\n",i);
                (void) fprintf(printdev,"---------------------------------\n");
                print_map_int(image, mflag, iptr, printdev);
                iptr += (image->map_col_size * image->map_row_size);
             }
             break;
           case VFF_MAPTYP_FLOAT:
             (void) fprintf(printdev,"Map storage type: FLOAT\n");
             fptr = (float *)image->maps;
             for ( i = 0 ; i < image->num_data_bands ; i++ ) {
                (void) fprintf(printdev,"\n\nMap For Data Band Number %d\n",i);
                (void) fprintf(printdev,"---------------------------------\n");
                print_map_float(image, mflag, fptr, printdev);
                fptr += (image->map_col_size * image->map_row_size);
             }
             break;
           case VFF_MAPTYP_COMPLEX:
             (void) fprintf(printdev,"Map storage type: COMPLEX\n");
             fptr = (float *)image->maps;
             for ( i = 0 ; i < image->num_data_bands ; i++ ) {
                (void) fprintf(printdev,"\n\nMap For Data Band Number %d\n",i);
                (void) fprintf(printdev,"---------------------------------\n");
                print_map_complex(image, mflag, fptr, printdev);
                fptr += (image->map_col_size * image->map_row_size * 2);
             }
             break;
          default:
            (void) fprintf(stderr,"%s: Error unknown map storage type\n",program);
            return(0);
            break;
      }  /* end switch on map_storage-type */
      break;

      case VFF_MS_SHARED:
       (void) fprintf(printdev,"Data Band Mapping scheme: SHARED\n");
        switch(image->map_storage_type) {
           case VFF_MAPTYP_1_BYTE:
             (void) fprintf(printdev,"Map storage type: BYTE\n");
             cptr = (unsigned char *)image->maps;
             print_map_byte(image, mflag, cptr, printdev);
             break;
           case VFF_MAPTYP_2_BYTE:
             (void) fprintf(printdev,"Map storage type: SHORT\n");
             sptr = (short *)image->maps;
             print_map_short(image, mflag, sptr, printdev);
             break;
           case VFF_MAPTYP_4_BYTE:
             (void) fprintf(printdev,"Map storage type: INTEGER\n");
             iptr = (int *)image->maps;
             print_map_int(image, mflag, iptr, printdev);
             break;
           case VFF_MAPTYP_FLOAT:
             (void) fprintf(printdev,"Map storage type: FLOAT\n");
             fptr = (float *)image->maps;
             print_map_float(image, mflag, fptr, printdev);
             break;
           case VFF_MAPTYP_COMPLEX:
             (void) fprintf(printdev,"Map storage type: COMPLEX\n");
             fptr = (float *)image->maps;
             print_map_float(image, mflag, fptr, printdev);
             break;
           default:
             (void) fprintf(stderr,
                     "%s: Error unknown map storage type\n",program);
            return(0);
            break;
        }  /* end switch on map_storage-type */
        break;
      default:
        (void) fprintf(stderr,
             "%s:Error Can not Print Data for Specified Map Scheme\n",
               program);
        return(0);
        break;
    }
    return(1);
}



/**************************************************************
*
* MODULE NAME:  print_map_byte
*
*     PURPOSE:  Prints out map values for map storage scheme 
*               byte.
*
*       INPUT: struct xvimage *image - the actual data
*               unsigned char *cptr - pointer to the map
*               int mflag - how to print the map
*
*      OUTPUT: to stdout, map values.
*
* CALLED FROM:  lvprmap
*
* ROUTINES CALLED:
*
**************************************************************/

print_map_byte(image, mflag, cptr, printdev)
struct xvimage *image;
unsigned char *cptr;
FILE    *printdev;

{
       int j, k, count;
       
       for ( j = 0 ; j < image->map_row_size; j++ ) {
           (void) fprintf(printdev,"\n\nMap Column Number %d\n",j+1);
           (void) fprintf(printdev,"=================================\n\n");
           count =0;
           for (k=0;k<image->map_col_size;k++) 
           {
              if (mflag) {   /* just print the colormap values */
                 (void) fprintf(printdev,"%4d ",*cptr++);
                  if (++count % 10 == 0) (void) fprintf(printdev,"\n");
              }
             else {         /* print c_maps values with indicies */
                 (void) fprintf(printdev,"[%d] = %4d ",count++,*cptr++);
                 if (count % 5 == 0) (void) fprintf(printdev,"\n");
             }
           }
       }
       (void) fprintf(printdev,"\n\n");
}

/**************************************************************
*
* MODULE NAME:  print_map_short
*
*     PURPOSE:  Prints out map values for map storage scheme 
*               short.
*
*       INPUT: struct xvimage *image - the actual data
*               unsigned char *cptr - pointer to the map
*               int mflag - how to print the map
*
*      OUTPUT: to stdout, map values.
*
* CALLED FROM:  lvprmap
*
* ROUTINES CALLED:
*
**************************************************************/

print_map_short(image, mflag, sptr, printdev)
struct xvimage *image;
short *sptr;
FILE    *printdev;

{
       int j, k, count;

       for ( j = 0 ; j < image->map_row_size; j++ )
       {
           (void) fprintf(printdev,"\n\nMap Column Number %d\n",j);
           (void) fprintf(printdev,"=================================\n\n");
           count =0;
           for (k=0;k<image->map_col_size;k++) 
           {
              if (mflag)    /* just print the colormap values */
              {
                 (void) fprintf(printdev,"%d ",*sptr++);
                  if (++count % 10 == 0)
                      (void) fprintf(printdev,"\n");
              }
             else          /* print c_maps values with indicies */
             {
                 (void) fprintf(printdev,"[%d] = %d ",count++,*sptr++);
                 if (count % 5 == 0)
                    (void) fprintf(printdev,"\n");
             }
           }
       }
       (void) fprintf(printdev,"\n\n");
}

/**************************************************************
*
* MODULE NAME:  print_map_int
*
*     PURPOSE:  Prints out map values for map storage scheme 
*               int.
*
*       INPUT: struct xvimage *image - the actual data
*               unsigned char *cptr - pointer to the map
*               int mflag - how to print the map
*
*      OUTPUT: to stdout, map values.
*
* CALLED FROM:  lvprmap
*
* ROUTINES CALLED:
*
**************************************************************/

print_map_int(image, mflag, iptr, printdev)
struct xvimage *image;
short *iptr;
FILE    *printdev;

{
       int j, k, count;

       for ( j = 0 ; j < image->map_row_size; j++ ) {
           (void) fprintf(printdev,"\n\nMap Column Number %d\n",j);
           (void) fprintf(printdev,"=================================\n\n");
           count =0;
           for (k=0;k<image->map_col_size;k++) 
           {
              if (mflag) {   /* just print the colormap values */
                 (void) fprintf(printdev,"%4 ",*iptr++);
                  if (++count % 10 == 0) (void) fprintf(printdev,"\n");
              }
             else {         /* print c_maps values with indicies */
                 (void) fprintf(printdev,"[%d] = %d ",count++,*iptr++);
                 if (count % 5 == 0) (void) fprintf(printdev,"\n");
             }
           }
       }
      (void) fprintf(printdev,"\n\n");
}

/**************************************************************
*
* MODULE NAME:  print_map_float
*
*     PURPOSE:  Prints out map values for map storage scheme 
*               float.
*
*       INPUT: struct xvimage *image - the actual data
*               unsigned char *cptr - pointer to the map
*               int mflag - how to print the map
*
*      OUTPUT: to stdout, map values.
*
* CALLED FROM:  lvprmap
*
* ROUTINES CALLED:
*
**************************************************************/

print_map_float(image, mflag, fptr, printdev)
struct xvimage *image;
float *fptr;
FILE    *printdev;

{
      int j, k, count;

      for ( j = 0 ; j < image->map_row_size; j++ ) {
          (void) fprintf(printdev,"\n\nMap Column Number %d\n",j);
          (void) fprintf(printdev,"=================================\n\n");
          count =0;
          for (k=0;k<image->map_col_size;k++) 
          {
             if (mflag) {   /* just print the colormap values */
                (void) fprintf(printdev,"%f ",*fptr++);
                 if (++count % 10 == 0) (void) fprintf(printdev,"\n");
             }
            else {         /* print c_maps values with indicies */
                (void) fprintf(printdev,"[%d] = %f ",count++,*fptr++);
                if (count % 5 == 0) (void) fprintf(printdev,"\n");
            }
          }
      }
      (void) fprintf(printdev,"\n\n");
}

/**************************************************************
*
* MODULE NAME:  print_map_complex
*
*     PURPOSE:  Prints out map values for map storage scheme 
*               complex.
*
*       INPUT: struct xvimage *image - the actual data
*               unsigned char *cptr - pointer to the map
*               int mflag - how to print the map
*
*      OUTPUT: to stdout, map values.
*
* CALLED FROM:  lvprmap
*
* ROUTINES CALLED:
*
**************************************************************/

print_map_complex(image, mflag, fptr, printdev)
struct xvimage *image;
float *fptr;
FILE    *printdev;

{

      int j, k, count;

      for ( j = 0 ; j < image->map_row_size; j++ ) {
          (void) fprintf(printdev,"\n\nMap Column Number %d\n",j);
          (void) fprintf(printdev,"=================================\n\n");
          count = 0;
          for (k=0;k<image->map_col_size;k++) 
          {
             if (mflag) {   /* just print the colormap values */
               (void) fprintf(printdev,"Real: %f\n ",*fptr++);
               (void) fprintf(printdev,"Imag: %f\n ",*fptr++);
             }
            else {         /* print c_maps values with indicies */
              (void) fprintf(printdev,"Real[%d] = %f\n ",count,*fptr++);
              (void) fprintf(printdev,"Imag[%d] = %f\n",count++,*fptr++);
            }
          }
      }
      (void) fprintf(printdev,"\n\n");
}
/* -library_code_end */
