 /*
  * Khoros: $Id: lvflip.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvflip.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvflip.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvflip.c
 >>>>
 >>>>      Program Name: vflip
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:49:07 1991 
 >>>>
 >>>>          Routines: lvflip - the library call for vflip
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvflip - library call for vflip
*
* Purpose:
*    
*    Flip (or reflect) an image
*    
*    
* Input:
*    
*    image          pointer to the xvimage structure to be processed
*    
*    r              if nonzero, then do right-for-left flip (int)
*    
*    t              if nonzero, then do top-for-bottom flip (int)
*    
*    
* Output:
*    
*    image          holds the result of  the  operation.   The  output
*                   data type is the same as the input data type.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    
****************************************************************/


/* -library_def */
int
lvflip(image,r,t)
struct xvimage *image;
int r,t;
/* -library_def_end */

/* -library_code */
  {
    int rows,cols,i,j,k,r2,c2,nb,k1,k2,bo;
    unsigned char *c,ct;
    short *s,st;
    int *n,nt;
    float *f,ft;

    nb = image->num_data_bands;
    rows = image->col_size;
    cols = image->row_size;
    bo = rows*cols;
    r2 = rows/2;
    c2 = cols/2;

    switch(image->data_storage_type)
      {
      case VFF_TYP_1_BYTE:
        c = (unsigned char *)(image->imagedata);
        if (r)
          {
            for (i=0; i<c2; i++)
              {
                for (j=0; j<rows; j++)
                  {
                    for (k=0; k<nb; k++)
                      {
                        k1 = k*bo+j*cols+i;
                        k2 = k*bo+j*cols+cols-i-1;
                        ct = c[k1]; c[k1] = c[k2]; c[k2] = ct;
                      }
                  }
              }
          }
        if (t)
          {
            for (i=0; i<cols; i++)
              {
                for (j=0; j<r2; j++)
                  {
                    for (k=0; k<nb; k++)
                      {
                         k1 = k*bo+j*cols+i;
                         k2 = k*bo+(rows-j-1)*cols+i;
                         ct = c[k1]; c[k1] = c[k2]; c[k2] = ct;
                      }
                  }
              }
          }
        break;
      case VFF_TYP_2_BYTE:
      s = (short *)(image->imagedata);
      if (r)
        {
          for (i=0; i<c2; i++)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+j*cols+cols-i-1;
                      st = s[k1]; s[k1] = s[k2]; s[k2] = st;
                    }
                }
            }
        }
      if (t)
        {
          for (i=0; i<cols; i++)
            {
              for (j=0; j<r2; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+(rows-j-1)*cols+i;
                      st = s[k1]; s[k1] = s[k2]; s[k2] = st;
                    }
                }
            }
        }
      break;
    case VFF_TYP_4_BYTE:
      n = (int *)(image->imagedata);
      if (r)
        {
          for (i=0; i<c2; i++)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+j*cols+cols-i-1;
                      nt = n[k1]; n[k1] = n[k2]; n[k2] = nt;
                    }
                }
            }
        }
      if (t)
        {
          for (i=0; i<cols; i++)
            {
              for (j=0; j<r2; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+(rows-j-1)*cols+i;
                      nt = n[k1]; n[k1] = n[k2]; n[k2] = nt;
                    }
                }
            }
        }
      break;
    case VFF_TYP_FLOAT:
      f = (float *)(image->imagedata);
      if (r)
        {
          for (i=0; i<c2; i++)
            {
              for (j=0; j<rows; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+j*cols+cols-i-1;
                      ft = f[k1]; f[k1] = f[k2]; f[k2] = ft;
                    }
                }
            }
        }
      if (t)
        {
          for (i=0; i<cols; i++)
            {
              for (j=0; j<r2; j++)
                {
                  for (k=0; k<nb; k++)
                    {
                      k1 = k*bo+j*cols+i;
                      k2 = k*bo+(rows-j-1)*cols+i;
                      ft = f[k1]; f[k1] = f[k2]; f[k2] = ft;
                    }
                }
            }
        }
      break;
    default:
      fprintf(stderr,"lvflip: Unsupported data storage type\n");
      return(0);
    }
    return(1);
  }
/* -library_code_end */
