 /*
  * Khoros: $Id: lvexpand.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvexpand.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvexpand.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvexpand.c
 >>>>
 >>>>      Program Name: vexpand
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:48:42 1991 
 >>>>
 >>>>          Routines: lvexpand - the library call for vexpand
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvexpand - library call for vexpand
*
* Purpose:
*    
*    Expand an image by pixel replication
*    
*    
* Input:
*    
*    image          pointer to image structure to be expanded
*    
*    scale          scale  factor  by  which  to  expand   the   image
*                   (integer), must be postitive and non-zero
*    
*    
* Output:
*    
*    image          points to the image structure that has  been  pro-
*                   cessed.  The  output  data type is the same as the
*                   input data type.
*    
*    Return Value:  1 on success, 0 on failure
*    
*    
*
* Written By: Scott Wilson
*    
*    Scott Wilson - Added multiband support 20-Sep-90
*    
*    
****************************************************************/


/* -library_def */
int
lvexpand(image,scale)
struct xvimage *image;
int  scale;
/* -library_def_end */

/* -library_code */
{
    int j,k,x,y;
    char *malloc();
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float *f1,*f2;
    int size;
    int rows,cols;
    int bands,nb,b1,b2;

    if(scale < 1){
       (void) (void) fprintf(stderr,"lvexpand: Invalid shrink factor\n");
       return(0);}

    rows = image->col_size;
    cols = image->row_size;
    nb = image->num_data_bands;
    b1 = rows*cols;
    b2 = b1*scale*scale;

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvexpand: Don't know how to expand a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          size = sizeof(unsigned char)*scale*scale*rows*cols*nb;
          c1 = (unsigned char *)(image->imagedata);
          c2 = (unsigned char *)malloc(size);
          if (c2 == NULL)
            {
              fprintf(stderr,"lvexpand: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (bands=0; bands<nb; bands++)
                for (y=0; y<scale; y++)
                  for (x=0; x<scale; x++)
                    *(c2+bands*b2+j*scale*scale*cols+y*scale*cols+(k*scale)+x) =
                      *(c1+bands*b1+j*cols+k);
          image->row_size = scale*cols;
          image->col_size = scale*rows;
          image->imagedata = (char *)c2;
          break;
        case VFF_TYP_2_BYTE :
          size = sizeof(short)*scale*scale*rows*cols*nb;
          s1 = (short *)(image->imagedata);
          s2 = (short *)malloc(size);
          if (s2 == NULL)
            {
              fprintf(stderr,"lvexpand: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (bands=0; bands<nb; bands++)
                for (y=0; y<scale; y++)
                  for (x=0; x<scale; x++)
                    *(s2+bands*b2+j*scale*scale*cols+y*scale*cols+(k*scale)+x) =
                      *(s1+bands*b1+j*cols+k);
          image->row_size = scale*cols;
          image->col_size = scale*rows;
          image->imagedata = (char *)s2;
          break;
        case VFF_TYP_4_BYTE :
          size = sizeof(int)*scale*scale*rows*cols*nb;
          i1 = (int *)(image->imagedata);
          i2 = (int *)malloc(size);
          if (i2 == NULL)
            {
              fprintf(stderr,"lvexpand: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (bands=0; bands<nb; bands++)
                for (y=0; y<scale; y++)
                  for (x=0; x<scale; x++)
                    *(i2+bands*b2+j*scale*scale*cols+y*scale*cols+(k*scale)+x) =
                      *(i1+bands*b1+j*cols+k);
          image->row_size = scale*cols;
          image->col_size = scale*rows;
          image->imagedata = (char *)i2;
          break;
        case VFF_TYP_FLOAT :
          size = sizeof(float)*scale*scale*rows*cols*nb;
          f1 = (float *)(image->imagedata);
          f2 = (float *)malloc(size);
          if (f2 == NULL)
            {
              fprintf(stderr,"lvexpand: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (bands=0; bands<nb; bands++)
                for (y=0; y<scale; y++)
                  for (x=0; x<scale; x++)
                    *(f2+bands*b2+j*scale*scale*cols+y*scale*cols+(k*scale)+x) =
                      *(f1+bands*b1+j*cols+k);
          image->row_size = scale*cols;
          image->col_size = scale*rows;
          image->imagedata = (char *)f2;
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvexpand: COMPLEX not supported (yet)\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvexpand: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
