 /*
  * Khoros: $Id: lvdith45.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdith45.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvdith45.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdith45.c
 >>>>
 >>>>      Program Name: vdith45
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:07:56 1991 
 >>>>
 >>>>          Routines: lvdith45 - the library call for vdith45
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* 45 degree dither matrix */
unsigned char t[8][8] = { 52,  44,  36, 124, 132, 140, 148, 156,
                          60,   4,  28, 116, 220, 228, 236, 164,
                          68,  12,  20, 108, 212, 252, 244, 172,
                          76,  84,  92, 100, 204, 196, 188, 180,
                         132, 140, 148, 156,  52,  44,  36, 124,
                         200, 228, 236, 164,  60,   4,  28, 116,
                         212, 252, 244, 172,  68,  12,  20, 108,
                         204, 196, 188, 180,  76,  84,  92, 100 };
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdith45 - library call for vdith45
*
* Purpose:
*    
*    Perform  dithering   using   ordered   (matrix)   technique,
*    optimized for 45 degrees.
*    
*    
* Input:
*    
*    image          xvimage structure containing the  character  image
*                   to be dithered.
*    
*    
* Output:
*    
*    image          holds the result of the dithered image.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran (1/12/88) Converted to new xvstruct.
*    
*    Mark Young (5/9/88)  Changed bitmap padding from 16 to 8 bits.
*    
*    
****************************************************************/


/* -library_def */
int
lvdith45(image)
struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
    register int it,jt,i,j,k,n;
    int  bmsize;
    char *malloc();
    unsigned char *cptr, *bptr, *b, bit;

    if (image->data_storage_type != VFF_TYP_1_BYTE)
    {
       (void) fprintf(stderr,"lvdit45: Image must of of type BYTE.\n");
       return(0);
    }

    n = 8;                                         /* Size of dither matrix */
    it = 0;                                        /* Matrix index point */

    cptr = (unsigned char *)(image->imagedata);
    for(i=0;i<image->col_size;i++)                 /* For each line */
      {
        jt = 0;
        for(j=0;j<image->row_size;j++)             /* For each pixel */
          {
            if(t[it][jt] > *cptr) *cptr = 0;
            else *cptr = ~0;
            cptr++;
            jt=(jt+1)%n;                         /* Advance index point */
          }
        it=(it+1)%n;                             /* Advance index point */
      }
    bmsize = ((image->row_size + 7)/8)*image->col_size;
    bptr = (unsigned char *)malloc(bmsize);
    if (bptr == NULL) {
        fprintf(stderr,"vdith45: unable to allocate memory.\n");
        return(0);
    }
    b = bptr;
    cptr = (unsigned char *)(image->imagedata);
    for (i=0; i<image->col_size; i++)
      {
        k = 0;
        for (j=0; j<image->row_size; j++)
          {
            bit = 1 << k;      /* Bit to set or clear */
            if (*cptr++ > 128) *b = *b | bit;
            else *b = *b & ~bit;
            if (k == 7)
              {
                k = 0;
                b++;
              }
            else k++;
          }
        if (k != 0)
          {
            for (j=k; j<8; j++) *b = *b & (~(1 << j));
            b++;
          }
      }
    image->imagedata = (char *)bptr;
    image->data_storage_type =  VFF_TYP_BIT;

    return(1);
}
/* -library_code_end */
