 /*
  * Khoros: $Id: lvctor.c,v 1.2 1992/03/20 23:05:08 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvctor.c,v 1.2 1992/03/20 23:05:08 dkhoros Exp $";
#endif

 /*
  * $Log: lvctor.c,v $
 * Revision 1.2  1992/03/20  23:05:08  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvctor.c
 >>>>
 >>>>      Program Name: vctor
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:42:23 1992 
 >>>>
 >>>>          Routines: lvctor - the library call for vctor
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvctor - library call for vctor
*
* Purpose:
*    
*    Convert COMPLEX data to REAL form
*    
*    

* Input:
*    
*    image          pointer to xvimage structure to be processed
*    
*    type           specifies which type of conversion to use
*    
*    

* Output:
*    
*    image          holds the result of the convert operation.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Scott Wilson
*    
*    10-Mar-92 Scott Wilson Added DCOMPLEX  support,  fixed  incorrect
*    documentation, corrected improper malloc().
*    
*    

****************************************************************/


/* -library_def */
lvctor(image,type)
struct xvimage *image;
int type;
/* -library_def_end */

/* -library_code */
{
  unsigned int count;
  int i;
  float *fp,*f,*f2;
  double *dp,*d,*d2;

  count = image->row_size*image->col_size * image->num_data_bands;

  if (image->data_storage_type == VFF_TYP_COMPLEX)
    {
      /* Allocate space for the new float file */
      f = (float *)malloc(count*sizeof(float));
      if (f == NULL)
        {
          fprintf(stderr,"lvctor: Unable to allocate space for new image\n");
          return(0);
        } 
      f2 = f;

      fp = (float *)(image->imagedata);
      switch(type)
        {
          case 2: fp++; /* Imaginary part */
          case 1: /* Real part */
            for (i=0; i<count; i++)
              {
                *f++ = *fp++; fp++;
              }
            break;
          case 3: 
            for (i=0; i<count; i++)
              {
                *f++ = vcabs(*fp,*(fp+1)); fp += 2;
              }
            break;
          case 4: 
            for (i=0; i<count; i++)
               {
                *f++ = cang(*fp,*(fp+1));
                fp += 2;
              }
            break;
          default:
            fprintf(stderr,"lvctor: Unknown conversion type!\n");
            return(0);
            break;
        }
      free(image->imagedata);
      image->imagedata = (char *)f2;
      image->data_storage_type = VFF_TYP_FLOAT;
    }
  else if (image->data_storage_type == VFF_TYP_COMPLEX)
    {
      /* Allocate space for the new double file */
      d = (double *)malloc(count*sizeof(double));
      if (d == NULL)
        {
          fprintf(stderr,"lvctor: Unable to allocate space for new image\n");
          return(0);
        } 
      d2 = d;

      dp = (double *)(image->imagedata);
      switch(type)
        {
          case 2: dp++; /* Imaginary part */
          case 1: /* Real part */
            for (i=0; i<count; i++)
              {
                *d++ = *dp++; dp++;
              }
            break;
          case 3: 
            for (i=0; i<count; i++)
              {
                *d++ = dvcabs(*dp,*(dp+1)); dp += 2;
              }
            break;
          case 4: 
            for (i=0; i<count; i++)
               {
                *d++ = dcang(*dp,*(dp+1));
                dp += 2;
              }
            break;
          default:
            fprintf(stderr,"lvctor: Unknown conversion type!\n");
            return(0);
            break;
        }
      free(image->imagedata);
      image->imagedata = (char *)d2;
      image->data_storage_type = VFF_TYP_DOUBLE;
    }
  else
    {
      fprintf(stderr,"lvctor: Image must be either COMPLEX or DCOMPLEX\n");
      return(0);
    }
  return(1);
}
/* -library_code_end */
