#! /bin/csh -f

# 
#  Khoros: $Id: klnfile_csh.csh,v 1.3 1991/12/18 08:53:46 dkhoros Exp $
#

#
# $Log: klnfile_csh.csh,v $
# Revision 1.3  1991/12/18  08:53:46  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: klnfile_csh                            <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros source configuration
#  >>>>                Makes symbolic linked source trees.
#  >>>>                                                       <<<<
#  >>>> modifications: Modified to work with the toolbox      <<<<
#  >>>>                system. Tom Sauer 9/18/91              <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME:	klnfile_csh
# 
# AUTHORS:	Charlie Gage and Tom Sauer
# 
# DATE:		3/11/91
# 
# DESCRIPTION:	Script used to configure symbolic linked source trees
#		in the srcmach trees listed in the default_mach file.
# 
# MODIFICATIONS:
#              

set noclobber
onintr cleanup
umask 002

#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 3) then
  echo ""
  echo "klnfile: Invalid number of arguments detected."
  echo "Please invoke this script from the C driver program."
  echo ""
  exit 0
endif

# Set up environment variables
#----------------------------------------------------------
if ( ! $?KHOROS_HOME ) then
   echo ""
   echo "klnfile: Error, need KHOROS_HOME environment"
   echo "          variable set to proceed."
   echo ""
   exit 0
endif

set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

#Get the arguments from the driver program
#-----------------------------------------------------
# The arguments are:
#  SOURCE  REMOVE  MACH
#
#  SOURCE (argument 1) specifies the location of the source file
#          The only acceptable input to this argument is the
#          full path to the source file.
#          
#  REMOVE (argument 2) is a flag specifying whether to:
#                remove the link (1) or 
#                create the link (0) [should be default]
#
#  MACH (argument 3) specifies a location to a default_mach file
#         that is different from the default location.  If this 
#         input is _NULL_ then the default path is used.
#      (default location: $KHOROS_HOME/repos/srcconf/default_mach)
#

set SOURCE = $1
set REMOVE = $2
set MACH = $3

set PWD = `pwd`
set FILENAME = $SOURCE:t

# Check for any invalid or empty arguments 
#---------------------------------------------------
if (! -f $SOURCE) then
   echo ""
   echo "klnfile: Error, SOURCE file is invalid."
   echo ""
   exit 1
endif

if ($REMOVE != 1 && $REMOVE != 0) then
   echo ""
   echo "klnfile: Error, invalid entry for REMOVE argument."
   echo " Must be 1 or 0."
   echo ""
   exit 1
endif

set FULLHOST = `hostname`

# Get the proper MACH file
#----------------------------------------------------------------
if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST} ) then 
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach ) then
        set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "klnfile: The mach_def file does not exist"
        echo " Please either specify a mach_def file or create one"
        echo " in $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
           set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "klnfile: Error, the mach file '$MACH' for the toolbox"
           echo " specified was not found. Please create a mach file in"
           echo " in $MACH"
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above
source $MACH

#  Set variables from default_mach file
#-------------------------------------------------
set NUM_MACHINES = $#KHOROS_MACHINES
set NUM_DIR = $#KHOROS_MACH_DIR
set NUM_SRC = $#KHOROS_SRC_TOP

if ($KHOROS_USER == "") then
   echo ""
   echo "klnfile: KHOROS_USER environment variable is not set."
   echo ""
   goto cleanup
endif

if ( ($NUM_MACHINES != $NUM_DIR) && ($NUM_MACHINES != $NUM_SRC) || $NUM_DIR < 1 ) then
   echo ""
   echo "klnfile: Error, incorrect number of entries in the mach file:"
   echo "$MACH"
   echo " Please check that the number of entries in each field"
   echo " is the same (ie. number of entires must correspond)."
   echo "Note, klnfile should only be called if srcmachs are being used."
   echo ""
   goto cleanup
endif

if (! -d $LOCAL_SRC_TOP) then
   echo ""
   echo "klnfile: Error, the LOCAL_SRC_TOP field is not set."
   echo "Please set this field in the mach file:"
   echo "$MACH"
   echo ""
   goto cleanup
endif

# Check to see if .rhosts file exists, if not then
# copy over the .rhosts.bk to .rhosts for the rsh to work
#-----------------------------------------------------
if ( ! -e ~$KHOROS_USER/.rhosts && $NUM_MACHINES > 0) then
  if ( ! -e ~$KHOROS_USER/.rhosts.bk) then
     echo "Please set up a .rhost file in ~$KHOROS_USER"
     goto cleanup
  else
   echo ""
   echo "Copying ~$KHOROS_USER/.rhosts.bk to ~$KHOROS_USER/.rhosts"
   echo ""
   \cp ~$KHOROS_USER/.rhosts.bk ~$KHOROS_USER/.rhosts
 endif
endif

set FULLPATH = $SOURCE

# foreach machdir make the symbolic link for the input file
#------------------------------------------------------------

if ($FULLPATH != $LOCAL_SRC_TOP) then
   set FILEPATH = `echo $FULLPATH | sed -e "s|$LOCAL_SRC_TOP/||"`
else
   set FILEPATH
endif

  if (! -f $LOCAL_SRC_TOP/$FILEPATH) then
        echo ""
        echo "klnfile: The source file:"
        echo "         $LOCAL_SRC_TOP/$FILEPATH "
        echo "is invalid. Please check that the"
	echo " '$MACH' "
	echo "file is correct," echo "and the source path is correct"
        echo ""
        goto cleanup
  endif


#  Make the symbolic link for each machine
#-------------------------------------------------------------

if ($REMOVE == 0) then           # MAKE the links
  @ i = 1
  foreach machine ($KHOROS_MACHINES)
       set DESTFILE = $KHOROS_MACH_DIR[$i]/$FILEPATH
       set HOMEFILE = $KHOROS_SRC_TOP[$i]/$FILEPATH
       echo ""
       echo "klnfile: Making link in $KHOROS_MACH_DIR[$i]"
       echo ""
       rsh $machine -l $KHOROS_USER \
          "umask 002; \
          touch /tmp/make.$$; \
          if (-f $HOMEFILE) then \
             if (! -f $DESTFILE) then \
                ln -s $HOMEFILE $DESTFILE  >>& /tmp/make.$$; \
                echo "Making link on $machine for $FILENAME" >>& /tmp/make.$$; \
             else \
                echo "$DESTFILE already exists." >>& /tmp/make.$$; \
                echo "The symbolic link was not updated" >>& /tmp/make.$$; \
             endif \
	  else \
	    echo "$HOMEFILE does not exist." >>& /tmp/make.$$; \
	    echo "Can not create the symbolic link to $DESTFILE" >>& /tmp/make.$$; \
	  endif \
          mail -s '"Results from klnfile for $machine"' $KHOROS_MAIL < /tmp/make.$$ ; \
	  \rm -f /tmp/make.$$" &

       echo "done"
  @ i++
  end
else                                   # REMOVE the links
  @ i = 1
  foreach machine ($KHOROS_MACHINES)
       set DESTFILE = $KHOROS_MACH_DIR[$i]/$FILEPATH
       set HOMEFILE = $KHOROS_SRC_TOP[$i]/$FILEPATH
       echo ""
       echo "klnfile: Removing link in $KHOROS_MACH_DIR[$i]"
       echo ""
       rsh $machine -l $KHOROS_USER \
          "umask 002; \
          touch /tmp/make.$$; \
          if (-f $HOMEFILE) then \
             if (-f $DESTFILE) then \
                \rm -f $DESTFILE  >>& /tmp/make.$$; \
                echo "Removing link on $machine for $FILENAME" >>& /tmp/make.$$; \
             else \
                echo "$DESTFILE does not exist." >>& /tmp/make.$$; \
                echo "The symbolic link was not updated" >>& /tmp/make.$$; \
             endif \
	  else \
	     echo "$HOMEFILE does not exist." >>& /tmp/make.$$; \
	     echo "Can not remove the symbolic link to $DESTFILE" >>& /tmp/make.$$; \
	  endif \
          mail -s '"Results from klnfile for $machine"' $KHOROS_MAIL < /tmp/make.$$ ; \
	  \rm -f /tmp/make.$$" &

       echo "done"
  @ i++
  end
endif  

cleanup:
# Clean up variables
#--------------------------------------------------
unset KHOROS_USER
unset KHOROS_MACHINES
unset KHOROS_MACH_DIR
unset KHOROS_SRC_TOP
unset LOCAL_SRC_TOP

exit 0	# normal exit
