 /*
  * Khoros: $Id: klndir.c,v 1.2 1991/10/01 23:56:02 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: klndir.c,v 1.2 1991/10/01 23:56:02 khoros Exp $";
#endif

 /*
  * $Log: klndir.c,v $
 * Revision 1.2  1991/10/01  23:56:02  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: klndir.c
 >>>>
 >>>>      Program Name: klndir
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Used to create a symbolicly linked source tree
 >>>>	
 >>>>	

 >>>>            Author: Ron E. Neher, Danielle Argiro
 >>>>
 >>>> Date Last Updated: Wed Sep 25 22:11:15 1991
 >>>>
 >>>>          Routines: main- the main program for klndir
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "klndir.h"


/****************************************************************
 *
 * Routine Name:  main program for klndir
 *
 *       Input:  
 *        -source  specifies the path to the directory of source files 
 *        -dest  specifies the path to the directory of dest files 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        char *source_fullpath, *dest_fullpath, buffer[BUFSIZE];
        char *vfullpath();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        
        /*
         *  make sure that the source directory exists, and that it is
         *  accessible by the user
         */
        if ((source_fullpath = vfullpath(klndir->source_string, NULL, NULL)) == NULL)
        {
            fprintf(stderr, "klndir:\n");
            fprintf(stderr, "Can't expand input source directory path %s\n",
                     klndir->source_string);
        }

        /*
         *  make sure that the dest directory exists, and that it is
         *  accessible by the user
         */
        if ((dest_fullpath = vfullpath(klndir->dest_string, NULL, NULL)) == NULL)
        {
            fprintf(stderr, "klndir:\n");
            fprintf(stderr, "Can't expand input dest directory path %s\n",
                     klndir->dest_string);
        }

/* -main_before_lib_call_end */

/* -main_library_call */

        /*
         *  create the call to klndir shell script, and system it off.
         */
        sprintf(buffer, "klndir_csh %s %s", source_fullpath, dest_fullpath);
        system(buffer);

/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for klndir 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "klndir :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tUsed to create a symbolicly linked source tree\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-source  specifies the path to the directory of source files  (string)\n");
	fprintf(stderr,"\t-dest  specifies the path to the directory of dest files  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for klndir\n");
	fprintf(stderr, "\t[-U] Gives the usage for klndir\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called klndir.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses klndir.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for klndir
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*source_pstr = 
	"\nEnter: (source) specifies the path to the directory of source files \n        {string}: "; 
char	*source_def = NULL;
char	*dest_pstr = 
	"\nEnter: (dest) specifies the path to the directory of dest files \n        {string}: "; 
char	*dest_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "klndir", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "klndir.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "klndir: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "klndir.ans");
		}

	     }

	}

	/*
	 * allocate the klndir structure
	 */
	klndir = (klndir_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (klndir_struct));

	/*
	 * get required arguments for klndir
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(klndir->source_flag = vget_string(fid, prompt_flag,
			"-source", source_pstr, &(klndir->source_string),
			source_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(klndir->source_flag))
		{
		    fprintf(stderr, "\t\tsource is required, please re-enter: \n");
		    klndir->source_flag = vget_string(fid, prompt_flag,
		    "-source", source_pstr, &(klndir->source_string),
		    source_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-source' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(klndir->dest_flag = vget_string(fid, prompt_flag,
			"-dest", dest_pstr, &(klndir->dest_string),
			dest_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(klndir->dest_flag))
		{
		    fprintf(stderr, "\t\tdest is required, please re-enter: \n");
		    klndir->dest_flag = vget_string(fid, prompt_flag,
		    "-dest", dest_pstr, &(klndir->dest_string),
		    dest_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dest' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



