 /*
  * Khoros: $Id: do_imkmf.c,v 1.2 1991/10/01 23:57:24 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: do_imkmf.c,v 1.2 1991/10/01 23:57:24 khoros Exp $";
#endif

 /*
  * $Log: do_imkmf.c,v $
 * Revision 1.2  1991/10/01  23:57:24  khoros
 * HellPatch2
 *
  */ 


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: do_imkmf.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description: This file contains the "guts" of       <<<<
   >>>>                what `imkmf' is and should be fairly   <<<<
   >>>>                easy to interpret.                     <<<<
   >>>>                                                       <<<<
   >>>>      routines: do_imkmf                               <<<<
   >>>>                                                       <<<<
   >>>>        author: W. Tait Cyrus -- May 31, 1990          <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	

#include "imkmf.h"

char buffer[ MAXLINE ];
char token[ MAXLINE ];
int moved;

FILE *infile;
FILE *outfile;

do_imkmf()
   {
   int replace;
   struct stat filestatus;

   signal( SIGHUP, hardfinish );
   signal( SIGINT, hardfinish );
   signal( SIGQUIT, hardfinish );

   if( !imkmf->o_flag ) {
      imkmf->o_file = IMAKEFILE;
     }

   if( !imkmf->toolbox_flag || imkmf->toolbox_string == NULL)
	imkmf->toolbox_string = VStrcpy(TOOLBOX);

   if( stat( imkmf->o_file, &filestatus ) != 0 ) {
      imkmf_make();
      add_project(imkmf->toolbox_string, outfile);
      }
   else {
      imkmf_update();
      }
   get_dir_info();
   while( get_line( buffer, infile ) ) {
      if( get_1st_token( buffer, token ) ) {
	 if( (replace = need_replace( token )) != -1 ) {
	    write_info( replace, outfile );
	    }
	 else {
		/*
		 * As a special case, we need to look for a #define of
		 * `DoNotAutoUpdate'.  Finding this in the Imakefile
		 * means that the user has changed something that
		 * rerunning imkmf would destroy.  So, if we find this,
		 * we just quit.
		 */
	    if( !strcmp( token, "#define" ) ) {
	       if( get_2nd_token( buffer, token ) ) {
		  if( !strcmp( token, "DoNotAutoUpdate" ) ) {
		     fprintf( stderr,
			 "%s not modified `DoNotAutoUpdate' defined\n",
			 imkmf->o_file );
		     myexit( 1 );
		     }
		  }
	       else rewrite( buffer, outfile );
	       }
	    else rewrite( buffer, outfile );
	    }
	 }
      else fprintf( outfile, "\n" );
      }
   fclose( outfile );
   myexit( 0 );
   }
